/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.base.ch.arzttarife.ambulatory.IAmbulatoryAllowance;
import ch.elexis.base.ch.arzttarife.tardoc.ITardocLeistung;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedLeistung;
import ch.elexis.base.ch.arzttarife.util.ArzttarifeUtil;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.Money;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class ArzttarifDetailDialog
extends Dialog {
    private IBilled billed;
    private Combo cSide;
    private ComboViewer cBezug;

    public ArzttarifDetailDialog(Shell shell, IBilled tl) {
        super(shell);
        this.billed = tl;
    }

    protected Control createDialogArea(Composite parent) {
        IBillable billable = this.billed.getBillable();
        Composite ret = (Composite)super.createDialogArea(parent);
        ret.setLayout((Layout)new GridLayout(8, false));
        Label lTitle = new Label(ret, 64);
        lTitle.setText(billable.getText());
        lTitle.setLayoutData((Object)SWTHelper.getFillGridData((int)8, (boolean)true, (int)1, (boolean)true));
        if (ArzttarifDetailDialog.isArzttarif(billable)) {
            double primaryScale = this.billed.getPrimaryScaleFactor();
            double secondaryScale = this.billed.getSecondaryScaleFactor();
            double tpAL = ArzttarifeUtil.getAL((IBilled)this.billed) / 100.0;
            double tpTL = ArzttarifeUtil.getTL((IBilled)this.billed) / 100.0;
            double tpw = this.billed.getFactor();
            Money mAL = new Money(tpAL * tpw * primaryScale * secondaryScale);
            Money mTL = new Money(tpTL * tpw * primaryScale * secondaryScale);
            double tpAll = (double)Math.round((tpAL + tpTL) * 100.0) / 100.0;
            Money mAll = new Money(tpAll * tpw * primaryScale * secondaryScale);
            new Label(ret, 0).setText("TP AL");
            new Label(ret, 0).setText(Double.toString(tpAL));
            new Label(ret, 0).setText(" x ");
            new Label(ret, 0).setText("TP-Wert");
            new Label(ret, 0).setText(Double.toString(tpw));
            new Label(ret, 0).setText(" = ");
            new Label(ret, 0).setText("CHF AL");
            new Label(ret, 0).setText(mAL.getAmountAsString());
            new Label(ret, 0).setText("TP TL");
            new Label(ret, 0).setText(Double.toString(tpTL));
            new Label(ret, 0).setText(" x ");
            new Label(ret, 0).setText("TP-Wert");
            new Label(ret, 0).setText(Double.toString(tpw));
            new Label(ret, 0).setText(" = ");
            new Label(ret, 0).setText("CHF TL");
            new Label(ret, 0).setText(mTL.getAmountAsString());
            Label sep = new Label(ret, 258);
            sep.setLayoutData((Object)SWTHelper.getFillGridData((int)8, (boolean)true, (int)1, (boolean)false));
            new Label(ret, 0).setText("TP ");
            new Label(ret, 0).setText(Double.toString(tpAll));
            new Label(ret, 0).setText(" x ");
            new Label(ret, 0).setText("TP-Wert");
            new Label(ret, 0).setText(Double.toString(tpw));
            new Label(ret, 0).setText(" = ");
            new Label(ret, 0).setText("CHF ");
            new Label(ret, 0).setText(mAll.getAmountAsString());
            Label sep2 = new Label(ret, 258);
            sep2.setLayoutData((Object)SWTHelper.getFillGridData((int)8, (boolean)true, (int)1, (boolean)false));
            String mins = Integer.toString(this.getMinutesReflective(billable));
            new Label(ret, 0).setText("Zeit:");
            new Label(ret, 0).setText(mins + " min.");
            new Label(ret, 0).setText("Seite");
            this.cSide = new Combo(ret, 4);
            this.cSide.setItems(new String[]{"egal", "links", "rechts"});
            String side = (String)this.billed.getExtInfo((Object)"Seite");
            if (side == null) {
                this.cSide.select(0);
            } else if (side.equalsIgnoreCase("l")) {
                this.cSide.select(1);
            } else {
                this.cSide.select(2);
            }
            if (this.getServiceTypReflective(billable).equals("Z") || this.getServiceTypReflective(billable).equals("R") || this.getServiceTypReflective(billable).equals("B")) {
                new Label(ret, 0);
                new Label(ret, 0);
                new Label(ret, 0).setText("Bezug");
                this.cBezug = new ComboViewer(ret, 2048);
                this.cBezug.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                this.cBezug.setLabelProvider((IBaseLabelProvider)new LabelProvider());
                ArrayList<BezugComboItem> input = new ArrayList<BezugComboItem>();
                input.add(BezugComboItem.noBezug());
                for (IBilled kVerr : this.billed.getEncounter().getBilled()) {
                    if (kVerr.getCode().equals(billable.getCode())) continue;
                    input.add(BezugComboItem.of(kVerr.getCode()));
                }
                this.cBezug.setInput(input);
                String bezug = (String)this.billed.getExtInfo((Object)"Bezug");
                if (bezug != null) {
                    if (!input.contains(BezugComboItem.of(bezug))) {
                        input.add(BezugComboItem.of(bezug));
                        this.cBezug.setInput(input);
                    }
                    this.cBezug.setSelection((ISelection)new StructuredSelection((Object)BezugComboItem.of(bezug)), true);
                } else {
                    this.cBezug.setSelection((ISelection)new StructuredSelection((Object)BezugComboItem.noBezug()), true);
                }
                this.cBezug.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        StructuredSelection selection = (StructuredSelection)ArzttarifDetailDialog.this.cBezug.getSelection();
                        if (selection != null && !selection.isEmpty()) {
                            BezugComboItem selected = (BezugComboItem)selection.getFirstElement();
                            if (selected.isNoBezug) {
                                ArzttarifDetailDialog.this.billed.setExtInfo((Object)"Bezug", (Object)"");
                            } else {
                                ArzttarifDetailDialog.this.billed.setExtInfo((Object)"Bezug", (Object)selected.getCode());
                            }
                        }
                    }
                });
            }
        } else if (ArzttarifDetailDialog.isPauschale(billable)) {
            double tpAll = (double)this.billed.getPoints() / 100.0;
            double tpw = this.billed.getFactor();
            Money mAll = this.billed.getTotal();
            new Label(ret, 0).setText("TP ");
            new Label(ret, 0).setText(Double.toString(tpAll));
            new Label(ret, 0).setText(" x ");
            new Label(ret, 0).setText("TP-Wert");
            new Label(ret, 0).setText(Double.toString(tpw));
            new Label(ret, 0).setText(" = ");
            new Label(ret, 0).setText("CHF ");
            new Label(ret, 0).setText(mAll.getAmountAsString());
        }
        ret.pack();
        return ret;
    }

    private String getServiceTypReflective(IBillable billable) {
        try {
            Method getterMethod = billable.getClass().getMethod("getServiceTyp", null);
            Object typ = getterMethod.invoke((Object)billable, null);
            if (typ instanceof String) {
                return (String)typ;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Could not get service typ of [" + String.valueOf(billable) + "]", (Object)e.getMessage());
        }
        return null;
    }

    private Integer getMinutesReflective(IBillable billable) {
        try {
            Method getterMethod = billable.getClass().getMethod("getMinutes", null);
            Object minutes = getterMethod.invoke((Object)billable, null);
            if (minutes instanceof Integer) {
                return (Integer)minutes;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Could not get minutes of [" + String.valueOf(billable) + "]", (Object)e.getMessage());
        }
        return 0;
    }

    public void create() {
        super.create();
        this.getShell().setText(this.billed.getBillable().getCodeSystemName() + "-Details: " + this.billed.getCode());
    }

    protected void okPressed() {
        int idx = this.cSide.getSelectionIndex();
        if (idx < 1) {
            this.billed.setExtInfo((Object)"Seite", null);
        } else if (idx == 1) {
            this.billed.setExtInfo((Object)"Seite", (Object)"l");
        } else {
            this.billed.setExtInfo((Object)"Seite", (Object)"r");
        }
        CoreModelServiceHolder.get().save((Identifiable)this.billed);
        super.okPressed();
    }

    public static boolean isPauschale(IBillable billable) {
        return billable instanceof IAmbulatoryAllowance;
    }

    public static boolean isArzttarif(IBillable billable) {
        return billable instanceof ITardocLeistung || billable instanceof ITarmedLeistung;
    }

    private static class BezugComboItem {
        private String code;
        private boolean isNoBezug;

        private BezugComboItem() {
        }

        public static BezugComboItem of(String code) {
            BezugComboItem ret = new BezugComboItem();
            ret.setCode(code);
            return ret;
        }

        public static BezugComboItem noBezug() {
            BezugComboItem ret = new BezugComboItem();
            ret.setCode("kein Bezug");
            ret.isNoBezug = true;
            return ret;
        }

        public boolean isNoBezug() {
            return this.isNoBezug;
        }

        private void setCode(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public String toString() {
            return this.getCode();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
            result = 31 * result + (this.isNoBezug ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BezugComboItem other = (BezugComboItem)obj;
            if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
                return false;
            }
            return this.isNoBezug == other.isNoBezug;
        }
    }
}

