/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.base.ch.arzttarife.rfe.IReasonForEncounter;
import ch.elexis.base.ch.arzttarife.rfe.ReasonsForEncounter;
import ch.elexis.base.ch.arzttarife.service.ArzttarifeModelServiceHolder;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;

public class RFEView
extends ViewPart {
    Table longTable;
    Table shortTable;
    Table mediumTable;
    CTabFolder tabs;
    Composite cCalc;
    boolean bDaempfung = false;
    HashMap<String, Integer> mapCodeToIndex = new HashMap();
    HashMap<Integer, String> mapIndexToCode = new HashMap();
    private IEncounter currentEncounter;
    static final int No_More_Valid = 1;

    @Inject
    void selectedEncounter(@Optional IEncounter encounter) {
        this.adjustTable(encounter);
        this.currentEncounter = encounter;
    }

    private void adjustTable(IEncounter encounter) {
        Control c;
        List<Object> rfeForKOns = encounter != null ? this.getReasonsForEncounter(encounter) : Collections.emptyList();
        if (this.tabs == null) {
            return;
        }
        CTabItem top = this.tabs.getSelection();
        if (top != null && (c = top.getControl()) instanceof Table) {
            Table table = (Table)c;
            table.deselectAll();
            TableItem[] tableItemArray = table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                tableItem.setImage(null);
                ++n2;
            }
            for (IReasonForEncounter iReasonForEncounter : rfeForKOns) {
                int idx = this.mapCodeToIndex.get(iReasonForEncounter.getCode());
                TableItem item = table.getItem(idx);
                if (!item.getChecked()) continue;
                item.setImage(Images.IMG_TICK.getImage());
            }
        }
    }

    private List<IReasonForEncounter> getReasonsForEncounter(IEncounter encounter) {
        IQuery query = ArzttarifeModelServiceHolder.get().getQuery(IReasonForEncounter.class);
        query.and("konsID", IQuery.COMPARATOR.EQUALS, (Object)encounter.getId());
        return query.execute();
    }

    private void removeReasonsForEncounter(IEncounter encounter) {
        List<IReasonForEncounter> existingReasons = this.getReasonsForEncounter(encounter);
        existingReasons.forEach(reason -> ArzttarifeModelServiceHolder.get().remove((Identifiable)reason));
    }

    public void createPartControl(Composite parent) {
        this.tabs = new CTabFolder(parent, 1024);
        this.tabs.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        CTabItem ctLong = new CTabItem(this.tabs, 0);
        ctLong.setText("lang");
        this.longTable = new Table((Composite)this.tabs, 65570);
        ctLong.setControl((Control)this.longTable);
        CTabItem ctMedium = new CTabItem(this.tabs, 0);
        ctMedium.setText("kurz");
        this.mediumTable = new Table((Composite)this.tabs, 65570);
        ctMedium.setControl((Control)this.mediumTable);
        CTabItem ctStat = new CTabItem(this.tabs, 0);
        ctStat.setText("Statistik");
        Composite cStat = new Composite((Composite)this.tabs, 0);
        cStat.setLayout((Layout)new GridLayout());
        ctStat.setControl((Control)cStat);
        Button bRecalc = new Button(cStat, 8);
        bRecalc.setText("Berechnen");
        bRecalc.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cCalc = new Composite(cStat, 0);
        this.cCalc.setLayout((Layout)new GridLayout());
        this.cCalc.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        bRecalc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Control[] controlArray = RFEView.this.cCalc.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    c.dispose();
                    ++n2;
                }
                IQuery query = ArzttarifeModelServiceHolder.get().getQuery(IReasonForEncounter.class);
                int[] result = new int[ReasonsForEncounter.getCodeToReasonMap().values().size()];
                int all = 0;
                for (IReasonForEncounter rfe : query.execute()) {
                    int idx;
                    String code = rfe.getCode();
                    if (code.length() != 2) continue;
                    int n3 = idx = RFEView.this.mapCodeToIndex.get(code).intValue();
                    result[n3] = result[n3] + 1;
                    ++all;
                }
                int rline = 0;
                while (rline < result.length) {
                    String code = RFEView.this.mapIndexToCode.get(rline);
                    int num = result[rline];
                    float percent = (float)num * 100.0f / (float)all;
                    int pc = Math.round(percent);
                    Label lbl = new Label(RFEView.this.cCalc, 0);
                    lbl.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
                    lbl.setText(code + ": " + num + " (=" + pc + "%)");
                    ++rline;
                }
                RFEView.this.cCalc.layout(true);
            }
        });
        int i = 0;
        for (String code : ReasonsForEncounter.getCodeToReasonMap().keySet()) {
            TableItem longItem = new TableItem(this.longTable, 0);
            longItem.setText((String)ReasonsForEncounter.getCodeToShortReasonMap().get(code));
            TableItem mediumItem = new TableItem(this.mediumTable, 0);
            mediumItem.setText((String)ReasonsForEncounter.getCodeToReasonMap().get(code));
            this.mapCodeToIndex.put(code, i);
            this.mapIndexToCode.put(i, code);
            if (i == 1) {
                mediumItem.setBackground(UiDesk.getColor((String)"hellgrau"));
                mediumItem.setGrayed(true);
                longItem.setBackground(UiDesk.getColor((String)"hellgrau"));
                longItem.setGrayed(true);
            }
            ++i;
        }
        this.longTable.addSelectionListener((SelectionListener)new ClickListener(this.longTable));
        this.mediumTable.addSelectionListener((SelectionListener)new ClickListener(this.mediumTable));
    }

    public void setFocus() {
    }

    class ClickListener
    extends SelectionAdapter {
        Table table;

        ClickListener(Table table) {
            this.table = table;
        }

        public void widgetSelected(SelectionEvent e) {
            int[] sel;
            if (RFEView.this.currentEncounter != null && (sel = this.table.getSelectionIndices()).length > 0) {
                RFEView.this.removeReasonsForEncounter(RFEView.this.currentEncounter);
                int[] nArray = sel;
                int n = sel.length;
                int n2 = 0;
                while (n2 < n) {
                    int s = nArray[n2];
                    if (s == 1) break;
                    String code = RFEView.this.mapIndexToCode.get(s);
                    IReasonForEncounter reason = (IReasonForEncounter)ArzttarifeModelServiceHolder.get().create(IReasonForEncounter.class);
                    reason.setEncounter(RFEView.this.currentEncounter);
                    reason.setCode(code);
                    ArzttarifeModelServiceHolder.get().save((Identifiable)reason);
                    ++n2;
                }
                RFEView.this.adjustTable(RFEView.this.currentEncounter);
            }
        }
    }
}

