/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.xml.update;

import at.medevit.elexis.tarmed.model.TarmedJaxbUtil;
import ch.elexis.core.model.IBlob;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.fd.invoice440.request.BalanceType;
import ch.fd.invoice440.request.RecordDrugType;
import ch.fd.invoice440.request.RecordTarmedType;
import ch.fd.invoice440.request.RequestType;
import ch.fd.invoice440.request.VatType;
import ch.fd.invoice450.request.BalanceTGType;
import ch.fd.invoice450.request.BalanceTPType;
import ch.fd.invoice450.request.ServiceExType;
import ch.fd.invoice450.request.ServiceType;
import ch.fd.invoice450.request.VatRateType;
import ch.fd.invoice450.request.XtraDrugType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.LoggerFactory;

public class XmlVersionUpdate44to45 {
    private IInvoice invoice;

    public XmlVersionUpdate44to45(IInvoice invoice) {
        this.invoice = invoice;
    }

    public void update() {
        try {
            Optional<?> model44 = this.getExistingXmlModel(this.invoice, "4.4");
            Optional<?> model45 = this.getExistingXmlModel(this.invoice, "4.5");
            if (model44.isPresent() && model45.isPresent()) {
                LoggerFactory.getLogger(this.getClass()).info("Updating tarmed xml 4.4 to 4.5 of invoice [" + this.invoice.getNumber() + "]");
                this.updateBalance((RequestType)model44.get(), (ch.fd.invoice450.request.RequestType)model45.get());
                this.updateServices((RequestType)model44.get(), (ch.fd.invoice450.request.RequestType)model45.get());
                this.setExistingXml(this.invoice, this.getAsJdomDocument((ch.fd.invoice450.request.RequestType)model45.get()).orElse(null));
            } else {
                if (model44.isEmpty()) {
                    LoggerFactory.getLogger(this.getClass()).error("Could not load tarmed 4.4 model of invoice [" + this.invoice.getNumber() + "]");
                }
                if (model45.isEmpty()) {
                    LoggerFactory.getLogger(this.getClass()).error("Could not load tarmed 4.5 model of invoice [" + this.invoice.getNumber() + "]");
                }
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error updating tarmed 4.4 model of invoice [" + this.invoice.getNumber() + "]", (Throwable)e);
        }
    }

    private void updateBalance(RequestType model44, ch.fd.invoice450.request.RequestType model45) {
        BalanceType balance44 = model44.getPayload().getBody().getBalance();
        if (model44.getPayload().getBody().getTiersGarant() != null) {
            BalanceTGType balanceTGType = new BalanceTGType();
            balanceTGType.setCurrency(balance44.getCurrency());
            balanceTGType.setAmountPrepaid(Double.valueOf(balance44.getAmountPrepaid()));
            if (model44.getPayload().getReminder() != null) {
                balanceTGType.setAmountReminder(Double.valueOf(balance44.getAmountReminder()));
            }
            balanceTGType.setAmount(balance44.getAmount());
            balanceTGType.setAmountDue(balance44.getAmountDue());
            balanceTGType.setAmountObligations(Double.valueOf(balance44.getAmountObligations()));
            balanceTGType.setVat(this.updateVat(balance44.getVat()));
            model45.getPayload().getBody().getTiersGarant().setBalance(balanceTGType);
        } else if (model44.getPayload().getBody().getTiersPayant() != null) {
            BalanceTPType balanceTPType = new BalanceTPType();
            balanceTPType.setCurrency(balance44.getCurrency());
            if (model44.getPayload().getReminder() != null) {
                balanceTPType.setAmountReminder(Double.valueOf(balance44.getAmountReminder()));
            }
            balanceTPType.setAmount(balance44.getAmount());
            balanceTPType.setAmountDue(balance44.getAmountDue());
            balanceTPType.setAmountObligations(Double.valueOf(balance44.getAmountObligations()));
            balanceTPType.setVat(this.updateVat(balance44.getVat()));
            model45.getPayload().getBody().getTiersPayant().setBalance(balanceTPType);
        }
    }

    private ch.fd.invoice450.request.VatType updateVat(VatType vat) {
        ch.fd.invoice450.request.VatType vatType = new ch.fd.invoice450.request.VatType();
        if (StringUtils.isNotBlank((CharSequence)vat.getVatNumber())) {
            vatType.setVatNumber(vat.getVatNumber());
        }
        vatType.setVat(vat.getVat());
        for (ch.fd.invoice440.request.VatRateType rate : vat.getVatRate()) {
            VatRateType vatRateType = new VatRateType();
            vatRateType.setVatRate(rate.getVatRate());
            vatRateType.setAmount(rate.getAmount());
            vatRateType.setVat(rate.getVat());
            vatType.getVatRate().add(vatRateType);
        }
        return vatType;
    }

    private void updateServices(RequestType model44, ch.fd.invoice450.request.RequestType model45) {
        for (Object record : model44.getPayload().getBody().getServices().getRecordTarmedOrRecordDrgOrRecordLab()) {
            if (record instanceof RecordTarmedType) {
                ServiceExType serviceExType = new ServiceExType();
                serviceExType.setTreatment("ambulatory");
                serviceExType.setBillingRole("both");
                serviceExType.setMedicalRole("self_employed");
                serviceExType.setRefCode(((RecordTarmedType)record).getRefCode());
                serviceExType.setBodyLocation(((RecordTarmedType)record).getBodyLocation());
                serviceExType.setUnitMt(((RecordTarmedType)record).getUnitMt());
                serviceExType.setUnitFactorMt(((RecordTarmedType)record).getUnitFactorMt());
                serviceExType.setScaleFactorMt(Double.valueOf(((RecordTarmedType)record).getScaleFactorMt()));
                serviceExType.setExternalFactorMt(Double.valueOf(((RecordTarmedType)record).getExternalFactorMt()));
                serviceExType.setAmountMt(Double.valueOf(((RecordTarmedType)record).getAmountMt()));
                serviceExType.setUnitTt(((RecordTarmedType)record).getUnitTt());
                serviceExType.setUnitFactorTt(((RecordTarmedType)record).getUnitFactorTt());
                serviceExType.setScaleFactorTt(Double.valueOf(((RecordTarmedType)record).getScaleFactorTt()));
                serviceExType.setExternalFactorTt(Double.valueOf(((RecordTarmedType)record).getExternalFactorTt()));
                serviceExType.setAmountTt(Double.valueOf(((RecordTarmedType)record).getAmountTt()));
                serviceExType.setAmount(((RecordTarmedType)record).getAmount());
                serviceExType.setVatRate(Double.valueOf(((RecordTarmedType)record).getVatRate()));
                serviceExType.setRemark(((RecordTarmedType)record).getRemark());
                serviceExType.setTariffType(((RecordTarmedType)record).getTariffType());
                serviceExType.setCode(((RecordTarmedType)record).getCode());
                serviceExType.setQuantity(((RecordTarmedType)record).getQuantity());
                serviceExType.setSession(Integer.valueOf(((RecordTarmedType)record).getSession()));
                serviceExType.setName(((RecordTarmedType)record).getName());
                serviceExType.setDateBegin(((RecordTarmedType)record).getDateBegin());
                serviceExType.setProviderId(((RecordTarmedType)record).getProviderId());
                serviceExType.setResponsibleId(((RecordTarmedType)record).getResponsibleId());
                serviceExType.setObligation(Boolean.valueOf(((RecordTarmedType)record).isObligation()));
                serviceExType.setRecordId(((RecordTarmedType)record).getRecordId());
                model45.getPayload().getBody().getServices().getServiceExOrService().add(serviceExType);
                continue;
            }
            ServiceType serviceType = new ServiceType();
            serviceType.setAmount(this.getPropDouble("amount", record).doubleValue());
            serviceType.setVatRate(this.getPropDouble("vatRate", record));
            serviceType.setUnit(this.getPropDouble("unit", record).doubleValue());
            serviceType.setUnitFactor(this.getPropDouble("unitFactor", record));
            serviceType.setTariffType(this.getPropString("tariffType", record));
            serviceType.setCode(this.getPropString("code", record));
            serviceType.setQuantity(this.getPropDouble("quantity", record).doubleValue());
            serviceType.setSession(this.getPropInteger("session", record));
            serviceType.setName(this.getPropString("name", record));
            serviceType.setProviderId(this.getPropString("providerId", record));
            serviceType.setResponsibleId(this.getPropString("responsibleId", record));
            serviceType.setObligation(this.getPropBoolean("obligation", record));
            serviceType.setDateBegin(this.getPropDate("dateBegin", record));
            if (record instanceof RecordDrugType) {
                XtraDrugType drugType = new XtraDrugType();
                if (((RecordDrugType)record).getXtraDrug() != null) {
                    drugType.setIndicated(((RecordDrugType)record).getXtraDrug().isIndicated());
                } else {
                    drugType.setIndicated(Boolean.valueOf(false));
                }
                serviceType.setXtraDrug(drugType);
            }
            serviceType.setRecordId(this.getPropInteger("recordId", record).intValue());
            model45.getPayload().getBody().getServices().getServiceExOrService().add(serviceType);
        }
    }

    private Boolean getPropBoolean(String string, Object record) {
        try {
            return Boolean.parseBoolean(BeanUtils.getProperty((Object)record, (String)string));
        }
        catch (IllegalAccessException | NoSuchMethodException | NumberFormatException | InvocationTargetException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting double value [" + string + "]", (Throwable)e);
            throw new IllegalStateException("Error getting double value [" + string + "]");
        }
    }

    private XMLGregorianCalendar getPropDate(String string, Object record) {
        try {
            String value = BeanUtils.getProperty((Object)record, (String)string);
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(value);
        }
        catch (IllegalAccessException | NoSuchMethodException | NumberFormatException | InvocationTargetException | DatatypeConfigurationException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting double value [" + string + "]", (Throwable)e);
            throw new IllegalStateException("Error getting double value [" + string + "]");
        }
    }

    private Integer getPropInteger(String string, Object record) {
        try {
            return Integer.parseInt(BeanUtils.getProperty((Object)record, (String)string));
        }
        catch (IllegalAccessException | NoSuchMethodException | NumberFormatException | InvocationTargetException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting double value [" + string + "]", (Throwable)e);
            throw new IllegalStateException("Error getting double value [" + string + "]");
        }
    }

    private Double getPropDouble(String string, Object record) {
        try {
            return Double.parseDouble(BeanUtils.getProperty((Object)record, (String)string));
        }
        catch (IllegalAccessException | NoSuchMethodException | NumberFormatException | InvocationTargetException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting double value [" + string + "]", (Throwable)e);
            throw new IllegalStateException("Error getting double value [" + string + "]");
        }
    }

    private String getPropString(String string, Object record) {
        try {
            return BeanUtils.getProperty((Object)record, (String)string);
        }
        catch (IllegalAccessException | NoSuchMethodException | NumberFormatException | InvocationTargetException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting double value [" + string + "]", (Throwable)e);
            throw new IllegalStateException("Error getting double value [" + string + "]");
        }
    }

    private Optional<?> getExistingXmlModel(IInvoice invoice, String version) {
        IBlob blob = CoreModelServiceHolder.get().load("TarmedRn:" + invoice.getNumber(), IBlob.class).orElse(null);
        if (blob != null && blob.getStringContent() != null && !blob.getStringContent().isEmpty()) {
            if ("4.5".equals(version)) {
                ch.fd.invoice450.request.RequestType invoiceRequest = TarmedJaxbUtil.unmarshalInvoiceRequest450((InputStream)new ByteArrayInputStream(blob.getStringContent().getBytes()));
                return Optional.ofNullable(invoiceRequest);
            }
            if ("4.4".equals(version)) {
                RequestType invoiceRequest = TarmedJaxbUtil.unmarshalInvoiceRequest440((InputStream)new ByteArrayInputStream(blob.getStringContent().getBytes()));
                return Optional.ofNullable(invoiceRequest);
            }
        }
        return Optional.empty();
    }

    private void setExistingXml(IInvoice invoice, Document document) throws IOException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputter xout = new XMLOutputter(Format.getCompactFormat());
        xout.output(document, (Writer)stringWriter);
        IBlob blob = CoreModelServiceHolder.get().load("TarmedRn:" + invoice.getNumber(), IBlob.class).orElseGet(() -> {
            IBlob newBlob = (IBlob)CoreModelServiceHolder.get().create(IBlob.class);
            newBlob.setId("TarmedRn:" + invoice.getNumber());
            return newBlob;
        });
        blob.setStringContent(stringWriter.toString());
        CoreModelServiceHolder.get().save((Identifiable)blob);
    }

    protected Optional<Document> getAsJdomDocument(ch.fd.invoice450.request.RequestType request) {
        if (request != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            TarmedJaxbUtil.marshallInvoiceRequest((ch.fd.invoice450.request.RequestType)request, (OutputStream)outputStream);
            return this.getAsJdomDocument(outputStream);
        }
        return Optional.empty();
    }

    private Optional<Document> getAsJdomDocument(ByteArrayOutputStream outputStream) {
        if (outputStream != null) {
            SAXBuilder builder = new SAXBuilder();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());){
                    return Optional.of(builder.build((InputStream)inputStream));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | JDOMException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error loading as jdom document", e);
            }
        }
        return Optional.empty();
    }
}

