/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.core.model.FallConstants;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IDiagnosisReference;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class XMLExporterTreatment {
    private static final String BY_CONTRACT = "by_contract";
    private static final String ICPC = "ICPC";
    private static final String ATTR_TYPE = "type";
    private Element insuranceElement;
    List<IDiagnosisReference> invoiceDiagnosis;

    private XMLExporterTreatment(Element insuranceElement) {
        this.insuranceElement = insuranceElement;
    }

    public Element getElement() {
        return this.insuranceElement;
    }

    public static XMLExporterTreatment buildTreatment(IInvoice invoice, XMLExporter xmlExporter) {
        ICoverage actFall = invoice.getCoverage();
        IMandator actMandant = invoice.getMandator();
        Element element = new Element("treatment", XMLExporter.nsinvoice);
        element.setAttribute("date_begin", XMLExporterUtil.makeTarmedDatum(invoice.getDateFrom()));
        element.setAttribute("date_end", XMLExporterUtil.makeTarmedDatum(invoice.getDateTo()));
        element.setAttribute("canton", (String)actMandant.getExtInfo((Object)XMLExporter.ta.KANTON));
        element.setAttribute("reason", XMLExporterTreatment.match_type(actFall.getReason()));
        List<IDiagnosisReference> invoiceDiagnosis = XMLExporterTreatment.getDiagnosen(invoice);
        for (IDiagnosisReference invoiceDiagnose : invoiceDiagnosis) {
            Element diagnosis = new Element("diagnosis", XMLExporter.nsinvoice);
            String diagnosisType = XMLExporterTreatment.match_diag(invoiceDiagnose.getCodeSystemName());
            diagnosis.setAttribute(ATTR_TYPE, diagnosisType);
            String code = invoiceDiagnose.getCode();
            if (diagnosisType.equalsIgnoreCase("freetext")) {
                diagnosis.setText(invoiceDiagnose.getText());
            } else {
                if (code.length() > 12) {
                    code = code.substring(0, 12);
                }
                diagnosis.setAttribute("code", code);
            }
            element.addContent((Content)diagnosis);
        }
        XMLExporterTreatment ret = new XMLExporterTreatment(element);
        ret.invoiceDiagnosis = invoiceDiagnosis;
        return ret;
    }

    private static List<IDiagnosisReference> getDiagnosen(IInvoice invoice) {
        HashSet<CallSite> seen = new HashSet<CallSite>();
        ArrayList<IDiagnosisReference> ret = new ArrayList<IDiagnosisReference>();
        List encounters = invoice.getEncounters();
        for (IEncounter encounter : encounters) {
            List encounterDiagnosis = encounter.getDiagnoses();
            for (IDiagnosisReference encounterDiagnose : encounterDiagnosis) {
                String dgc = encounterDiagnose.getCode();
                if (dgc == null || !seen.add((CallSite)((Object)(encounterDiagnose.getCode() + encounterDiagnose.getCodeSystemName())))) continue;
                ret.add(encounterDiagnose);
            }
        }
        return ret;
    }

    private static String match_type(String type) {
        if (type == null) {
            return "disease";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_DISEASE)) {
            return "disease";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_ACCIDENT)) {
            return "accident";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_MATERNITY)) {
            return "maternity";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_PREVENTION)) {
            return "prevention";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_BIRTHDEFECT)) {
            return "birthdefect";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_OTHER)) {
            return "unknown";
        }
        return "disease";
    }

    private static String match_diag(String name) {
        if (name != null) {
            if (name.equalsIgnoreCase("freetext")) {
                return "freetext";
            }
            if (name.equalsIgnoreCase("ICD-10")) {
                return "ICD";
            }
            if (name.equalsIgnoreCase("by contract")) {
                return BY_CONTRACT;
            }
            if (name.equalsIgnoreCase(ICPC)) {
                return ICPC;
            }
            if (name.equalsIgnoreCase("birthdefect")) {
                return "birthdefect";
            }
        }
        return BY_CONTRACT;
    }

    public List<IDiagnosisReference> getDiagnoses() {
        if (this.invoiceDiagnosis == null) {
            return Collections.emptyList();
        }
        return this.invoiceDiagnosis;
    }
}

