/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.xml.exporter;

import ch.elexis.base.ch.arzttarife.xml.exporter.VatUtil;
import ch.rgw.tools.Money;
import java.time.LocalDate;
import java.util.HashMap;

public class VatRateSum {
    private HashMap<Double, VatRateElement> rates = new HashMap();
    private double sumvat = 0.0;
    private LocalDate invoiceStartDate;

    public VatRateSum(LocalDate localDate) {
        this.invoiceStartDate = localDate;
    }

    public void add(double scale, double amount) {
        VatRateElement element = this.rates.get(scale);
        if (element == null) {
            element = new VatRateElement(scale);
            this.rates.put(scale, element);
        }
        element.add(amount);
        this.sumvat += amount / (100.0 + scale) * scale;
    }

    public Money getSumVat() {
        return new Money(this.sumvat);
    }

    public HashMap<Double, VatRateElement> getRates() {
        if (VatUtil.isVatAvailable()) {
            String reducedRate;
            Double scale2;
            String normalRate;
            if (this.isNormalRateMissing() && (normalRate = VatUtil.getNormalRateFromConfig(this.invoiceStartDate)) != null) {
                try {
                    scale2 = Double.valueOf(normalRate);
                    this.rates.put(scale2, new VatRateElement(scale2));
                }
                catch (Exception scale2) {
                    // empty catch block
                }
            }
            if (this.isReducedRateMissing() && (reducedRate = VatUtil.getReducedRateFromConfig(this.invoiceStartDate)) != null) {
                try {
                    scale2 = Double.valueOf(reducedRate);
                    this.rates.put(scale2, new VatRateElement(scale2));
                }
                catch (Exception scale3) {}
            }
        } else {
            Double scale4;
            String[] defaultVatRates;
            if (this.isNormalRateMissing() && (defaultVatRates = VatUtil.getDefaultVatRateArray(this.invoiceStartDate)) != null) {
                try {
                    scale4 = Double.valueOf(defaultVatRates[2]);
                    this.rates.put(scale4, new VatRateElement(scale4));
                }
                catch (Exception scale4) {
                    // empty catch block
                }
            }
            if (this.isReducedRateMissing() && (defaultVatRates = VatUtil.getDefaultVatRateArray(this.invoiceStartDate)) != null) {
                try {
                    scale4 = Double.valueOf(defaultVatRates[1]);
                    this.rates.put(scale4, new VatRateElement(scale4));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.rates;
    }

    private boolean isReducedRateMissing() {
        return this.rates.keySet().stream().filter(vatRate -> VatUtil.guessVatCode(vatRate) == 2).findAny().isEmpty();
    }

    private boolean isNormalRateMissing() {
        return this.rates.keySet().stream().filter(vatRate -> VatUtil.guessVatCode(vatRate) == 1).findAny().isEmpty();
    }

    public static class VatRateElement
    implements Comparable<VatRateElement> {
        private double scale;
        private double sumamount;
        private double sumvat;

        VatRateElement(double scale) {
            this.scale = scale;
            this.sumamount = 0.0;
            this.sumvat = 0.0;
        }

        void add(double amount) {
            this.sumamount += amount;
            this.sumvat += amount / (100.0 + this.scale) * this.scale;
        }

        @Override
        public int compareTo(VatRateElement other) {
            if (this.scale < other.scale) {
                return -1;
            }
            if (this.scale > other.scale) {
                return 1;
            }
            return 0;
        }

        public double getScale() {
            return this.scale;
        }

        public Money getAmount() {
            return new Money(this.sumamount);
        }

        public Money getVat() {
            return new Money(this.sumvat);
        }
    }
}

