/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.xml.exporter;

import ch.elexis.base.ch.arzttarife.xml.exporter.VatRateSum;
import ch.fd.invoice450.request.ServiceType;
import ch.fd.invoice500.request.ServiceExType;
import ch.fd.invoice500.request.ServicesType;
import ch.rgw.tools.Money;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class ServicesFinancialInfo {
    private double obligationSum;
    private Map<String, Double> tariffSum = new HashMap<String, Double>();
    private VatRateSum vatRateSum;

    public static ServicesFinancialInfo of(ch.fd.invoice450.request.ServicesType services, LocalDate localDate) {
        ServicesFinancialInfo ret = new ServicesFinancialInfo(localDate);
        for (Object obj : services.getServiceExOrService()) {
            if (obj instanceof ch.fd.invoice450.request.ServiceExType) {
                ret.addTariffAmount(((ch.fd.invoice450.request.ServiceExType)obj).getTariffType(), ((ch.fd.invoice450.request.ServiceExType)obj).getAmount());
                ret.addVatAmount(((ch.fd.invoice450.request.ServiceExType)obj).getVatRate(), ((ch.fd.invoice450.request.ServiceExType)obj).getAmount());
                if (!((ch.fd.invoice450.request.ServiceExType)obj).isObligation()) continue;
                ret.addObligationAmount(((ch.fd.invoice450.request.ServiceExType)obj).getAmount());
                continue;
            }
            if (!(obj instanceof ServiceType)) continue;
            ret.addTariffAmount(((ServiceType)obj).getTariffType(), ((ServiceType)obj).getAmount());
            ret.addVatAmount(((ServiceType)obj).getVatRate(), ((ServiceType)obj).getAmount());
            if (!((ServiceType)obj).isObligation()) continue;
            ret.addObligationAmount(((ServiceType)obj).getAmount());
        }
        return ret;
    }

    public static ServicesFinancialInfo of(ServicesType services, LocalDate localDate) {
        ServicesFinancialInfo ret = new ServicesFinancialInfo(localDate);
        for (Object obj : services.getServiceExOrService()) {
            if (obj instanceof ServiceExType) {
                ret.addTariffAmount(((ServiceExType)obj).getTariffType(), ((ServiceExType)obj).getAmount());
                ret.addVatAmount(((ServiceExType)obj).getVatRate(), ((ServiceExType)obj).getAmount());
                continue;
            }
            if (!(obj instanceof ch.fd.invoice500.request.ServiceType)) continue;
            ret.addTariffAmount(((ch.fd.invoice500.request.ServiceType)obj).getTariffType(), ((ch.fd.invoice500.request.ServiceType)obj).getAmount());
            ret.addVatAmount(((ch.fd.invoice500.request.ServiceType)obj).getVatRate(), ((ch.fd.invoice500.request.ServiceType)obj).getAmount());
        }
        return ret;
    }

    public ServicesFinancialInfo(LocalDate localDate) {
        this.vatRateSum = new VatRateSum(localDate);
        this.obligationSum = 0.0;
    }

    private void addVatAmount(double vatRate, double amount) {
        this.vatRateSum.add(vatRate, amount);
    }

    private void addTariffAmount(String tariffType, double amount) {
        Double sum = this.tariffSum.get(tariffType);
        if (sum == null) {
            sum = new Double(0.0);
        }
        sum = sum + amount;
        this.tariffSum.put(tariffType, sum);
    }

    private void addObligationAmount(double amount) {
        this.obligationSum += amount;
    }

    public Money getObligationSum() {
        return new Money(this.obligationSum);
    }

    public Money getTarifSum(String tariff) {
        if (this.tariffSum.containsKey(tariff)) {
            return new Money(this.tariffSum.get(tariff).doubleValue());
        }
        return new Money(0.0);
    }

    public Money getTotalSum() {
        Money ret = new Money(0.0);
        this.tariffSum.values().forEach(tariffSum -> ret.addAmount(tariffSum.doubleValue()));
        return ret;
    }

    public VatRateSum getVatRateSum() {
        return this.vatRateSum;
    }
}

