/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.TarmedACL;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.ICoverageService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.StringTool;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLExporterTiers {
    private static Logger logger = LoggerFactory.getLogger(XMLExporterTiers.class);
    private Element tiersElement;
    private String tiers;

    private XMLExporterTiers(Element tiers) {
        this.tiersElement = tiers;
    }

    public Element getElement() {
        return this.tiersElement;
    }

    public String getTiers() {
        return this.tiers;
    }

    public static XMLExporterTiers buildTiers(IInvoice invoice, XMLExporter xmlExporter) {
        IContact costBearer;
        TarmedACL ta = TarmedACL.getInstance();
        ICoverage coverage = invoice.getCoverage();
        IPatient patient = coverage.getPatient();
        IMandator mandant = invoice.getMandator();
        String tiers = "TP";
        ICoverageService.Tiers tiersType = CoverageServiceHolder.get().getTiersType(coverage);
        if (ICoverageService.Tiers.GARANT == tiersType) {
            tiers = "TG";
        }
        if ((costBearer = coverage.getCostBearer()) == null) {
            costBearer = patient;
        }
        String kEAN = TarmedRequirements.getEAN(costBearer);
        Element element = null;
        if (tiers.equals("TG")) {
            element = new Element("tiers_garant", XMLExporter.nsinvoice);
            String paymentPeriode = (String)mandant.getBiller().getExtInfo((Object)"rnfrist");
            if (StringTool.isNothing((Object)paymentPeriode)) {
                paymentPeriode = "30";
            }
            element.setAttribute("payment_period", "P" + paymentPeriode + "D");
        } else {
            element = new Element("tiers_payant", XMLExporter.nsinvoice);
        }
        XMLExporterTiers ret = new XMLExporterTiers(element);
        Element biller = new Element("biller", XMLExporter.nsinvoice);
        biller.setAttribute("ean_party", TarmedRequirements.getEAN(mandant.getBiller()));
        XMLExporterUtil.setAttributeIfNotEmpty(biller, "zsr", TarmedRequirements.getKSK(mandant.getBiller()));
        String spec = (String)mandant.getBiller().getExtInfo((Object)ta.SPEC);
        if (StringUtils.isNotBlank((CharSequence)spec)) {
            biller.setAttribute("specialty", spec);
        }
        biller.addContent((Content)XMLExporterUtil.buildRechnungsstellerAdressElement(mandant.getBiller()));
        ret.tiersElement.addContent((Content)biller);
        Element provider = new Element("provider", XMLExporter.nsinvoice);
        if (StringUtils.isNotBlank((CharSequence)ConfigServiceHolder.getGlobal((String)"TarmedBillFixProvider", null))) {
            IContact contact = (IContact)CoreModelServiceHolder.get().load(ConfigServiceHolder.getGlobal((String)"TarmedBillFixProvider", null), IContact.class).get();
            provider.setAttribute("ean_party", TarmedRequirements.getEAN(contact));
            provider.setAttribute("zsr", TarmedRequirements.getKSK(contact));
            logger.info("Fixed provider [" + contact.getLabel() + "] ean [" + TarmedRequirements.getEAN(contact) + "]");
            spec = (String)contact.getExtInfo((Object)ta.SPEC);
            if (StringUtils.isNotBlank((CharSequence)spec)) {
                provider.setAttribute("specialty", spec);
            }
            provider.addContent((Content)XMLExporterUtil.buildRechnungsstellerAdressElement(contact));
        } else {
            provider.setAttribute("ean_party", TarmedRequirements.getEAN((IContact)mandant));
            provider.setAttribute("zsr", TarmedRequirements.getKSK((IContact)mandant));
            logger.info("Provider [" + mandant.getLabel() + "] ean [" + TarmedRequirements.getEAN((IContact)mandant) + "]");
            spec = (String)mandant.getExtInfo((Object)ta.SPEC);
            if (StringUtils.isNotBlank((CharSequence)spec)) {
                provider.setAttribute("specialty", spec);
            }
            provider.addContent((Content)XMLExporterUtil.buildRechnungsstellerAdressElement((IContact)mandant));
        }
        ret.tiersElement.addContent((Content)provider);
        Element onlineElement = null;
        Element insurance = new Element("insurance", XMLExporter.nsinvoice);
        if (tiers.equals("TG")) {
            if (costBearer.isOrganization() && kEAN.matches("[0-9]{13,13}")) {
                insurance.setAttribute("ean_party", kEAN);
                insurance.addContent((Content)XMLExporterUtil.buildAdressElement(costBearer));
                ret.tiersElement.addContent((Content)insurance);
            }
        } else {
            insurance.setAttribute("ean_party", kEAN);
            Element company = new Element("company", XMLExporter.nsinvoice);
            Element companyname = new Element("companyname", XMLExporter.nsinvoice);
            companyname.setText(StringTool.limitLength((String)costBearer.getDescription1(), (int)35));
            company.addContent((Content)companyname);
            company.addContent((Content)XMLExporterUtil.buildPostalElement(costBearer));
            Element telcom = XMLExporterUtil.buildTelekomElement(costBearer);
            if (telcom != null && !telcom.getChildren().isEmpty()) {
                company.addContent((Content)telcom);
            }
            if ((onlineElement = XMLExporterUtil.buildOnlineElement(costBearer)) != null) {
                company.addContent((Content)onlineElement);
            }
            insurance.addContent((Content)company);
            ret.tiersElement.addContent((Content)insurance);
        }
        Element patientElement = xmlExporter.buildPatient(coverage);
        ret.tiersElement.addContent((Content)patientElement);
        Element guarantor = xmlExporter.buildGuarantor(XMLExporterUtil.getGuarantor(tiers, patient, coverage), (IContact)patient);
        ret.tiersElement.addContent((Content)guarantor);
        Element referrer = new Element("referrer", XMLExporter.nsinvoice);
        IContact auftraggeber = CoverageServiceHolder.get().getRequiredContact(coverage, "Zuweiser");
        if (auftraggeber != null) {
            String zsr;
            String ean = TarmedRequirements.getEAN(auftraggeber);
            if (ean != null && !ean.isEmpty()) {
                referrer.setAttribute("ean_party", TarmedRequirements.getEAN(auftraggeber));
            }
            if ((zsr = TarmedRequirements.getKSK(auftraggeber)) != null && !zsr.isEmpty()) {
                referrer.setAttribute("zsr", zsr);
            }
            referrer.addContent((Content)XMLExporterUtil.buildAdressElement(auftraggeber));
            ret.tiersElement.addContent((Content)referrer);
        }
        ret.tiers = tiers;
        return ret;
    }
}

