/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import org.jdom2.Document;
import org.jdom2.Element;

public class Validator {
    public Result<IInvoice> checkBill(IInvoice invoice, Document xmlRn, Result<IInvoice> res) {
        String bez;
        IContact costBearer;
        String ean;
        ICoverage coverage;
        Element payload = xmlRn.getRootElement().getChild("payload", XMLExporter.nsinvoice);
        Element body = payload.getChild("body", XMLExporter.nsinvoice);
        Element treatment = body.getChild("treatment", XMLExporter.nsinvoice);
        Element tiersGarant = body.getChild("tiers_garant", XMLExporter.nsinvoice);
        IMandator m = invoice.getMandator();
        if (invoice.getState().numericValue() > InvoiceState.OPEN.numericValue()) {
            return res;
        }
        if (m == null) {
            invoice.reject(InvoiceState.REJECTCODE.NO_MANDATOR, Messages.Validator_NoMandator);
            CoreModelServiceHolder.get().save((Identifiable)invoice);
            res.add(Result.SEVERITY.ERROR, 2, Messages.Validator_NoMandator, (Object)invoice, true);
        }
        if ((coverage = invoice.getCoverage()) == null || !CoverageServiceHolder.get().isValid(coverage)) {
            invoice.reject(InvoiceState.REJECTCODE.NO_CASE, Messages.Validator_NoCase);
            CoreModelServiceHolder.get().save((Identifiable)invoice);
            res.add(Result.SEVERITY.ERROR, 4, Messages.Validator_NoCase, (Object)invoice, true);
        }
        if (StringTool.isNothing((Object)(ean = TarmedRequirements.getEAN((IContact)m)))) {
            invoice.reject(InvoiceState.REJECTCODE.NO_MANDATOR, Messages.Validator_NoEAN);
            CoreModelServiceHolder.get().save((Identifiable)invoice);
            res.add(Result.SEVERITY.ERROR, 3, Messages.Validator_NoEAN, (Object)invoice, true);
        }
        if (treatment.getChildren("diagnosis", XMLExporter.nsinvoice).isEmpty()) {
            invoice.reject(InvoiceState.REJECTCODE.NO_DIAG, Messages.Validator_NoDiagnosis);
            CoreModelServiceHolder.get().save((Identifiable)invoice);
            res.add(Result.SEVERITY.ERROR, 8, Messages.Validator_NoDiagnosis, (Object)invoice, true);
        }
        IContact iContact = costBearer = coverage != null ? coverage.getCostBearer() : null;
        if (costBearer == null && tiersGarant != null) {
            return res;
        }
        if (costBearer == null) {
            invoice.reject(InvoiceState.REJECTCODE.NO_GUARANTOR, Messages.Validator_NoName);
            CoreModelServiceHolder.get().save((Identifiable)invoice);
            res.add(Result.SEVERITY.ERROR, 7, Messages.Validator_NoName, (Object)invoice, true);
            return res;
        }
        ean = TarmedRequirements.getEAN(costBearer);
        if (StringTool.isNothing((Object)ean) || !ean.matches("[0-9]{13}")) {
            invoice.reject(InvoiceState.REJECTCODE.NO_GUARANTOR, Messages.Validator_NoEAN2);
            CoreModelServiceHolder.get().save((Identifiable)invoice);
            res.add(Result.SEVERITY.ERROR, 6, Messages.Validator_NoEAN2, (Object)invoice, true);
        }
        if (StringTool.isNothing((Object)(bez = costBearer.getDescription1()))) {
            invoice.reject(InvoiceState.REJECTCODE.NO_GUARANTOR, Messages.Validator_NoName);
            CoreModelServiceHolder.get().save((Identifiable)invoice);
            res.add(Result.SEVERITY.ERROR, 7, Messages.Validator_NoName, (Object)invoice, true);
        }
        return res;
    }
}

