/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.base.ch.arzttarife.nutrition.INutritionLeistung;
import ch.elexis.base.ch.arzttarife.service.ArzttarifeModelServiceHolder;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class NutritionLeistungCodeSelectorFactory
extends CodeSelectorFactory {
    private ViewerConfigurer vc;

    @Inject
    public void selectedEncounter(@Optional IEncounter encounter) {
        if (this.vc != null && this.vc.getControlFieldProvider() != null) {
            this.vc.getControlFieldProvider().fireChangedEvent();
        }
    }

    public ViewerConfigurer createViewerConfigurer(CommonViewer cv) {
        cv.setSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableViewer tv = (TableViewer)event.getSource();
                StructuredSelection ss = (StructuredSelection)tv.getSelection();
                if (!ss.isEmpty()) {
                    INutritionLeistung selected = (INutritionLeistung)ss.getFirstElement();
                    ContextServiceHolder.get().getRootContext().setNamed("ch.elexis.views.codeselector.nutrition.selection", (Object)selected);
                } else {
                    ContextServiceHolder.get().getRootContext().setNamed("ch.elexis.views.codeselector.nutrition.selection", null);
                }
            }
        });
        FieldDescriptor[] fd = new FieldDescriptor[]{new FieldDescriptor("Ziffer", "code", null), new FieldDescriptor("Text", "titel", null)};
        SelectorPanelProvider slp = new SelectorPanelProvider(fd, true);
        this.vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)new NutritionContentProvider(cv, (ViewerConfigurer.ControlFieldProvider)slp), (LabelProvider)new DefaultLabelProvider(), (ViewerConfigurer.ControlFieldProvider)slp, (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(3, 0, cv));
        return this.vc.setContentType(ViewerConfigurer.ContentType.GENERICOBJECT);
    }

    public void dispose() {
    }

    public String getCodeSystemName() {
        return "Ern\u00e4hrungsberatung";
    }

    public Class<?> getElementClass() {
        return INutritionLeistung.class;
    }

    private class NutritionContentProvider
    extends CommonViewerContentProvider {
        private ViewerConfigurer.ControlFieldProvider controlFieldProvider;

        public NutritionContentProvider(CommonViewer commonViewer, ViewerConfigurer.ControlFieldProvider controlFieldProvider) {
            super(commonViewer);
            this.controlFieldProvider = controlFieldProvider;
        }

        public Object[] getElements(Object inputElement) {
            IQuery<?> query = this.getBaseQuery();
            java.util.Optional encounter = ContextServiceHolder.get().getTyped(IEncounter.class);
            encounter.ifPresent(e -> {
                query.and("validFrom", IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)e.getDate());
                query.startGroup();
                query.or("validUntil", IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)e.getDate());
                query.or("validUntil", IQuery.COMPARATOR.EQUALS, null);
                query.andJoinGroups();
            });
            this.controlFieldProvider.setQuery(query);
            this.applyQueryFilters(query);
            query.orderBy("code", IQuery.ORDER.ASC);
            List elements = query.execute();
            return elements.toArray(new Object[elements.size()]);
        }

        protected IQuery<?> getBaseQuery() {
            IQuery query = ArzttarifeModelServiceHolder.get().getQuery(INutritionLeistung.class);
            query.and("id", IQuery.COMPARATOR.NOT_EQUALS, (Object)"VERSION");
            return query;
        }
    }
}

