/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.xml.exporter;

import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class VatUtil {
    public static final String VAT_VALUE_WITH_DATE = "at.medevit.medelexis.vat_ch/ValueWithDate";
    private static String[] defaultRatesStart = new String[]{"0", "2.5", "8.0"};
    private static String[] defaultRates2018 = new String[]{"0", "2.5", "7.7"};
    private static String[] defaultRates2024 = new String[]{"0", "2.6", "8.1"};

    public static boolean isVatAvailable() {
        return !VatUtil.readDateableConfigValue(ConfigServiceHolder.get()).isEmpty();
    }

    public static String getNormalRateFromConfig(LocalDate date) {
        if (date != null) {
            return VatUtil.getCurrentValueFromConfig(date, 1);
        }
        return null;
    }

    public static String getReducedRateFromConfig(LocalDate date) {
        if (date != null) {
            return VatUtil.getCurrentValueFromConfig(date, 2);
        }
        return null;
    }

    private static String getCurrentValueFromConfig(LocalDate date, int intValIdx) {
        List<String> values = VatUtil.readDateableConfigValue(ConfigServiceHolder.get());
        values.sort((l, r) -> {
            String[] lsplits = l.split("::");
            String[] rsplits = r.split("::");
            if (!lsplits[0].isEmpty() && !rsplits[0].isEmpty()) {
                LocalDate lDate = new TimeTool(lsplits[0]).toLocalDate();
                LocalDate rDate = new TimeTool(rsplits[0]).toLocalDate();
                return rDate.compareTo(lDate);
            }
            if (!lsplits[0].isEmpty() || !rsplits[0].isEmpty()) {
                if (!lsplits[0].isEmpty()) {
                    return -1;
                }
                return 1;
            }
            return 0;
        });
        for (String s : values) {
            String[] splits = s.split("::");
            if (splits.length != 3) continue;
            String dateAsString = splits[0];
            if (!dateAsString.isEmpty()) {
                boolean isAfter;
                LocalDate configDate = new TimeTool(dateAsString).toLocalDate();
                boolean bl = isAfter = date.isAfter(configDate) || date.equals(configDate);
                if (!isAfter) continue;
                return splits[intValIdx];
            }
            return splits[intValIdx];
        }
        return null;
    }

    private static List<String> readDateableConfigValue(IConfigService configService) {
        ArrayList<String> configValues = new ArrayList<String>();
        String rawValue = configService.get(VAT_VALUE_WITH_DATE, null);
        if (StringUtils.isBlank((CharSequence)rawValue)) {
            return configValues;
        }
        String[] configValue = rawValue.split(",");
        if (configValue != null) {
            configValues.addAll(Arrays.asList(configValue));
            String[] stringArray = configValue;
            int n = configValue.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.startsWith("::")) break;
                ++n2;
            }
        }
        return configValues;
    }

    public static int guessVatCode(Double vatRate) {
        if (vatRate != null) {
            if (vatRate == 0.0) {
                return 0;
            }
            if (vatRate < 7.0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static String[] getDefaultVatRateArray(LocalDate date) {
        if (date.isBefore(LocalDate.of(2018, 1, 1))) {
            return defaultRatesStart;
        }
        if (date.isBefore(LocalDate.of(2024, 1, 1))) {
            return defaultRates2018;
        }
        return defaultRates2024;
    }
}

