/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.importer;

import ch.elexis.base.ch.arzttarife.occupational.IOccupationalLeistung;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.services.IReferenceDataImporterService;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.TimeTool;
import jakarta.inject.Inject;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class OccupationalImporter
extends ImporterPage {
    private TimeTool validFrom = new TimeTool();
    private TimeTool endOfEpoch = new TimeTool("20380118");
    @Inject
    private IReferenceDataImporterService importerService;

    public OccupationalImporter() {
        this.validFrom.clear();
        this.validFrom.set(TimeTool.getInstance().get(1), 0, 1);
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
    }

    public Composite createPage(Composite parent) {
        ImporterPage.FileBasedImporter fis = new ImporterPage.FileBasedImporter(parent, (ImporterPage)this);
        fis.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite validDateComposite = new Composite((Composite)fis, 0);
        validDateComposite.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        validDateComposite.setLayout((Layout)new FormLayout());
        Label lbl = new Label(validDateComposite, 0);
        lbl.setText("Tarif ist g\u00fcltig ab:");
        final DateTime validDate = new DateTime(validDateComposite, 65572);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(20, -5);
        lbl.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(20, 5);
        validDate.setLayoutData((Object)fd);
        validDate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.setValidFromDate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.setValidFromDate();
            }

            private void setValidFromDate() {
                OccupationalImporter.this.validFrom.set(validDate.getYear(), validDate.getMonth(), validDate.getDay());
            }
        });
        validDate.setDate(this.validFrom.get(1), this.validFrom.get(2), this.validFrom.get(5));
        return fis;
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream tarifInputStream = new FileInputStream(this.results[0]);){
            IReferenceDataImporter importer = (IReferenceDataImporter)this.importerService.getImporter("occupational").orElseThrow(() -> new IllegalStateException("No IReferenceDataImporter available."));
            return importer.performImport(monitor, (InputStream)tarifInputStream, Integer.valueOf(this.getVersionFromValid(this.validFrom)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private int getVersionFromValid(TimeTool validFrom) {
        int year = validFrom.get(1);
        int month = validFrom.get(2) + 1;
        int day = validFrom.get(5);
        return day + month * 100 + (year - 2000) * 10000;
    }

    public String getDescription() {
        return "Arbeitsmedizinische Vorsorgeuntersuchungen";
    }

    public String getTitle() {
        return "Arbeitsmed. Vorsorge";
    }

    public List<String> getObjectClass() {
        return Collections.singletonList(IOccupationalLeistung.class.getName());
    }
}

