/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IInvoice;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.StringTool;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLExporterProcessing {
    private static Logger logger = LoggerFactory.getLogger(XMLExporterProcessing.class);
    private static final String ELEMENT_PROCESSING = "processing";
    public static final String ATTR_INTERMEDIAT_PRINT = "print_at_intermediate";
    public static final String ATTR_PATIENT_COPY_PRINT = "print_patient_copy";
    public static final String ELEMENT_TRANSPORT = "transport";
    public static final String ELEMENT_TRANSPORT_VIA = "via";
    private static final String ATTR_TRANSPORT_FROM = "from";
    private static final String ATTR_TRANSPORT_TO = "to";
    public static final String ATTR_TRANSPORT_VIA_VIA = "via";
    private static final String ATTR_TRANSPORT_VIA_SEQ = "sequence_id";
    private Element processingElement;

    private XMLExporterProcessing(Element processing) {
        this.processingElement = processing;
    }

    public Element getElement() {
        return this.processingElement;
    }

    public static String getIntermediateEAN(IInvoice existingInvoice, XMLExporter xmlExporter) {
        String kEAN = XMLExporterProcessing.getKostentraegerEAN(existingInvoice, xmlExporter);
        String rEAN = XMLExporterProcessing.getRecipientEAN(existingInvoice, xmlExporter);
        String iEAN = xmlExporter.getIntermediateEAN(existingInvoice.getCoverage());
        logger.debug("Intermediate EAN [" + iEAN + "]");
        if (StringTool.isNothing((Object)iEAN)) {
            iEAN = !rEAN.matches("(20[0-9]{11}|76[0-9]{11})") ? (kEAN.matches("(20[0-9]{11}|76[0-9]{11})") ? kEAN : "2000000000000") : rEAN;
        }
        return iEAN;
    }

    private static IContact getKostentTraeger(ICoverage invoiceCoverage) {
        IContact kostentraeger = invoiceCoverage.getCostBearer();
        if (kostentraeger == null) {
            kostentraeger = invoiceCoverage.getPatient();
        }
        return kostentraeger;
    }

    public static String getRecipientEAN(IInvoice invoice, XMLExporter xmlExporter) {
        String rEAN = TarmedRequirements.getRecipientEAN(XMLExporterProcessing.getKostentTraeger(invoice.getCoverage()));
        logger.debug("Recipient EAN [" + rEAN + "]");
        if (rEAN.equals("unknown")) {
            rEAN = XMLExporterProcessing.getKostentraegerEAN(invoice, xmlExporter);
        }
        return rEAN;
    }

    public static String getKostentraegerEAN(IInvoice invoice, XMLExporter xmlExporter) {
        String kEAN = TarmedRequirements.getEAN(XMLExporterProcessing.getKostentTraeger(invoice.getCoverage()));
        logger.debug("Kostentraeger EAN [" + kEAN + "]");
        return kEAN;
    }
}

