/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.ambulatory.model;

import ch.elexis.base.ch.arzttarife.ambulatory.model.AmbulatoryAllowance;
import ch.elexis.base.ch.arzttarife.ambulatory.model.AmbulatoryAllowanceVerifier;
import ch.elexis.base.ch.arzttarife.model.service.CoreModelServiceHolder;
import ch.elexis.base.ch.arzttarife.tardoc.tarifmatcher.TarifMatcher;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.billable.AbstractOptifier;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.rgw.tools.Result;
import java.util.Optional;

public class AmbulatoryAllowanceOptifier
extends AbstractOptifier<AmbulatoryAllowance> {
    private TarifMatcher<AmbulatoryAllowance> tarifMatcher;
    private AmbulatoryAllowanceVerifier verifier = new AmbulatoryAllowanceVerifier();

    public AmbulatoryAllowanceOptifier(IModelService coreModelService, IContextService contextService) {
        super(coreModelService, contextService);
    }

    protected void setPrice(AmbulatoryAllowance billable, IBilled billed) {
        Optional<IBillingSystemFactor> factor = this.getFactor(billed.getEncounter());
        if (factor.isPresent()) {
            billed.setFactor(factor.get().getFactor());
        } else {
            billed.setFactor(1.0);
        }
        billed.setPoints(billable.getPrice(billed.getEncounter()).getCents());
    }

    public Optional<IBillingSystemFactor> getFactor(IEncounter encounter) {
        return BillingServiceHolder.get().getBillingSystemFactor(encounter.getCoverage().getBillingSystem().getName(), encounter.getDate());
    }

    public Result<IBilled> add(AmbulatoryAllowance billable, IEncounter encounter, double amount, boolean save) {
        Result<IBilled> digniResult;
        if (this.tarifMatcher == null) {
            this.tarifMatcher = new TarifMatcher(this);
        }
        if (!(digniResult = this.verifier.checkDigni(encounter, billable)).isOK()) {
            return digniResult;
        }
        IBilled billed = (IBilled)super.add((IBillable)billable, encounter, amount, false).get();
        Result<IBilled> matcherResult = this.tarifMatcher.evaluate(billed, encounter);
        if (matcherResult.isOK()) {
            if (save) {
                CoreModelServiceHolder.get().save((Identifiable)billed);
                CoreModelServiceHolder.get().save((Identifiable)encounter);
                CoreModelServiceHolder.get().save((Identifiable)matcherResult.get());
            }
        } else {
            CoreModelServiceHolder.get().refresh((Identifiable)encounter, true);
        }
        return matcherResult;
    }
}

