/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tardoc.model;

import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.base.ch.arzttarife.tardoc.ITardocGroup;
import ch.elexis.base.ch.arzttarife.tardoc.model.TardocGroup;
import ch.elexis.base.ch.arzttarife.tardoc.model.TardocLeistung;
import ch.elexis.base.ch.arzttarife.tardoc.model.TardocLimitation;
import ch.elexis.base.ch.arzttarife.util.ArzttarifeUtil;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class TardocVerifier
implements IBillableVerifier {
    public Result<IBillable> verifyAdd(IBillable billable, IEncounter encounter, double amount) {
        Result<IBilled> validDateResult;
        Result ret = Result.OK();
        if (billable instanceof TardocLeistung && !(validDateResult = this.checkValidDate(encounter, (TardocLeistung)billable, null)).isOK()) {
            return new Result(validDateResult.getSeverity(), validDateResult.getCode(), ((Result.msg)validDateResult.getMessages().get(0)).getText(), (Object)billable, false);
        }
        return ret;
    }

    public Result<IBilled> checkValidDate(IEncounter kons, TardocLeistung tardocLeistung, IBilled newVerrechnet) {
        TimeTool tBis;
        TimeTool tVon;
        TimeTool date = new TimeTool(kons.getDate());
        LocalDate dVon = tardocLeistung.getValidFrom();
        if (dVon != null && date.isBefore(tVon = new TimeTool(dVon))) {
            return new Result(Result.SEVERITY.WARNING, 7, tardocLeistung.getCode() + " " + Messages.TarmedOptifier_NotYetValid, (Object)newVerrechnet, false);
        }
        LocalDate dBis = tardocLeistung.getValidTo();
        if (dBis != null && date.isAfter(tBis = new TimeTool(dBis))) {
            return new Result(Result.SEVERITY.WARNING, 8, tardocLeistung.getCode() + " " + Messages.TarmedOptifier_NoMoreValid, (Object)newVerrechnet, false);
        }
        return new Result((Object)newVerrechnet);
    }

    public Result<IBilled> verify(IEncounter encounter) {
        Result ret = new Result();
        for (IBilled vv : encounter.getBilled()) {
            Result<IBilled> digniResult;
            Result<IBilled> limitResult;
            IBillable iv = vv.getBillable();
            if (!(iv instanceof TardocLeistung)) continue;
            TardocLeistung tardocLeistung = (TardocLeistung)iv;
            Result<IBilled> validDateResult = this.checkValidDate(encounter, tardocLeistung, vv);
            if (!validDateResult.isOK()) {
                ret.add(validDateResult);
            }
            if (!(limitResult = this.checkLimitations(encounter, tardocLeistung, vv)).isOK()) {
                ret.add(limitResult);
            }
            if ((digniResult = this.checkDigni(encounter, tardocLeistung, vv)).isOK()) continue;
            ret.add(digniResult);
        }
        return ret;
    }

    public Result<IBilled> checkLimitations(IEncounter kons, TardocLeistung tardocLeistung, IBilled newVerrechnet) {
        List<TardocLimitation> limitations = tardocLeistung.getLimitations();
        for (TardocLimitation tardocLimitation : limitations) {
            Result<IBilled> result;
            if (!tardocLimitation.isTestable() || (result = tardocLimitation.test(kons, newVerrechnet)).isOK()) continue;
            return result;
        }
        List<String> groups = tardocLeistung.getServiceGroups(kons.getDate());
        for (String groupName : groups) {
            Optional<ITardocGroup> group = TardocGroup.find(groupName, tardocLeistung.getLaw(), kons.getDate());
            if (!group.isPresent()) continue;
            limitations = group.get().getLimitations();
            for (TardocLimitation tardocLimitation : limitations) {
                Result<IBilled> result;
                if (!tardocLimitation.isTestable() || (result = tardocLimitation.test(kons, newVerrechnet)).isOK()) continue;
                return result;
            }
        }
        return new Result((Object)newVerrechnet);
    }

    public Result<IBilled> checkDigni(IEncounter encounter, TardocLeistung tardocLeistung, IBilled newBilled) {
        List<ICoding> tardocSpecialist;
        String digni = tardocLeistung.getDigniQuali();
        if (StringUtils.isNotBlank((CharSequence)digni) && !digni.contains("9999") && encounter.getMandator() != null && !(tardocSpecialist = ArzttarifeUtil.getMandantTardocSepcialist(encounter.getMandator())).stream().anyMatch(c -> digni.contains(c.getCode()))) {
            String msg2 = "Der Mandant hat keine der ben\u00f6tigten Dignit\u00e4ten [" + digni + "] der Leistung " + tardocLeistung.getCode() + ".";
            return new Result(Result.SEVERITY.WARNING, 6, msg2, null, false);
        }
        return new Result(null);
    }
}

