/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.physio.model.importer;

import ch.elexis.base.ch.arzttarife.model.service.ArzttarifeModelServiceHolder;
import ch.elexis.base.ch.arzttarife.physio.IPhysioLeistung;
import ch.elexis.base.ch.arzttarife.tarmed.model.importer.EntityUtil;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.jpa.entities.PhysioLeistung;
import ch.elexis.core.services.IQuery;
import ch.rgw.tools.TimeTool;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component(property={"referenceDataId=physio"})
public class PhysioReferenceDataImporter
extends AbstractReferenceDataImporter
implements IReferenceDataImporter {
    private LocalDate validFrom;
    private LocalDate endOfEpoch = new TimeTool("20380118").toLocalDate();

    public IStatus performImport(IProgressMonitor monitor, InputStream input, Integer newVersion) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.validFrom = this.getValidFromVersion(newVersion).toLocalDate();
        try {
            CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader(input, "ISO-8859-1")).withCSVParser((ICSVParser)new CSVParserBuilder().withSeparator(';').build()).build();
            monitor.beginTask("Importiere Physio", 100);
            String[] line = reader.readNext();
            while ((line = reader.readNext()) != null) {
                if (line.length < 3) continue;
                monitor.subTask(line[1]);
                this.updateOrCreateFromLine(line);
            }
            this.closeAllOlder();
            monitor.done();
            return Status.OK_STATUS;
        }
        catch (CsvValidationException | IOException uee) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Could not import physio tarif", uee);
            return Status.CANCEL_STATUS;
        }
    }

    private TimeTool getValidFromVersion(Integer newVersion) {
        String intString = Integer.toString(newVersion);
        if (intString.length() != 6) {
            throw new IllegalStateException("Version " + String.valueOf(newVersion) + " can not be parsed to valid date.");
        }
        String year = intString.substring(0, 2);
        String month = intString.substring(2, 4);
        String day = intString.substring(4, 6);
        TimeTool ret = new TimeTool();
        ret.set(1, Integer.parseInt(year) + 2000);
        ret.set(2, Integer.parseInt(month) - 1);
        ret.set(5, Integer.parseInt(day));
        return ret;
    }

    private void closeAllOlder() {
        LocalDate defaultValidFrom = LocalDate.of(1970, 1, 1);
        List<PhysioLeistung> entries = EntityUtil.loadAll(PhysioLeistung.class);
        for (PhysioLeistung physio : entries) {
            LocalDate pValidFrom = physio.getValidFrom();
            LocalDate pValidUntil = physio.getValidUntil();
            if (pValidFrom == null) {
                physio.setValidFrom(defaultValidFrom);
                physio.setValidUntil(this.validFrom);
                continue;
            }
            if (this.validFrom.equals(pValidFrom)) continue;
            if (pValidUntil == null) {
                physio.setValidUntil(this.validFrom);
                continue;
            }
            if (!pValidUntil.isEqual(this.endOfEpoch)) continue;
            physio.setValidUntil(this.validFrom);
        }
    }

    private void updateOrCreateFromLine(String[] line) {
        List<PhysioLeistung> entries = EntityUtil.loadByNamedQuery(Collections.singletonMap("ziffer", line[0]), PhysioLeistung.class);
        ArrayList<PhysioLeistung> openEntries = new ArrayList<PhysioLeistung>();
        for (PhysioLeistung physio : entries) {
            LocalDate pValidUntil = physio.getValidUntil();
            if (pValidUntil == null) {
                openEntries.add(physio);
                continue;
            }
            if (!pValidUntil.isEqual(this.endOfEpoch)) continue;
            openEntries.add(physio);
        }
        if (openEntries.isEmpty()) {
            PhysioLeistung physio;
            physio = new PhysioLeistung();
            physio.setZiffer(line[0]);
            physio.setTitel(line[1]);
            physio.setTp(line[2]);
            physio.setValidFrom(this.validFrom);
            physio.setValidUntil(null);
            physio.setLaw(this.getLaw());
            if (this.lineHasFixPrice(line)) {
                this.applyFixPrice(physio, line[3]);
            }
            EntityUtil.save(Collections.singletonList(physio));
        } else {
            for (PhysioLeistung physio : openEntries) {
                if (physio.getValidFrom().equals(this.validFrom)) {
                    physio.setTitel(line[1]);
                    physio.setTp(line[2]);
                    if (!this.lineHasFixPrice(line)) continue;
                    this.applyFixPrice(physio, line[3]);
                    continue;
                }
                physio.setValidUntil(this.validFrom);
                EntityUtil.save(Collections.singletonList(physio));
                PhysioLeistung newPhysio = new PhysioLeistung();
                newPhysio.setZiffer(line[0]);
                newPhysio.setTitel(line[1]);
                newPhysio.setTp(line[2]);
                newPhysio.setValidFrom(this.validFrom);
                newPhysio.setValidUntil(null);
                newPhysio.setLaw(this.getLaw());
                if (this.lineHasFixPrice(line)) {
                    this.applyFixPrice(newPhysio, line[3]);
                }
                EntityUtil.save(Collections.singletonList(newPhysio));
            }
        }
    }

    private void applyFixPrice(PhysioLeistung physio, String string) {
        physio.setTp(string);
        StringBuilder sb = new StringBuilder();
        String existingText = physio.getTitel();
        if (existingText != null) {
            sb.append(existingText);
        }
        sb.append("\n[FIXPRICE]");
        physio.setTitel(sb.toString());
    }

    private boolean lineHasFixPrice(String[] line) {
        return line.length > 3 && line[3] != null && !line[3].isEmpty() && Character.isDigit(line[3].charAt(0));
    }

    public int getCurrentVersion() {
        LocalDate validFrom;
        IQuery query = ArzttarifeModelServiceHolder.get().getQuery(IPhysioLeistung.class);
        query.and("validFrom", IQuery.COMPARATOR.NOT_EQUALS, null);
        query.and("validUntil", IQuery.COMPARATOR.EQUALS, null);
        List physioLeistungen = query.execute();
        if (!physioLeistungen.isEmpty() && (validFrom = ((IPhysioLeistung)physioLeistungen.get(0)).getValidFrom()) != null) {
            DateTimeFormatter ofPattern = DateTimeFormatter.ofPattern("yyMMdd");
            int version = Integer.valueOf(ofPattern.format(validFrom));
            return version;
        }
        return -1;
    }

    protected String getLaw() {
        return "";
    }
}

