/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tarmed.model.importer;

import ch.elexis.base.ch.arzttarife.model.service.EntityManagerHolder;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import java.util.Map;

public class EntityUtil {
    public static void save(List<Object> saveObject) {
        try (EntityManager em = (EntityManager)EntityManagerHolder.get().getEntityManager();){
            em.getTransaction().begin();
            for (Object object : saveObject) {
                em.merge(object);
            }
            em.getTransaction().commit();
        }
    }

    public static <T> T load(String id, Class<T> clazz) {
        try (EntityManager em = (EntityManager)EntityManagerHolder.get().getEntityManager();){
            Object object = em.find(clazz, (Object)id);
            return (T)object;
        }
    }

    public static <T> List<T> loadAll(Class<T> clazz) {
        try (EntityManager em = (EntityManager)EntityManagerHolder.get().getEntityManager();){
            CriteriaQuery criteria = em.getCriteriaBuilder().createQuery(clazz);
            criteria.select((Selection)criteria.from(clazz));
            List list = em.createQuery(criteria).getResultList();
            return list;
        }
    }

    public static <T> List<T> loadByNamedQuery(Map<String, Object> propertyMap, Class<T> clazz) {
        try (EntityManager em = (EntityManager)EntityManagerHolder.get().getEntityManager();){
            StringBuilder queryName = new StringBuilder();
            queryName.append(clazz.getSimpleName());
            for (String property : propertyMap.keySet()) {
                queryName.append(".").append(property);
            }
            TypedQuery namedQuery = em.createNamedQuery(queryName.toString(), clazz);
            for (String property : propertyMap.keySet()) {
                namedQuery.setParameter(property, propertyMap.get(property));
            }
            List list = namedQuery.getResultList();
            return list;
        }
    }
}

