/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.util;

import ch.elexis.base.ch.arzttarife.model.service.ArzttarifeModelServiceHolder;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedLeistung;
import ch.elexis.base.ch.arzttarife.tarmed.MandantType;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.util.model.TransientCoding;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.rgw.tools.Money;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ArzttarifeUtil {
    private static String MANDANT_TYPE_EXTINFO_KEY = "ch.elexis.data.tarmed.mandant.type";
    private static String MANDANT_TARDOC_SPECIALIST_EXTINFO_KEY = "ch.elexis.data.tardoc.mandant.dignitaet";
    private static List<String> availableLawsCache;

    public static void setMandantType(IMandator mandator, MandantType type) {
        mandator.setExtInfo((Object)MANDANT_TYPE_EXTINFO_KEY, (Object)type.name());
    }

    public static MandantType getMandantType(IMandator mandator) {
        Object typeObj = mandator.getExtInfo((Object)MANDANT_TYPE_EXTINFO_KEY);
        if (typeObj instanceof String) {
            return MandantType.valueOf((String)typeObj);
        }
        return MandantType.SPECIALIST;
    }

    public static void setMandantTardocSepcialist(IMandator mandator, List<ICoding> specialistCodes) {
        if (specialistCodes != null) {
            mandator.setExtInfo((Object)MANDANT_TARDOC_SPECIALIST_EXTINFO_KEY, (Object)specialistCodes.stream().map(c -> c.getCode() + "|" + c.getDisplay()).collect(Collectors.joining("::")));
        } else {
            mandator.setExtInfo((Object)MANDANT_TARDOC_SPECIALIST_EXTINFO_KEY, null);
        }
    }

    public static List<ICoding> getMandantTardocSepcialist(IMandator mandator) {
        Object typeObj = mandator.getExtInfo((Object)MANDANT_TARDOC_SPECIALIST_EXTINFO_KEY);
        if (typeObj instanceof String) {
            String[] codesString;
            ArrayList<ICoding> ret = new ArrayList<ICoding>();
            String[] stringArray = codesString = ((String)typeObj).split("::");
            int n = codesString.length;
            int n2 = 0;
            while (n2 < n) {
                String codeString = stringArray[n2];
                String[] codeParts = codeString.split("\\|");
                if (codeParts.length == 2) {
                    ret.add((ICoding)new TransientCoding("tardoc_dignitaet", codeParts[0], codeParts[1]));
                }
                ++n2;
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public static Money getALMoney(IBilled billed) {
        double secondaryScale = 1.0;
        if (!billed.isNonIntegerAmount()) {
            secondaryScale = billed.getSecondaryScaleFactor();
        }
        return new Money((int)Math.round(ArzttarifeUtil.getAL(billed) * billed.getFactor() * billed.getAmount() * billed.getPrimaryScaleFactor() * secondaryScale));
    }

    public static Money getTLMoney(IBilled billed) {
        double secondaryScale = 1.0;
        if (!billed.isNonIntegerAmount()) {
            secondaryScale = billed.getSecondaryScaleFactor();
        }
        return new Money((int)Math.round(ArzttarifeUtil.getTL(billed) * billed.getFactor() * billed.getAmount() * billed.getPrimaryScaleFactor() * secondaryScale));
    }

    public static double getAL(IBilled billed) {
        IBillable billable;
        boolean changedPrice = billed.isChangedPrice();
        if (changedPrice) {
            return billed.getPoints();
        }
        String alString = (String)billed.getExtInfo((Object)"AL");
        if (alString != null) {
            try {
                return (int)Double.parseDouble(alString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((billable = billed.getBillable()) instanceof ITarmedLeistung) {
            IEncounter encounter = billed.getEncounter();
            return encounter != null ? ((ITarmedLeistung)billable).getAL(encounter.getMandator()) : ((ITarmedLeistung)billable).getAL();
        }
        return 0.0;
    }

    public static double getTL(IBilled billed) {
        IBillable billable;
        boolean changedPrice = billed.isChangedPrice();
        if (changedPrice && billed.getPoints() == 0) {
            return billed.getPoints();
        }
        String tlString = (String)billed.getExtInfo((Object)"TL");
        if (tlString != null) {
            try {
                return (int)Double.parseDouble(tlString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((billable = billed.getBillable()) instanceof ITarmedLeistung) {
            return ((ITarmedLeistung)billable).getTL();
        }
        return 0.0;
    }

    public static String getSide(IBilled billed) {
        IBillable billable = billed.getBillable();
        if (billable instanceof ITarmedLeistung) {
            String side = (String)billed.getExtInfo((Object)"Seite");
            if ("l".equalsIgnoreCase(side)) {
                return "left";
            }
            if ("r".equalsIgnoreCase(side)) {
                return "right";
            }
        }
        return "none";
    }

    public static boolean isObligation(IBilled billed) {
        String obli;
        IBillable billable = billed.getBillable();
        return billable instanceof ITarmedLeistung && ((obli = (String)billed.getExtInfo((Object)"obligation")) == null || Boolean.parseBoolean(obli));
    }

    public static List<String> getAvailableLaws() {
        return ArzttarifeModelServiceHolder.get().getNamedQueryByName(String.class, ITarmedLeistung.class, "TarmedLeistungDistinctLaws").executeWithParameters(Collections.emptyMap());
    }

    public static boolean isAvailableLaw(String law) {
        if (availableLawsCache == null) {
            availableLawsCache = ArzttarifeUtil.getAvailableLaws();
        }
        for (String available : availableLawsCache) {
            if (!available.equalsIgnoreCase(law)) continue;
            return true;
        }
        return false;
    }
}

