/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tarmedallowance.model;

import ch.elexis.base.ch.arzttarife.model.service.ContextServiceHolder;
import ch.elexis.base.ch.arzttarife.model.service.CoreModelServiceHolder;
import ch.elexis.base.ch.arzttarife.tarmedallowance.ITarmedAllowance;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.TarmedPauschalen;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.billable.AbstractOptifier;
import ch.elexis.core.model.billable.DefaultVerifier;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.rgw.tools.Money;
import java.time.LocalDate;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class TarmedAllowance
extends AbstractIdDeleteModelAdapter<TarmedPauschalen>
implements Identifiable,
ITarmedAllowance {
    public static final String STS_CLASS = "ch.elexis.data.TarmedPauschalen";
    private static IBillableOptifier<TarmedAllowance> optifier;
    private IBillableVerifier verifier = new DefaultVerifier();

    public TarmedAllowance(TarmedPauschalen entity) {
        super((EntityWithId)entity);
    }

    public IBillableOptifier<TarmedAllowance> getOptifier() {
        if (optifier == null) {
            optifier = new AbstractOptifier<TarmedAllowance>(CoreModelServiceHolder.get(), ContextServiceHolder.get().get()){

                protected void setPrice(TarmedAllowance billable, IBilled billed) {
                    billed.setFactor(1.0);
                    billed.setPoints(billable.getPrice(billed.getEncounter()).getCents());
                }

                public Optional<IBillingSystemFactor> getFactor(IEncounter encounter) {
                    return Optional.empty();
                }
            };
        }
        return optifier;
    }

    protected Money getPrice(IEncounter iEncounter) {
        if (StringUtils.isNotBlank((CharSequence)((TarmedPauschalen)this.getEntity()).getTp())) {
            try {
                int cents = Integer.parseInt(((TarmedPauschalen)this.getEntity()).getTp());
                return new Money(cents);
            }
            catch (NumberFormatException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Ignoring non integer tp value [" + ((TarmedPauschalen)this.getEntity()).getTp() + "] of [" + String.valueOf(this) + "]");
            }
        }
        return new Money();
    }

    public IBillableVerifier getVerifier() {
        return this.verifier;
    }

    public String getCodeSystemName() {
        return "Tarmedpauschalen";
    }

    public String getCodeSystemCode() {
        return "003";
    }

    public String getCode() {
        return ((TarmedPauschalen)this.getEntity()).getCode();
    }

    public void setCode(String value) {
        ((TarmedPauschalen)this.getEntity()).setCode(value);
    }

    public String getText() {
        return ((TarmedPauschalen)this.getEntity()).getText();
    }

    public void setText(String value) {
        ((TarmedPauschalen)this.getEntity()).setText(value);
    }

    @Override
    public LocalDate getValidFrom() {
        return ((TarmedPauschalen)this.getEntity()).getValidFrom();
    }

    @Override
    public void setValidFrom(LocalDate value) {
    }

    @Override
    public LocalDate getValidTo() {
        return ((TarmedPauschalen)this.getEntity()).getValidTo();
    }

    @Override
    public void setValidTo(LocalDate value) {
    }

    @Override
    public String getChapter() {
        return ((TarmedPauschalen)this.getEntity()).getChapter();
    }

    @Override
    public void setChapter(String value) {
        ((TarmedPauschalen)this.getEntity()).setChapter(value);
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }

    public String getLabel() {
        return "(" + this.getCode() + ") " + this.getChapter() + " - " + this.getText();
    }

    @Override
    public String getTP() {
        return ((TarmedPauschalen)this.getEntity()).getTp();
    }

    @Override
    public void setTP(String value) {
        ((TarmedPauschalen)this.getEntityMarkDirty()).setTp(value);
    }
}

