/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tardoc.model;

import ch.elexis.base.ch.arzttarife.model.service.ArzttarifeModelServiceHolder;
import ch.elexis.base.ch.arzttarife.tardoc.ITardocLeistung;
import ch.elexis.core.model.Identifiable;
import java.util.Optional;

public class VersionUtil {
    public static final String VERSION_ENTRY_ID = "Version";
    private static final String DATASET_VERSION_SEPARATOR = "|";
    private static final String DATASET_LAW_SEPARATOR = ":=:";

    public static int getCurrentVersion() {
        return VersionUtil.getCurrentVersion("");
    }

    public static int getCurrentVersion(String law) {
        Optional versionEntry = ArzttarifeModelServiceHolder.get().load(VERSION_ENTRY_ID, ITardocLeistung.class);
        if (law == null || law.isEmpty()) {
            String versionVal = (String)ArzttarifeModelServiceHolder.get().getEntityProperty("code_", (Identifiable)versionEntry.get());
            return VersionUtil.getVersionAsInt(versionVal);
        }
        String versionVal = (String)ArzttarifeModelServiceHolder.get().getEntityProperty("tx255", (Identifiable)versionEntry.get());
        if (versionVal != null) {
            String[] parts;
            String[] stringArray = parts = versionVal.split("\\|");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                String[] subParts = part.split(DATASET_LAW_SEPARATOR);
                if (subParts.length == 2 && law.equals(subParts[0])) {
                    return VersionUtil.getVersionAsInt(subParts[1]);
                }
                ++n2;
            }
        }
        return -1;
    }

    private static int getVersionAsInt(String versionVal) {
        try {
            return Integer.parseInt(versionVal);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static Optional<ITardocLeistung> createVersionEntry() {
        ITardocLeistung versionEntry = (ITardocLeistung)ArzttarifeModelServiceHolder.get().create(ITardocLeistung.class);
        ArzttarifeModelServiceHolder.get().setEntityProperty("id", (Object)VERSION_ENTRY_ID, (Identifiable)versionEntry);
        ArzttarifeModelServiceHolder.get().setEntityProperty("nickname", (Object)"1.0.0", (Identifiable)versionEntry);
        ArzttarifeModelServiceHolder.get().save((Identifiable)versionEntry);
        return Optional.of(versionEntry);
    }

    public static void setCurrentVersion(String versionVal, String law) {
        Optional<ITardocLeistung> versionEntry = ArzttarifeModelServiceHolder.get().load(VERSION_ENTRY_ID, ITardocLeistung.class);
        if (law == null || law.isEmpty()) {
            if (!versionEntry.isPresent()) {
                versionEntry = VersionUtil.createVersionEntry();
            }
            ArzttarifeModelServiceHolder.get().setEntityProperty("code_", (Object)versionVal, (Identifiable)versionEntry.get());
        } else {
            String[] parts;
            boolean found = false;
            StringBuilder sb = new StringBuilder();
            String oldVersions = (String)ArzttarifeModelServiceHolder.get().getEntityProperty("tx255", (Identifiable)versionEntry.get());
            if (oldVersions == null) {
                oldVersions = "";
            }
            String[] stringArray = parts = oldVersions.split("\\|");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                String[] subParts = part.split(DATASET_LAW_SEPARATOR);
                if (subParts.length == 2) {
                    if (sb.length() > 0) {
                        sb.append(DATASET_VERSION_SEPARATOR);
                    }
                    sb.append(subParts[0]);
                    if (law.equals(subParts[0])) {
                        sb.append(DATASET_LAW_SEPARATOR).append(versionVal);
                        found = true;
                    } else {
                        sb.append(DATASET_LAW_SEPARATOR).append(subParts[1]);
                    }
                }
                ++n2;
            }
            if (!found) {
                if (sb.length() > 0) {
                    sb.append(DATASET_VERSION_SEPARATOR);
                }
                sb.append(law).append(DATASET_LAW_SEPARATOR).append(versionVal);
            }
            ArzttarifeModelServiceHolder.get().setEntityProperty("tx255", (Object)sb.toString(), (Identifiable)versionEntry.get());
        }
        ArzttarifeModelServiceHolder.get().save((Identifiable)versionEntry.get());
    }
}

