/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tardoc.model;

import ch.elexis.base.ch.arzttarife.model.service.CoreModelServiceHolder;
import ch.elexis.base.ch.arzttarife.tardoc.model.TardocLeistung;
import ch.elexis.base.ch.arzttarife.tardoc.model.TardocLimitation;
import ch.elexis.base.ch.arzttarife.tardoc.model.TardocVerifier;
import ch.elexis.base.ch.arzttarife.tardoc.tarifmatcher.TarifMatcher;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedUtil;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IBilledBuilder;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.rgw.tools.Result;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class TardocOptifier
implements IBillableOptifier<TardocLeistung> {
    private Map<String, Object> contextMap;
    private TardocVerifier verifier = new TardocVerifier();
    private TarifMatcher<TardocLeistung> tarifMatcher;

    public Result<IBilled> add(TardocLeistung code, IEncounter encounter, double amount, boolean save) {
        int amountInt = this.doubleToInt(amount);
        boolean setNonIntAmount = amount % 1.0 != 0.0;
        Result<IBilled> result = null;
        try {
            if (!code.isChapter() && amountInt >= 1) {
                result = this.add(code, encounter, save);
                if (amountInt == 1) {
                    Result<IBilled> result2 = result;
                    return result2;
                }
                int i = 2;
                while (i <= amountInt) {
                    Result<IBilled> intermediateResult = this.add(code, encounter, save);
                    if (!intermediateResult.isOK()) {
                        result.addMessage(Result.SEVERITY.WARNING, intermediateResult.toString(), (Object)((IBilled)result.get()));
                        Result<IBilled> result3 = result;
                        return result3;
                    }
                    result = intermediateResult;
                    ++i;
                }
                Result<IBilled> result4 = result;
                return result4;
            }
            Result result5 = Result.OK();
            return result5;
        }
        finally {
            if (setNonIntAmount && result != null && result.get() != null) {
                ((IBilled)result.get()).setAmount(amount);
                if (save) {
                    CoreModelServiceHolder.get().save((Identifiable)result.get());
                }
            }
        }
    }

    private Result<IBilled> add(TardocLeistung code, IEncounter encounter, boolean save) {
        Result<IBilled> matcherResult;
        Result<IBilled> resultAddBezug;
        if (this.tarifMatcher == null) {
            this.tarifMatcher = new TarifMatcher<TardocLeistung>(this);
        }
        boolean bOptify = TarmedUtil.getConfigValue(this.getClass(), IMandator.class, "billing/optify", true);
        boolean bAllowOverrideStrict = TarmedUtil.getConfigValue(this.getClass(), IUser.class, "billing/allowoverride/strict", false);
        IBilled newBilled = this.getOrInitializeBilled(code, encounter, false);
        if (code.requiresSide()) {
            Result<IBilled> resultSide = this.setNewBilledSideOrIncrement(newBilled, encounter);
            if (!resultSide.isOK()) {
                return resultSide;
            }
            if (!((IBilled)resultSide.get()).equals(newBilled)) {
                newBilled = (IBilled)resultSide.get();
            }
        }
        if (code.isZuschlagsleistung() && !(resultAddBezug = this.addBezug(newBilled, encounter)).isOK()) {
            return resultAddBezug;
        }
        if (bOptify) {
            Result<IBilled> limitationsResult = this.verifier.checkLimitations(encounter, code, newBilled);
            if (!limitationsResult.isOK()) {
                if (bAllowOverrideStrict) {
                    if (save) {
                        CoreModelServiceHolder.get().save((Identifiable)newBilled);
                    }
                    return limitationsResult;
                }
                CoreModelServiceHolder.get().refresh((Identifiable)newBilled, true, true);
                return limitationsResult;
            }
            Result<IBilled> digniResult = this.verifier.checkDigni(encounter, code, newBilled);
            if (!digniResult.isOK()) {
                if (bAllowOverrideStrict) {
                    if (save) {
                        CoreModelServiceHolder.get().save((Identifiable)newBilled);
                    }
                    return digniResult;
                }
                CoreModelServiceHolder.get().refresh((Identifiable)newBilled, true, true);
                return digniResult;
            }
        }
        if (!(matcherResult = this.tarifMatcher.evaluate(newBilled, encounter)).isOK()) {
            if (bAllowOverrideStrict) {
                if (save) {
                    CoreModelServiceHolder.get().save((Identifiable)newBilled);
                    CoreModelServiceHolder.get().save((Identifiable)encounter);
                    CoreModelServiceHolder.get().save((Identifiable)matcherResult.get());
                }
            } else {
                CoreModelServiceHolder.get().refresh((Identifiable)encounter, true);
            }
        } else if (save) {
            CoreModelServiceHolder.get().save((Identifiable)encounter);
            CoreModelServiceHolder.get().save((Identifiable)matcherResult.get());
        }
        return matcherResult;
    }

    private Result<IBilled> setNewBilledSideOrIncrement(IBilled newBilled, IEncounter encounter) {
        int countSideLeft = 0;
        IBilled leftVerrechnet = null;
        int countSideRight = 0;
        IBilled rightVerrechnet = null;
        for (IBilled v : encounter.getBilled()) {
            if (!this.isInstance(v, (ICodeElement)newBilled.getBillable())) continue;
            String side = (String)v.getExtInfo((Object)"Seite");
            if (side.equals("l")) {
                countSideLeft = (int)((double)countSideLeft + v.getAmount());
                leftVerrechnet = v;
                continue;
            }
            countSideRight = (int)((double)countSideRight + v.getAmount());
            rightVerrechnet = v;
        }
        if (this.isContext("Seite")) {
            String side = (String)this.getContextValue("Seite");
            if ("l".equals(side) && countSideLeft > 0 && leftVerrechnet != null) {
                newBilled = leftVerrechnet;
                newBilled.setAmount(newBilled.getAmount() + 1.0);
            } else if ("r".equals(side) && countSideRight > 0 && rightVerrechnet != null) {
                newBilled = rightVerrechnet;
                newBilled.setAmount(newBilled.getAmount() + 1.0);
            }
        }
        if (countSideLeft > 0 || countSideRight > 0) {
            if (countSideLeft > countSideRight && rightVerrechnet != null) {
                newBilled = rightVerrechnet;
                newBilled.setAmount(newBilled.getAmount() + 1.0);
            } else if (countSideLeft <= countSideRight && leftVerrechnet != null) {
                newBilled = leftVerrechnet;
                newBilled.setAmount(newBilled.getAmount() + 1.0);
            } else if (countSideLeft > countSideRight && rightVerrechnet == null) {
                newBilled.setAmount(newBilled.getAmount() - 1.0);
                newBilled = this.initializeBilled((TardocLeistung)newBilled.getBillable(), encounter, false);
                newBilled.setExtInfo((Object)"Seite", (Object)"r");
                return new Result((Object)newBilled);
            }
        }
        newBilled.setExtInfo((Object)"Seite", (Object)"l");
        return new Result((Object)newBilled);
    }

    private boolean isContext(String key) {
        return this.getContextValue(key) != null;
    }

    private Object getContextValue(String key) {
        if (this.contextMap != null) {
            return this.contextMap.get(key);
        }
        return null;
    }

    private boolean isInstance(IBilled billed, ICodeElement billable) {
        boolean sameCode = billed.getBillable().getCode().equals(billable.getCode());
        boolean sameCodeSystemCode = billed.getBillable().getCodeSystemCode().equals(billable.getCodeSystemCode());
        return sameCodeSystemCode && sameCode;
    }

    private Result<IBilled> addBezug(IBilled newBilled, IEncounter encounter) {
        if (StringUtils.isBlank((CharSequence)((String)newBilled.getExtInfo((Object)"Bezug")))) {
            List<IBilled> masters = this.getPossibleMasters(newBilled, encounter.getBilled());
            if (masters.isEmpty()) {
                return new Result(Result.SEVERITY.WARNING, 3, "F\u00fcr die Zuschlagsleistung " + newBilled.getCode() + " konnte keine passende Hauptleistung gefunden werden.", null, false);
            }
            if (!masters.isEmpty()) {
                String bezug = (String)newBilled.getExtInfo((Object)"Bezug");
                if (bezug == null) {
                    newBilled.setExtInfo((Object)"Bezug", (Object)masters.get(0).getCode());
                } else {
                    boolean found = false;
                    for (IBilled mVerr : masters) {
                        if (!mVerr.getCode().equals(bezug)) continue;
                        found = true;
                    }
                }
            }
        }
        return new Result((Object)newBilled);
    }

    private List<IBilled> getPossibleMasters(IBilled newSlave, List<IBilled> lst) {
        TardocLeistung slaveTarmed = (TardocLeistung)newSlave.getBillable();
        List<IBilled> masters = this.getAvailableMasters(slaveTarmed, lst);
        int maxPerMaster = this.getMaxPerMaster(slaveTarmed);
        if (maxPerMaster > 0) {
            Map<IBilled, List<IBilled>> masterSlavesMap = this.getMasterToSlavesMap(newSlave, lst);
            for (IBilled master : masterSlavesMap.keySet()) {
                double masterCount = master.getAmount();
                int slaveCount = 0;
                for (IBilled slave : masterSlavesMap.get(master)) {
                    slaveCount = (int)((double)slaveCount + slave.getAmount());
                    if (!slave.equals(newSlave)) continue;
                    --slaveCount;
                }
                if (!(masterCount <= (double)(slaveCount * maxPerMaster))) continue;
                masters.remove(master);
            }
        }
        return masters;
    }

    private List<IBilled> getAvailableMasters(TardocLeistung slave, List<IBilled> lst) {
        LinkedList<IBilled> ret = new LinkedList<IBilled>();
        LocalDate konsDate = null;
        for (IBilled v : lst) {
            TardocLeistung tl;
            if (konsDate == null) {
                konsDate = v.getEncounter().getDate();
            }
            if (!(v.getBillable() instanceof TardocLeistung) || !(tl = (TardocLeistung)v.getBillable()).getHierarchy(konsDate).contains(slave.getCode())) continue;
            ret.add(v);
        }
        return ret;
    }

    private int getMaxPerMaster(TardocLeistung slave) {
        List<TardocLimitation> limits = slave.getLimitations();
        for (TardocLimitation limit : limits) {
            if (limit.getLimitationUnit() != TardocLimitation.LimitationUnit.MAINSERVICE) continue;
            return limit.getAmount();
        }
        return -1;
    }

    private Map<IBilled, List<IBilled>> getMasterToSlavesMap(IBilled newSlave, List<IBilled> lst) {
        HashMap<IBilled, List<IBilled>> ret = new HashMap<IBilled, List<IBilled>>();
        TardocLeistung slaveTarmed = (TardocLeistung)newSlave.getBillable();
        List<IBilled> masters = this.getAvailableMasters(slaveTarmed, lst);
        for (IBilled verrechnet : masters) {
            ret.put(verrechnet, new ArrayList());
        }
        List<IBilled> slaves = this.getVerrechnetMatchingCode(lst, newSlave.getCode());
        for (IBilled slave : slaves) {
            String bezug = (String)slave.getExtInfo((Object)"Bezug");
            if (bezug == null || bezug.isEmpty()) continue;
            for (IBilled master : ret.keySet()) {
                if (!master.getCode().equals(bezug)) continue;
                ((List)ret.get(master)).add(slave);
            }
        }
        return ret;
    }

    private List<IBilled> getVerrechnetMatchingCode(List<IBilled> lst, String code) {
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        for (IBilled v : lst) {
            TardocLeistung tl;
            if (!(v.getBillable() instanceof TardocLeistung) || !(tl = (TardocLeistung)v.getBillable()).getCode().equals(code)) continue;
            ret.add(v);
        }
        return ret;
    }

    public void putContext(String key, Object value) {
        if (this.contextMap == null) {
            this.contextMap = new HashMap<String, Object>();
        }
        this.contextMap.put(key, value);
    }

    public void clearContext() {
        if (this.contextMap != null) {
            this.contextMap.clear();
        }
    }

    public Result<IBilled> remove(IBilled billed, IEncounter encounter) {
        List l = encounter.getBilled();
        l.remove(billed);
        this.deleteBilled(billed);
        List<IBilled> left = this.getVerrechnetMatchingCode(l, billed.getCode());
        if (left.isEmpty()) {
            List<IBilled> verrechnetWithBezug = this.getVerrechnetWithBezugMatchingCode(encounter.getBilled(), billed.getCode());
            for (IBilled verrechnet : verrechnetWithBezug) {
                this.remove(verrechnet, encounter);
            }
        }
        return new Result((Object)billed);
    }

    private void deleteBilled(IBilled billed) {
        CoreModelServiceHolder.get().delete((Deleteable)billed);
    }

    private List<IBilled> getVerrechnetWithBezugMatchingCode(List<IBilled> lst, String code) {
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        for (IBilled v : lst) {
            if (!(v.getBillable() instanceof TardocLeistung) || !code.equals(v.getExtInfo((Object)"Bezug"))) continue;
            ret.add(v);
        }
        return ret;
    }

    public Optional<IBillingSystemFactor> getFactor(IEncounter encounter) {
        return BillingServiceHolder.get().getBillingSystemFactor(encounter.getCoverage().getBillingSystem().getName(), encounter.getDate());
    }

    private IBilled getOrInitializeBilled(TardocLeistung code, IEncounter kons, boolean save) {
        IBilled ret = null;
        for (IBilled billed : kons.getBilled()) {
            if (!this.isInstance(billed, (ICodeElement)code)) continue;
            ret = billed;
            ret.setAmount(ret.getAmount() + 1.0);
            break;
        }
        if (ret == null) {
            ret = this.initializeBilled(code, kons, save);
        }
        if (save) {
            CoreModelServiceHolder.get().save(ret);
        }
        return ret;
    }

    private IBilled initializeBilled(TardocLeistung code, IEncounter kons, boolean save) {
        IContact biller = (IContact)ContextServiceHolder.get().getActiveUserContact().get();
        IBilled ret = (IBilled)new IBilledBuilder(CoreModelServiceHolder.get(), (IBillable)code, kons, biller).build();
        ret.setPoints(code.getAL(kons.getMandator()) + code.getIPL());
        ret.setExtInfo((Object)"AL", (Object)Integer.toString(code.getAL(kons.getMandator())));
        ret.setExtInfo((Object)"TL", (Object)Integer.toString(code.getIPL()));
        Optional<IBillingSystemFactor> systemFactor = this.getFactor(kons);
        if (systemFactor.isPresent()) {
            ret.setFactor(systemFactor.get().getFactor());
        } else {
            ret.setFactor(1.0);
        }
        if (this.isFactorBased(code)) {
            this.applyCalculateFactorBasedPrice(ret, code, kons);
        }
        return ret;
    }

    private void applyCalculateFactorBasedPrice(IBilled billed, TardocLeistung code, IEncounter encounter) {
        Double tlFactor;
        Optional<Object> bezug = Optional.empty();
        List<IBilled> masters = this.getPossibleMasters(billed, encounter.getBilled());
        if (!masters.isEmpty()) {
            bezug = Optional.of(masters.get(0).getCode());
        }
        Double alFactor = this.getFactorValue(code, "F_AL");
        double alSum = 0.0;
        double tlSum = 0.0;
        if (alFactor > 0.0) {
            for (IBilled v : encounter.getBilled()) {
                if (!(v.getBillable() instanceof TardocLeistung)) continue;
                TardocLeistung tl = (TardocLeistung)v.getBillable();
                if (!bezug.isEmpty() && !((String)bezug.get()).equals(tl.getCode())) continue;
                alSum += (double)tl.getAL(encounter.getMandator()) * v.getAmount();
            }
            billed.setPoints((int)Math.round(alSum));
            billed.setExtInfo((Object)"AL", (Object)Double.toString(alSum));
            billed.setPrimaryScale((int)(alFactor * 100.0));
        }
        if ((tlFactor = this.getFactorValue(code, "F_TL")) > 0.0 && (alFactor == 0.0 || Double.compare(tlFactor, alFactor) == 0)) {
            for (IBilled v : encounter.getBilled()) {
                if (!(v.getBillable() instanceof TardocLeistung)) continue;
                TardocLeistung tl = (TardocLeistung)v.getBillable();
                if (!bezug.isEmpty() && !((String)bezug.get()).equals(tl.getCode())) continue;
                tlSum += (double)tl.getIPL() * v.getAmount();
            }
            billed.setPoints((int)Math.round(tlSum + alSum));
            billed.setExtInfo((Object)"TL", (Object)Double.toString(tlSum));
            billed.setPrimaryScale((int)(tlFactor * 100.0));
        }
    }

    private boolean isFactorBased(TardocLeistung code) {
        if (code.getExtension() != null) {
            Double alFactor = this.getFactorValue(code, "F_AL");
            Double tlFactor = this.getFactorValue(code, "F_TL");
            return alFactor > 0.0 || tlFactor > 0.0;
        }
        return false;
    }

    private Double getFactorValue(TardocLeistung code, String key) {
        if (code.getExtension() != null && code.getExtension().getExtInfo(key) != null) {
            try {
                return Double.parseDouble((String)code.getExtension().getExtInfo(key));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0.0;
    }

    private int doubleToInt(double value) {
        BigDecimal bd = new BigDecimal(value);
        if ((bd = bd.setScale(0, RoundingMode.HALF_UP)).intValue() > 0) {
            return bd.intValue();
        }
        return 1;
    }
}

