/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tardoc.model.importer;

import ch.elexis.base.ch.arzttarife.tardoc.model.importer.ServiceImporter;
import ch.elexis.base.ch.arzttarife.tarmed.model.importer.EntityUtil;
import ch.elexis.base.ch.arzttarife.tarmed.model.importer.ImporterUtil;
import ch.elexis.core.jpa.entities.TardocExtension;
import ch.elexis.core.jpa.entities.TardocGroup;
import ch.elexis.core.jpa.entities.TardocKumulation;
import ch.elexis.core.jpa.model.util.JpaModelUtil;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupImporter {
    private static final Logger logger = LoggerFactory.getLogger(ServiceImporter.class);
    private JdbcLink cacheDb;
    private String lang;
    private String law;
    private TimeTool validFrom;
    private TimeTool validTo;
    private HashMap<String, TransientTardocGroup> loadedGroups;

    public GroupImporter(JdbcLink cacheDb, String lang, String law) {
        this.cacheDb = cacheDb;
        this.lang = lang;
        this.law = law;
        this.validFrom = new TimeTool();
        this.validTo = new TimeTool();
        this.loadedGroups = new HashMap();
    }

    public IStatus doImport(IProgressMonitor ipm) throws SQLException, IOException {
        JdbcLink.Stm servicesStm = null;
        try {
            ipm.subTask("Importiere Gruppen");
            servicesStm = this.cacheDb.getStatement();
            ResultSet res = servicesStm.query(String.format("SELECT * FROM %sLEISTUNG_GRUPPEN", "TARDOC_IMPORT_"));
            while (res.next()) {
                String groupName = res.getString("GRUPPE");
                String serviceCode = res.getString("LNR");
                this.initValidTime(res);
                String id = this.getIdString(groupName, this.law);
                TransientTardocGroup transientGroup = this.loadedGroups.get(id);
                if (transientGroup == null) {
                    transientGroup = new TransientTardocGroup(id, groupName, this.law, this.validFrom.toLocalDate(), this.validTo.toLocalDate(), this);
                    this.loadedGroups.put(id, transientGroup);
                }
                transientGroup.addService(serviceCode);
            }
            for (String key : this.loadedGroups.keySet()) {
                TransientTardocGroup transientGroup = this.loadedGroups.get(key);
                TardocGroup group = transientGroup.persist();
                logger.debug("Imported " + group.getGroupName());
            }
        }
        finally {
            if (servicesStm != null) {
                this.cacheDb.releaseStatement(servicesStm);
            }
        }
        return Status.OK_STATUS;
    }

    private void initValidTime(ResultSet res) throws SQLException {
        this.validFrom.set(res.getString("GUELTIG_VON"));
        this.validTo.set(res.getString("GUELTIG_BIS"));
    }

    private String getIdString(String groupName, String law) {
        return "GRP" + groupName + "-" + this.validFrom.toString(9) + this.getLawIdExtension();
    }

    private String getLawIdExtension() {
        if (this.law != null && !this.law.isEmpty()) {
            return "-" + this.law;
        }
        return "";
    }

    private static class TransientTardocGroup {
        private String id;
        private String code;
        private String law;
        private StringBuilder services;
        private LocalDate validFrom;
        private LocalDate validTo;
        private GroupImporter importer;

        public TransientTardocGroup(String id, String groupName, String law, LocalDate validFrom, LocalDate validTo, GroupImporter importer) {
            this.id = id;
            this.code = groupName;
            this.law = law;
            this.validFrom = validFrom;
            this.validTo = validTo;
            this.services = new StringBuilder();
            this.importer = importer;
        }

        public TardocGroup persist() throws SQLException, IOException {
            TardocGroup persistent = new TardocGroup();
            persistent.setId(this.id);
            persistent.setGroupName(this.code);
            persistent.setLaw(this.law);
            persistent.setValidFrom(this.validFrom);
            persistent.setValidTo(this.validTo);
            persistent.setRawServices(this.services.toString());
            TardocExtension extension = new TardocExtension();
            extension.setCode(persistent.getId());
            Map extensionMap = JpaModelUtil.extInfoFromBytes((byte[])extension.getExtInfo());
            String limits = this.getLimits(this.code);
            extensionMap.put("limits", limits);
            this.importKumulations(this.code);
            extension.setExtInfo(JpaModelUtil.extInfoToBytes((Map)extensionMap));
            EntityUtil.save(Arrays.asList(persistent, extension));
            return persistent;
        }

        public void addService(String serviceCode) {
            if (this.services.length() > 0) {
                this.services.append(TardocGroup.SERVICES_SEPARATOR);
            }
            this.services.append(serviceCode);
        }

        private String getLimits(String groupName) throws SQLException, IOException {
            StringBuilder sb = new StringBuilder();
            JdbcLink.Stm subStm = this.importer.cacheDb.getStatement();
            try {
                ResultSet rsub = subStm.query(String.format("SELECT * FROM %sLEISTUNG_MENGEN_ZEIT WHERE LNR='%s' AND ART='G'", "TARDOC_IMPORT_", groupName));
                List<Map<String, String>> validResults = ImporterUtil.getValidValueMaps(rsub, new TimeTool(this.validFrom));
                if (!validResults.isEmpty()) {
                    for (Map<String, String> map : validResults) {
                        sb.append(map.get("OPERATOR")).append(",");
                        sb.append(map.get("MENGE")).append(",");
                        sb.append(map.get("ZR_ANZAHL")).append(",");
                        sb.append(map.get("PRO_NACH")).append(",");
                        sb.append(map.get("ZR_EINHEIT")).append(",");
                        sb.append(map.get("REGEL_EL_ABR")).append("#");
                    }
                }
                rsub.close();
            }
            finally {
                if (subStm != null) {
                    this.importer.cacheDb.releaseStatement(subStm);
                }
            }
            return sb.toString();
        }

        private void importKumulations(String groupName) throws SQLException {
            JdbcLink.Stm subStm = this.importer.cacheDb.getStatement();
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (ResultSet res = subStm.query(String.format("SELECT * FROM %sLEISTUNG_KUMULATION WHERE LNR_MASTER=%s AND ART_MASTER='G'", "TARDOC_IMPORT_", JdbcLink.wrap((String)groupName)));){
                    TimeTool fromTime = new TimeTool();
                    TimeTool toTime = new TimeTool();
                    ArrayList<Object> kumulations = new ArrayList<Object>();
                    while (res != null && res.next()) {
                        fromTime.set(res.getString("GUELTIG_VON"));
                        toTime.set(res.getString("GUELTIG_BIS"));
                        TardocKumulation kumulation = new TardocKumulation();
                        kumulation.setMasterCode(groupName);
                        kumulation.setMasterArt(res.getString("ART_MASTER"));
                        kumulation.setSlaveCode(res.getString("LNR_SLAVE"));
                        kumulation.setSlaveArt(res.getString("ART_SLAVE"));
                        kumulation.setTyp(res.getString("TYP"));
                        kumulation.setView(res.getString("ANZEIGE"));
                        kumulation.setValidSide(res.getString("GUELTIG_SEITE"));
                        kumulation.setValidFrom(fromTime.toLocalDate());
                        kumulation.setValidTo(toTime.toLocalDate());
                        kumulation.setLaw(this.law);
                        kumulations.add(kumulation);
                    }
                    EntityUtil.save(kumulations);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                if (subStm != null) {
                    this.importer.cacheDb.releaseStatement(subStm);
                }
            }
        }
    }
}

