/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tarmedallowance.model.importer;

import ch.elexis.base.ch.arzttarife.tarmed.model.importer.EntityUtil;
import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.jpa.entities.TarmedPauschalen;
import ch.rgw.tools.TimeTool;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component(property={"referenceDataId=tarmedallowance"})
public class TarmedAllowanceReferenceDataImporter
extends AbstractReferenceDataImporter
implements IReferenceDataImporter {
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    public IStatus performImport(IProgressMonitor monitor, InputStream input, Integer newVersion) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IStatus ret = Status.OK_STATUS;
        ExcelWrapper exw = new ExcelWrapper();
        exw.setFieldTypes(new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, TimeTool.class, TimeTool.class});
        if (exw.load(input, 0)) {
            int first = exw.getFirstRow();
            int last = exw.getLastRow();
            int count = last - first;
            if (monitor != null) {
                monitor.beginTask("Tarmedpauschalen Import", count);
            }
            ArrayList<Object> imported = new ArrayList<Object>();
            ArrayList<Object> closed = new ArrayList<Object>();
            LocalDate now = LocalDate.now();
            int i = 0;
            while (i < last) {
                List line = exw.getRow(i);
                if (line == null) break;
                if (!line.isEmpty() && ((String)line.get(0)).equals("003") && !StringUtils.isBlank((CharSequence)((CharSequence)line.get(8)))) {
                    List<TarmedPauschalen> existing = this.getExisting((String)line.get(8), this.getValidFrom(line));
                    if (!existing.isEmpty()) {
                        for (TarmedPauschalen tarmedPauschalen : existing) {
                            tarmedPauschalen.setValidTo(this.getValidTo(line));
                            closed.add(tarmedPauschalen);
                        }
                    } else {
                        TarmedPauschalen tarmedPauschalen;
                        tarmedPauschalen = new TarmedPauschalen();
                        tarmedPauschalen.setCode((String)line.get(8));
                        tarmedPauschalen.setText(this.getText(line));
                        tarmedPauschalen.setChapter(this.getChapter(line));
                        tarmedPauschalen.setValidFrom(this.getValidFrom(line));
                        if (this.getValidTo(line).isBefore(now)) {
                            tarmedPauschalen.setValidTo(this.getValidTo(line));
                        }
                        imported.add(tarmedPauschalen);
                    }
                }
                ++i;
            }
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Closing " + closed.size() + " and creating " + imported.size() + " tarifs");
            EntityUtil.save(closed);
            EntityUtil.save(imported);
            monitor.done();
            if (newVersion != null) {
                TarmedAllowanceReferenceDataImporter.setCurrentVersion(newVersion);
            }
        } else {
            ret = Status.CANCEL_STATUS;
        }
        return ret;
    }

    private String getText(List<String> line) {
        return StringUtils.abbreviate((String)line.get(9).replace("\n", ";").replace("\r", ""), (int)255);
    }

    private String getChapter(List<String> line) {
        return StringUtils.abbreviate((String)line.get(5).replace("\n", ";").replace("\r", ""), (int)255);
    }

    private List<TarmedPauschalen> getExisting(String code, LocalDate validFrom) {
        LinkedHashMap<String, Object> propertyMap = new LinkedHashMap<String, Object>();
        propertyMap.put("code", code);
        propertyMap.put("validFrom", validFrom);
        return EntityUtil.loadByNamedQuery(propertyMap, TarmedPauschalen.class);
    }

    private LocalDate getValidFrom(List<String> line) {
        return this.getLocalDate(line.get(12).trim());
    }

    private LocalDate getValidTo(List<String> line) {
        if (StringUtils.isNotBlank((CharSequence)line.get(13).trim())) {
            return this.getLocalDate(line.get(13).trim());
        }
        return LocalDate.MAX;
    }

    private LocalDate getLocalDate(String value) {
        try {
            if (value.isEmpty()) {
                return LocalDate.parse("01.01.2016", this.dateFormatter);
            }
            if (value.length() < 11) {
                return LocalDate.parse(value, this.dateFormatter);
            }
            return LocalDate.parse(value, this.dateTimeFormatter);
        }
        catch (DateTimeParseException pe) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Could not parse as local date [" + value + "]");
            throw pe;
        }
    }

    public static void setCurrentVersion(int newVersion) {
        TarmedPauschalen versionEntry = EntityUtil.load("VERSION", TarmedPauschalen.class);
        if (versionEntry != null) {
            versionEntry.setChapter(Integer.toString(newVersion));
            EntityUtil.save(Collections.singletonList(versionEntry));
            return;
        }
        throw new IllegalArgumentException("No Version entry");
    }

    public int getCurrentVersion() {
        String chapter;
        TarmedPauschalen versionEntry = EntityUtil.load("VERSION", TarmedPauschalen.class);
        if (versionEntry != null && (chapter = versionEntry.getChapter()) != null) {
            try {
                return Integer.parseInt(chapter.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }
}

