/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tardoc.tarifmatcher;

import ch.elexis.core.utils.CoreUtil;
import ch.oaat_otma.PatientCase;
import ch.oaat_otma.grouper.ClassificationSystemReader;
import ch.oaat_otma.grouper.GrouperResult;
import ch.oaat_otma.grouper.PatientClassificationSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component(service={PatientClassificationSystemService.class})
public class PatientClassificationSystemService {
    private static final String LKAAT_FILENAME = "system_ambP_11c_lkaat.json";
    private PatientClassificationSystem classificationSystem;

    @Activate
    public void activate() {
        File rootDir = CoreUtil.getWritableUserDir();
        File tarifmatcherdir = new File(rootDir, "tarifmatcher");
        if (!tarifmatcherdir.exists()) {
            tarifmatcherdir.mkdir();
        }
        File lkaatFile = new File(tarifmatcherdir, LKAAT_FILENAME);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream out = new FileOutputStream(new File(tarifmatcherdir, LKAAT_FILENAME));){
                IOUtils.copy((InputStream)PatientClassificationSystemService.class.getResourceAsStream("/rsc/grouper/system_ambP_11c_lkaat.json"), (OutputStream)out);
                ClassificationSystemReader reader = new ClassificationSystemReader();
                this.classificationSystem = reader.readFromFile(lkaatFile);
                List errors = this.classificationSystem.check();
                assert (errors.size() == 0);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error initializing Casemaster", (Throwable)e);
        }
    }

    public GrouperResult getResult(PatientCase patientCase) {
        return this.classificationSystem.evaluate(patientCase);
    }
}

