/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.psycho.model.importer;

import ch.elexis.base.ch.arzttarife.tarmed.model.importer.EntityUtil;
import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.jpa.entities.PsychoLeistung;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component(property={"referenceDataId=psycho"})
public class PsychoReferenceDataImporter
extends AbstractReferenceDataImporter
implements IReferenceDataImporter {
    public IStatus performImport(IProgressMonitor monitor, InputStream input, Integer newVersion) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IStatus ret = Status.OK_STATUS;
        ExcelWrapper exw = new ExcelWrapper();
        exw.setFieldTypes(new Class[]{String.class, String.class, String.class, String.class, String.class, String.class});
        if (exw.load(input, 0)) {
            int first = exw.getFirstRow();
            int last = exw.getLastRow();
            int count = last - first;
            monitor.beginTask("Pyschotherapie Tarif Import", count);
            ArrayList<Object> imported = new ArrayList<Object>();
            ArrayList<Object> closed = new ArrayList<Object>();
            int i = 0;
            while (i < last) {
                List line = exw.getRow(i);
                if (line == null) break;
                if (!line.isEmpty() && ((String)line.get(0)).length() >= 4 && ((String)line.get(0)).startsWith("P")) {
                    LocalDate validFrom = LocalDate.of(2022, 7, 1);
                    List<PsychoLeistung> existing = this.getExisting((String)line.get(0), validFrom);
                    if (existing.isEmpty()) {
                        PsychoLeistung psychoLeistung = new PsychoLeistung();
                        psychoLeistung.setCode((String)line.get(0));
                        psychoLeistung.setCodeText(StringUtils.abbreviate((String)((String)line.get(1)).replace("\n", "").replace("\r", ""), (int)255));
                        psychoLeistung.setDescription((String)line.get(2));
                        psychoLeistung.setValidFrom(validFrom);
                        psychoLeistung.setLimitations(this.parseLimitations((String)line.get(3)));
                        psychoLeistung.setExclusions(this.parseExclusions((String)line.get(4)));
                        psychoLeistung.setTp(this.parseTp((String)line.get(0), (String)line.get(5)));
                        imported.add(psychoLeistung);
                    }
                }
                ++i;
            }
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Closing " + closed.size() + " and creating " + imported.size() + " tarifs");
            EntityUtil.save(closed);
            EntityUtil.save(imported);
            monitor.done();
            if (newVersion != null) {
                PsychoReferenceDataImporter.setCurrentVersion(newVersion);
            }
        } else {
            ret = Status.CANCEL_STATUS;
        }
        return ret;
    }

    private String parseTp(String code, String string) {
        if ("prozent".equalsIgnoreCase(string)) {
            if ("PN020".equals(code)) {
                return "%20";
            }
        } else {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Scanner scanner = new Scanner(string);){
                if (scanner.hasNextInt()) {
                    return Integer.toString(scanner.nextInt());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        throw new IllegalStateException("Could not parse tp [" + string + "] for code [" + code + "]");
    }

    private String parseExclusions(String string) {
        return string;
    }

    private String parseLimitations(String string) {
        return string;
    }

    private List<PsychoLeistung> getExisting(String code, LocalDate validFrom) {
        LinkedHashMap<String, Object> propertyMap = new LinkedHashMap<String, Object>();
        propertyMap.put("code", code);
        propertyMap.put("validFrom", validFrom);
        return EntityUtil.loadByNamedQuery(propertyMap, PsychoLeistung.class);
    }

    public int getCurrentVersion() {
        String versionString;
        PsychoLeistung versionEntry = EntityUtil.load("VERSION", PsychoLeistung.class);
        if (versionEntry != null && StringUtils.isNumeric((CharSequence)(versionString = versionEntry.getCodeText()))) {
            return Integer.parseInt(versionString);
        }
        return -1;
    }

    public static void setCurrentVersion(int newVersion) {
        PsychoLeistung versionEntry = EntityUtil.load("VERSION", PsychoLeistung.class);
        if (versionEntry != null) {
            versionEntry.setCodeText(Integer.toString(newVersion));
            EntityUtil.save(Collections.singletonList(versionEntry));
            return;
        }
        throw new IllegalArgumentException("No Version entry");
    }
}

