/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tardoc.tarifmatcher;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IDiagnosisReference;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.types.Gender;
import ch.elexis.core.utils.CoreUtil;
import ch.oaat_otma.Diagnosis;
import ch.oaat_otma.Service;
import ch.oaat_otma.Side;
import ch.oaat_otma.Tarpo;
import ch.oaat_otma.casemaster.Casemaster;
import ch.oaat_otma.casemaster.CasemasterResult;
import ch.oaat_otma.casemaster.Patient;
import ch.oaat_otma.casemaster.Session;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component(service={CasemasterService.class})
public class CasemasterService {
    private static final String CAP_ASSIGNMENT_FILENAME = "system_ambP_11c_cap_assignment.json";
    private Casemaster caseMaster;

    @Activate
    public void activate() {
        File rootDir = CoreUtil.getWritableUserDir();
        File tarifmatcherdir = new File(rootDir, "tarifmatcher");
        if (!tarifmatcherdir.exists()) {
            tarifmatcherdir.mkdir();
        }
        File capAssignmentFile = new File(tarifmatcherdir, CAP_ASSIGNMENT_FILENAME);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream out = new FileOutputStream(new File(tarifmatcherdir, CAP_ASSIGNMENT_FILENAME));){
                IOUtils.copy((InputStream)CasemasterService.class.getResourceAsStream("/rsc/casemaster/system_ambP_11c_cap_assignment.json"), (OutputStream)out);
                this.caseMaster = new Casemaster(capAssignmentFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error initializing Casemaster", (Throwable)e);
        }
    }

    public CasemasterResult getResult(IBilled billed, IEncounter encounter) {
        int sessionIdx = 1;
        ArrayList<Session> sessions = new ArrayList<Session>();
        List<IEncounter> encounters = encounter.getCoverage().getEncounters().stream().filter(e -> e.getInvoice() == null || e.getInvoiceState() == InvoiceState.CANCELLED).toList();
        for (IEncounter iEncounter : encounters) {
            Session session = new Session(Integer.valueOf(sessionIdx++), iEncounter.getDate());
            for (IDiagnosisReference diagnose : iEncounter.getDiagnoses()) {
                if (!StringUtils.isNotBlank((CharSequence)diagnose.getCodeSystemName())) continue;
                if (diagnose.getCodeSystemName().toLowerCase().contains("icd")) {
                    session.setDiagnosis(new Diagnosis(diagnose.getCode()));
                    break;
                }
                if (!diagnose.getCodeSystemName().toLowerCase().contains("ti-code")) continue;
                session.setDiagnosis(new Diagnosis(diagnose.getCode()));
            }
            if (iEncounter.equals(encounter)) {
                this.addBilled(billed, session);
            }
            for (IBilled encounterBilled : iEncounter.getBilled()) {
                if (encounterBilled.equals(billed)) continue;
                this.addBilled(encounterBilled, session);
            }
            sessions.add(session);
        }
        Patient patient = new Patient();
        patient.setBirthDate(encounters.get(0).getPatient().getDateOfBirth().toLocalDate());
        patient.setSex(encounters.get(0).getPatient().getGender() == Gender.FEMALE ? "W" : "M");
        patient.setSessions(sessions);
        return this.caseMaster.apply(patient);
    }

    private void addBilled(IBilled billed, Session session) {
        IBillable billable = billed.getBillable();
        if (billable.getCodeSystemName().toLowerCase().contains("tardoc") || billable.getCodeSystemName().toLowerCase().contains("ambulantepauschalen")) {
            session.addService(new Service(billable.getCode(), this.getSide(billed), Double.valueOf(billed.getAmount()).intValue(), billed.getEncounter().getDate(), session.number));
        } else if (!(billable instanceof IArticle) || billable.getCodeSystemCode().equals("402")) {
            session.addTarpo(new Tarpo(billable.getCode(), billable.getCodeSystemCode(), billed.getAmount(), billed.getEncounter().getDate(), billed.getAmount(), Integer.valueOf(billed.getPrice().getCents() / 100), Side.NONE));
        }
    }

    private Side getSide(IBilled billed) {
        if (StringUtils.isNotBlank((CharSequence)((String)billed.getExtInfo((Object)"Seite")))) {
            String side = (String)billed.getExtInfo((Object)"Seite");
            if ("l".equals(side)) {
                return Side.L;
            }
            if ("r".equals(side)) {
                return Side.R;
            }
        }
        return Side.NONE;
    }
}

