/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tardoc.model;

import ch.elexis.base.ch.arzttarife.tardoc.ITardocKumulation;
import ch.elexis.base.ch.arzttarife.tardoc.ITardocLeistung;
import ch.elexis.base.ch.arzttarife.tardoc.TardocKumulationArt;
import ch.elexis.base.ch.arzttarife.tardoc.model.TardocGroup;
import ch.rgw.tools.TimeTool;
import java.util.List;

public class TardocExclusive {
    private String slaveCode;
    private TardocKumulationArt slaveType;

    public TardocExclusive(ITardocKumulation kumulation) {
        this.slaveCode = kumulation.getSlaveCode();
        this.slaveType = kumulation.getSlaveArt();
    }

    public boolean isMatching(ITardocLeistung tarmedLeistung, TimeTool date) {
        if (this.slaveType == TardocKumulationArt.CHAPTER) {
            return this.isMatchingChapter(tarmedLeistung);
        }
        if (this.slaveType == TardocKumulationArt.SERVICE) {
            return this.slaveCode.equals(tarmedLeistung.getCode());
        }
        if (this.slaveType == TardocKumulationArt.GROUP) {
            List<String> groups = tarmedLeistung.getServiceGroups(date.toLocalDate());
            return groups.contains(this.slaveCode);
        }
        if (this.slaveType == TardocKumulationArt.BLOCK) {
            List<String> blocks = tarmedLeistung.getServiceBlocks(date.toLocalDate());
            return blocks.contains(this.slaveCode);
        }
        return false;
    }

    private boolean isMatchingChapter(ITardocLeistung tarmedLeistung) {
        if (this.slaveCode.equals(tarmedLeistung.getCode())) {
            return true;
        }
        ITardocLeistung parent = tarmedLeistung.getParent();
        if (parent != null) {
            return this.isMatchingChapter(parent);
        }
        return false;
    }

    public boolean isMatching(TardocGroup tarmedGroup) {
        if (this.slaveType != TardocKumulationArt.GROUP) {
            return false;
        }
        return this.slaveCode.equals(tarmedGroup.getCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TardocKumulationArt.toString(this.slaveType)).append(" ").append(this.slaveCode);
        return sb.toString();
    }

    public TardocKumulationArt getSlaveType() {
        return this.slaveType;
    }
}

