/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tardoc.model;

import ch.elexis.base.ch.arzttarife.tardoc.ITardocKumulation;
import ch.elexis.base.ch.arzttarife.tardoc.ITardocLeistung;
import ch.elexis.base.ch.arzttarife.tardoc.TardocKumulationArt;
import ch.elexis.base.ch.arzttarife.tardoc.model.TardocGroup;
import ch.elexis.base.ch.arzttarife.tardoc.model.TardocLeistung;
import java.time.LocalDate;
import java.util.List;

public class TardocExclusion {
    private String slaveCode;
    private TardocKumulationArt slaveType;
    private boolean validSide;

    public TardocExclusion(ITardocKumulation kumulation) {
        this.slaveCode = kumulation.getSlaveCode();
        this.slaveType = kumulation.getSlaveArt();
        this.validSide = "1".equals(kumulation.getValidSide());
    }

    public boolean isMatching(TardocLeistung tarmedLeistung, LocalDate date) {
        if (this.slaveType == TardocKumulationArt.CHAPTER) {
            return this.isMatchingChapter(tarmedLeistung);
        }
        if (this.slaveType == TardocKumulationArt.SERVICE) {
            return this.isMatchingService(tarmedLeistung);
        }
        if (this.slaveType == TardocKumulationArt.GROUP) {
            List<String> groups = tarmedLeistung.getServiceGroups(date);
            return groups.contains(this.slaveCode);
        }
        return false;
    }

    private boolean isMatchingService(ITardocLeistung tarmedLeistung) {
        return this.slaveCode.equals(tarmedLeistung.getCode());
    }

    private boolean isMatchingChapter(ITardocLeistung tarmedLeistung) {
        if (this.slaveCode.equals(tarmedLeistung.getCode())) {
            return true;
        }
        ITardocLeistung parent = tarmedLeistung.getParent();
        if (parent != null) {
            return this.isMatchingChapter(parent);
        }
        return false;
    }

    public boolean isMatching(TardocGroup tarmedGroup) {
        if (this.slaveType != TardocKumulationArt.GROUP) {
            return false;
        }
        return this.slaveCode.equals(tarmedGroup.getCode());
    }

    public boolean isValidSide() {
        return this.validSide;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TardocKumulationArt.toString(this.slaveType)).append(" ").append(this.slaveCode);
        return sb.toString();
    }
}

