/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.model.service;

import ch.elexis.base.ch.arzttarife.model.service.ArzttarifeModelAdapterFactory;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedLeistung;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.IStoreToStringContribution;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class TarmedLeistungCodeElementService
implements ICodeElementServiceContribution,
IStoreToStringContribution {
    @Reference(target="(id=default)")
    private IElexisEntityManager entityManager;

    public String getSystem() {
        return "Tarmed";
    }

    public ICodeElementService.CodeElementTyp getTyp() {
        return ICodeElementService.CodeElementTyp.SERVICE;
    }

    public Optional<ICodeElement> loadFromCode(String code, Map<Object, Object> context) {
        return Optional.ofNullable(TarmedLeistung.getFromCode(code, this.getDate(context), this.getLaw(context)));
    }

    private LocalDate getDate(Map<Object, Object> context) {
        Object date = context.get(ICodeElementService.ContextKeys.DATE);
        if (date instanceof LocalDate) {
            return (LocalDate)date;
        }
        IEncounter encounter = (IEncounter)context.get(ICodeElementService.ContextKeys.CONSULTATION);
        if (encounter != null) {
            return encounter.getDate();
        }
        return LocalDate.now();
    }

    private String getLaw(Map<Object, Object> context) {
        Object law = context.get(ICodeElementService.ContextKeys.LAW);
        if (law instanceof String) {
            return (String)law;
        }
        Object coverage = context.get(ICodeElementService.ContextKeys.COVERAGE);
        if (coverage instanceof ICoverage) {
            return ((ICoverage)coverage).getBillingSystem().getLaw().name();
        }
        Object consultation = context.get(ICodeElementService.ContextKeys.CONSULTATION);
        if (consultation instanceof IEncounter && ((IEncounter)consultation).getCoverage() != null) {
            return ((IEncounter)consultation).getCoverage().getBillingSystem().getLaw().name();
        }
        return null;
    }

    public List<ICodeElement> getElements(Map<Object, Object> context) {
        return null;
    }

    public Optional<String> storeToString(Identifiable identifiable) {
        if (identifiable instanceof TarmedLeistung) {
            return Optional.of("ch.elexis.data.TarmedLeistung::" + identifiable.getId());
        }
        return Optional.empty();
    }

    public Optional<Identifiable> loadFromString(String storeToString) {
        if (storeToString.startsWith("ch.elexis.data.TarmedLeistung::")) {
            String[] split = this.splitIntoTypeAndId(storeToString);
            String id = split[1];
            EntityManager em = (EntityManager)this.entityManager.getEntityManager();
            EntityWithId dbObject = (EntityWithId)em.find(ch.elexis.core.jpa.entities.TarmedLeistung.class, (Object)id);
            return Optional.ofNullable(ArzttarifeModelAdapterFactory.getInstance().getModelAdapter(dbObject, null, false).orElse(null));
        }
        return Optional.empty();
    }

    public List<Identifiable> loadFromStringWithIdPart(String partialStoreToString) {
        if (!partialStoreToString.startsWith("ch.elexis.data.TarmedLeistung::")) {
            return Collections.emptyList();
        }
        String[] split = this.splitIntoTypeAndId(partialStoreToString);
        if (split != null && split.length == 2) {
            String id = split[1];
            Class<ch.elexis.core.jpa.entities.TarmedLeistung> clazz = ch.elexis.core.jpa.entities.TarmedLeistung.class;
            EntityManager em = (EntityManager)this.entityManager.getEntityManager();
            TypedQuery query = em.createQuery("SELECT entity FROM " + clazz.getSimpleName() + " entity WHERE entity.id LIKE :idpart", clazz);
            query.setParameter("idpart", (Object)(id + "%"));
            List found = query.getResultList();
            if (!found.isEmpty()) {
                ArzttarifeModelAdapterFactory adapterFactory = ArzttarifeModelAdapterFactory.getInstance();
                return found.parallelStream().map(e -> adapterFactory.getModelAdapter((EntityWithId)e, null, false).orElse(null)).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public Class<?> getEntityForType(String type) {
        if ("ch.elexis.data.TarmedLeistung".equals(type)) {
            return ch.elexis.core.jpa.entities.TarmedLeistung.class;
        }
        return null;
    }

    public String getTypeForEntity(Object entityInstance) {
        if (entityInstance instanceof ch.elexis.core.jpa.entities.TarmedLeistung) {
            return "ch.elexis.data.TarmedLeistung";
        }
        return null;
    }

    public String getTypeForModel(Class<?> interfaze) {
        Class entityClass = ArzttarifeModelAdapterFactory.getInstance().getEntityClass(interfaze);
        if (entityClass != null) {
            try {
                return this.getTypeForEntity(entityClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error getting type for model [" + String.valueOf(interfaze) + "]", (Throwable)e);
            }
        }
        return null;
    }
}

