/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.befunde.findings.migrator.strategy;

import ch.elexis.base.befunde.findings.migrator.messwert.MesswertFieldMapping;
import ch.elexis.base.befunde.findings.migrator.strategy.AbstractMigrationStrategy;
import ch.elexis.base.befunde.findings.migrator.strategy.IMigrationStrategy;
import ch.elexis.befunde.Messwert;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.templates.model.InputDataNumeric;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumericMigration
extends AbstractMigrationStrategy
implements IMigrationStrategy {
    private static Logger logger = LoggerFactory.getLogger(NumericMigration.class);
    private MesswertFieldMapping mapping;
    private Messwert messwert;

    public NumericMigration(MesswertFieldMapping mapping, Messwert messwert) {
        this.mapping = mapping;
        this.messwert = messwert;
    }

    @Override
    public Optional<IObservation> migrate() {
        try {
            IObservation observation = (IObservation)this.templateService.createFinding((IPatient)CoreModelServiceHolder.get().load(this.messwert.get("PatientID"), IPatient.class).get(), this.template);
            String result = this.messwert.getResult(this.mapping.getLocalBefundField());
            observation.setNumericValue(NumericMigration.getValue(result), ((InputDataNumeric)this.template.getInputData()).getUnit());
            String comment = NumericMigration.getComment(result);
            if (comment != null && !comment.isEmpty()) {
                observation.setComment(comment);
            }
            return Optional.of(observation);
        }
        catch (ElexisException e) {
            logger.error("Error creating observation", (Throwable)e);
            return Optional.empty();
        }
    }

    public static BigDecimal getValue(String result) {
        StringBuilder sb = new StringBuilder();
        char[] cArray = result.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isDigit(c) && c != '.' && c != ',') break;
            sb.append(c);
            ++n2;
        }
        if (sb.length() > 0) {
            Object value = sb.toString().replaceAll(",", ".");
            if (((String)value).startsWith(".")) {
                value = "0" + (String)value;
            }
            if (((String)value).endsWith(".")) {
                value = (String)value + "0";
            }
            try {
                return new BigDecimal((String)value);
            }
            catch (NumberFormatException ne) {
                logger.error("Could not parse numeric result [" + result + "] value [" + (String)value + "]");
            }
        }
        return null;
    }

    public static String getComment(String result) {
        StringBuilder sb = new StringBuilder();
        char[] charArray = result.toCharArray();
        int i = charArray.length - 1;
        while (i > -1) {
            char c = charArray[i];
            if (Character.isDigit(c)) break;
            sb.append(c);
            --i;
        }
        if (sb.length() > 0) {
            sb = sb.reverse();
            return sb.toString();
        }
        return null;
    }

    public static List<BigDecimal> getValues(String result) {
        String[] spacesSplits;
        ArrayList<BigDecimal> ret = new ArrayList<BigDecimal>();
        ArrayList<String> parts = new ArrayList<String>();
        String[] stringArray = spacesSplits = result.split(" ");
        int n = spacesSplits.length;
        int n2 = 0;
        while (n2 < n) {
            String[] slashSplits;
            String spacesSplit = stringArray[n2];
            String[] stringArray2 = slashSplits = spacesSplit.split("\\/");
            int n3 = slashSplits.length;
            int n4 = 0;
            while (n4 < n3) {
                String slashSplit = stringArray2[n4];
                parts.add(slashSplit);
                ++n4;
            }
            ++n2;
        }
        for (String string : parts) {
            BigDecimal value = NumericMigration.getValue(string);
            if (value == null) continue;
            ret.add(value);
        }
        return ret;
    }
}

