/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.befunde;

import ch.elexis.base.befunde.Messages;
import ch.elexis.befunde.Messwert;
import ch.elexis.core.data.interfaces.IDataAccess;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataAccessor
implements IDataAccess {
    private static final String FIRST = "first";
    private static final String LAST = "last";
    private static final String ALL = "all";
    private static final String PREFIX_DATE = "[Befunde-Data:Patient:-:";
    private static final String PREFIX_FIRST = "[Befunde-Data:Patient:first:";
    private static final String PREFIX_LAST = "[Befunde-Data:Patient:last:";
    private static final String PREFIX_ALL = "[Befunde-Data:Patient:all:";
    private static final String SUFFIX = "]";
    Map<String, String> hash;
    Hashtable<String, String[]> columns;
    ArrayList<String> parameters;
    private TimeTool today;

    public DataAccessor() {
        Messwert setup = Messwert.getSetup();
        this.columns = new Hashtable();
        this.parameters = new ArrayList();
        this.hash = setup.getMap("Befunde");
        String names = this.hash.get("names");
        if (!StringTool.isNothing((Object)names)) {
            String[] stringArray = names.split(";;");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                Object vals = this.hash.get(n3 + "_FIELDS");
                if (vals != null) {
                    vals = "Datum;;" + (String)vals;
                    String[] flds = ((String)vals).split(";;");
                    this.parameters.add(n3);
                    this.columns.put(n3, flds);
                }
                ++n2;
            }
        }
        this.today = new TimeTool();
    }

    public String getDescription() {
        return Messages.DataAccessor_dataInBefundePlugin;
    }

    public String getName() {
        return Messages.DataAccessor_data;
    }

    public List<IDataAccess.Element> getList() {
        ArrayList<IDataAccess.Element> ret = new ArrayList<IDataAccess.Element>(this.parameters.size());
        for (String n : this.parameters) {
            String placeholder = PREFIX_DATE + n + ":" + this.today.toString(9) + SUFFIX;
            String readableName = n + " - " + Messages.DataAccessor_date;
            ret.add(this.createElement(readableName, placeholder));
            placeholder = PREFIX_FIRST + n + SUFFIX;
            readableName = n + " - " + Messages.DataAccessor_first;
            ret.add(this.createElement(readableName, placeholder));
            placeholder = PREFIX_LAST + n + SUFFIX;
            readableName = n + " - " + Messages.DataAccessor_last;
            ret.add(this.createElement(readableName, placeholder));
            placeholder = PREFIX_ALL + n + SUFFIX;
            readableName = n + " - " + Messages.DataAccessor_all;
            ret.add(this.createElement(readableName, placeholder));
        }
        return ret;
    }

    private IDataAccess.Element createElement(String readableName, String placeholder) {
        return new IDataAccess.Element(IDataAccess.TYPE.STRING, readableName, placeholder, Patient.class, 1);
    }

    public Result<Object> getObject(String descriptor, PersistentObject dependentObject, String dates, String[] params) {
        Result ret = null;
        if (!(dependentObject instanceof Patient)) {
            ret = new Result(Result.SEVERITY.ERROR, 1, Messages.DataAccessor_invalidParameter, (Object)dependentObject, true);
        } else {
            Patient pat = (Patient)dependentObject;
            String[] data = descriptor.split("\\.");
            Query qbe = new Query(Messwert.class);
            qbe.add("PatientID", "=", pat.getId());
            qbe.add("Name", "=", data[0]);
            List list = qbe.execute();
            String[] cols = this.columns.get(data[0]);
            if (cols != null) {
                String[] keys = new String[cols.length];
                String[][] values = dates.equals(ALL) ? new String[list.size() + 1][cols.length] : new String[2][cols.length];
                int i = 0;
                while (i < cols.length) {
                    keys[i] = cols[i].split(":/:")[0];
                    values[0][i] = keys[i].split("=")[0];
                    ++i;
                }
                i = 1;
                Messwert mwrt = null;
                if (dates.equals(ALL)) {
                    for (Messwert m : list) {
                        Iterator date = m.get("Datum");
                        values[i][0] = new TimeTool(date).toString(4);
                        Map befs = m.getMap(Messages.DataAccessor_0);
                        int j = 1;
                        while (j < cols.length) {
                            String vv;
                            values[i][j] = vv = (String)befs.get(keys[j]);
                            if (values[i][j] == null) {
                                values[i][j] = "";
                            }
                            ++j;
                        }
                        if (++i > values.length) break;
                    }
                    ret = new Result((Object)values);
                } else if (dates.equals(LAST)) {
                    TimeTool today = new TimeTool("19700101");
                    for (Messwert m : list) {
                        vgl = new TimeTool(m.get("Datum"));
                        if (!vgl.isAfter(today)) continue;
                        today = vgl;
                        mwrt = m;
                    }
                    if (mwrt == null) {
                        ret = new Result(Result.SEVERITY.ERROR, 2, Messages.DataAccessor_notFound, (Object)params, true);
                    }
                } else if (dates.equals(FIRST)) {
                    TimeTool firstdate = null;
                    if (list.size() > 0) {
                        mwrt = (Messwert)((Object)list.get(0));
                        firstdate = new TimeTool(mwrt.get("Datum"));
                        for (Messwert m : list) {
                            vgl = new TimeTool(m.get("Datum"));
                            if (!vgl.isBefore(firstdate)) continue;
                            mwrt = m;
                            firstdate = vgl;
                            break;
                        }
                    }
                    if (mwrt == null) {
                        ret = new Result(Result.SEVERITY.ERROR, 2, Messages.DataAccessor_notFound, (Object)params, true);
                    }
                } else {
                    TimeTool find = new TimeTool();
                    if (!find.set(params[0])) {
                        ret = new Result(Result.SEVERITY.ERROR, 1, Messages.DataAccessor_dateExpected, (Object)params, true);
                    } else {
                        for (Messwert m : list) {
                            vgl = new TimeTool(m.get("Datum"));
                            if (!vgl.isEqual(find)) continue;
                            mwrt = m;
                            break;
                        }
                        if (mwrt == null) {
                            ret = new Result(Result.SEVERITY.ERROR, 2, descriptor + " [" + find.toString(4) + "] " + Messages.DataAccessor_notFound, (Object)params, true);
                        }
                    }
                }
                if (mwrt != null) {
                    values[1][0] = mwrt.get("Datum");
                    Map befs = mwrt.getMap("Befunde");
                    int j = 1;
                    while (j < keys.length) {
                        values[1][j] = (String)befs.get(keys[j]);
                        ++j;
                    }
                    if (data.length > 1) {
                        String fname = data[1];
                        String num = fname.substring(1);
                        if (fname.matches("F[0-9]*")) {
                            int index = Integer.parseInt(num);
                            ret = index < values[1].length ? new Result((Object)values[1][index]) : new Result(Result.SEVERITY.ERROR, 1, Messages.DataAccessor_invalidFieldIndex, (Object)fname, true);
                        } else {
                            int j2 = 0;
                            while (j2 < keys.length && ret == null) {
                                if (values[0][j2].compareTo(fname) == 0) {
                                    ret = new Result((Object)values[1][j2]);
                                }
                                ++j2;
                            }
                            if (ret == null) {
                                ret = new Result(Result.SEVERITY.ERROR, 1, Messages.DataAccessor_invalidFieldName, (Object)fname, true);
                            }
                        }
                    } else {
                        ret = new Result((Object)values);
                    }
                }
            } else {
                ret = new Result((Object)"");
            }
        }
        return ret;
    }
}

