/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.befunde.findings.migrator.preferences;

import ch.elexis.base.befunde.findings.migrator.preferences.MesswertUtil;

public class MesswertFieldMapping {
    private String localMesswert;
    private String localMesswertField;
    private String findingsCode;
    private static final String MAPPING_FIELD_SEPARATOR = "||";
    private static final String MAPPING_FIELD_SEPARATOR_ESCAPED = "\\|\\|";
    private static final String MAPPING_SEPARATOR = "<->";
    private static final String MAPPING_TYPE = "_MESSWERTFIELDMAPPING_";

    public static MesswertFieldMapping createFromString(String string) {
        String[] mappings;
        MesswertFieldMapping mapping = new MesswertFieldMapping();
        if (string.startsWith(MAPPING_TYPE) && (mappings = (string = string.substring(MAPPING_TYPE.length(), string.length())).split(MAPPING_SEPARATOR)).length == 2) {
            String[] localMapping = mappings[0].split(MAPPING_FIELD_SEPARATOR_ESCAPED);
            if (localMapping.length == 2) {
                mapping.localMesswert = localMapping[0];
                mapping.localMesswertField = localMapping[1];
            }
            mapping.findingsCode = mappings[1];
        }
        return mapping.isValidMapping() ? mapping : null;
    }

    private MesswertFieldMapping() {
    }

    public MesswertFieldMapping(String localBefund, String localBefundField) {
        this(localBefund, localBefundField, null);
    }

    public MesswertFieldMapping(String localBefund, String localBefundField, String findingsCode) {
        this.localMesswert = localBefund;
        this.localMesswertField = localBefundField;
        this.findingsCode = findingsCode;
    }

    public boolean isLocalMatching(String befund, String field) {
        if (this.localMesswert != null && this.localMesswertField != null) {
            return this.localMesswert.equals(befund) && this.localMesswertField.equals(field);
        }
        return false;
    }

    public boolean isFindingsCodeMatching(String findingsCode) {
        if (this.findingsCode != null && findingsCode != null) {
            return this.findingsCode.equals(findingsCode);
        }
        return false;
    }

    public boolean isValidMapping() {
        boolean fieldsOk;
        boolean bl = fieldsOk = this.localMesswert != null && this.localMesswertField != null && this.findingsCode != null;
        if (fieldsOk) {
            return MesswertUtil.isExistingMesswert(this.localMesswert);
        }
        return false;
    }

    public String exportToString() {
        StringBuilder sb = new StringBuilder();
        if (this.isValidMapping()) {
            sb.append(MAPPING_TYPE).append(this.localMesswert).append(MAPPING_FIELD_SEPARATOR).append(this.localMesswertField);
            sb.append(MAPPING_SEPARATOR).append(this.findingsCode);
        }
        return sb.toString();
    }

    public String getLocalFieldLabel() {
        if (this.localMesswert != null && this.localMesswertField != null) {
            return this.localMesswert + "." + this.localMesswertField;
        }
        return "?";
    }

    public String getLocalBefund() {
        return this.localMesswert;
    }

    public String getLocalBefundField() {
        return this.localMesswertField;
    }

    public String getFindingsCodeLabel() {
        if (this.findingsCode != null) {
            return this.findingsCode;
        }
        return "";
    }

    public String getFindingsCode() {
        return this.findingsCode;
    }

    public void setFindigsCode(String findingsCode) {
        this.findingsCode = findingsCode;
    }
}

