/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.befunde.findings.migrator.preferences;

import ch.elexis.base.befunde.findings.migrator.preferences.MesswertFieldMapping;
import ch.elexis.befunde.Messwert;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MesswertUtil {
    private static final String MAPPING_CONFIG = "ch.elexis.core.findins/messwert/mapping";

    private static Messwert getSetup() {
        Messwert setup = Messwert.load("__SETUP__");
        if (setup.exists()) {
            return setup;
        }
        return null;
    }

    public static List<String> getSetupBefunde() {
        Messwert setup = MesswertUtil.getSetup();
        List<String> ret = Collections.emptyList();
        Map fields = setup.getMap("Befunde");
        String names = (String)fields.get("names");
        if (!StringTool.isNothing((Object)names)) {
            ret = Arrays.asList(names.split(";;"));
        }
        return ret;
    }

    public static List<String> getSetupBefundFields(String befund) {
        Messwert setup = MesswertUtil.getSetup();
        ArrayList<String> ret = new ArrayList<String>();
        Map befunde = setup.getMap("Befunde");
        String befundFields = (String)befunde.get(befund + "_FIELDS");
        if (befundFields != null) {
            String[] fields;
            String[] stringArray = fields = befundFields.split(";;");
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                String[] fieldParts = field.split(":/:");
                if (fieldParts.length > 0) {
                    ret.add(fieldParts[0]);
                }
                ++n2;
            }
        }
        return ret;
    }

    public static List<MesswertFieldMapping> getMappings() {
        ArrayList<MesswertFieldMapping> ret = new ArrayList<MesswertFieldMapping>();
        if (ContextServiceHolder.get().getActiveMandator().isPresent()) {
            String[] mappings;
            String mapping = ConfigServiceHolder.getMandator((String)MAPPING_CONFIG, (String)"");
            String[] stringArray = mappings = mapping.split(";;");
            int n = mappings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                MesswertFieldMapping createdMapping = MesswertFieldMapping.createFromString(string);
                if (createdMapping != null) {
                    ret.add(createdMapping);
                }
                ++n2;
            }
        } else {
            throw new IllegalStateException("No mandant config available");
        }
        return ret;
    }

    public static List<MesswertFieldMapping> getLocalMappings() {
        ArrayList<MesswertFieldMapping> ret = new ArrayList<MesswertFieldMapping>();
        List<MesswertFieldMapping> existingMappings = MesswertUtil.getMappings();
        ret.addAll(existingMappings);
        ArrayList<MesswertFieldMapping> localMappings = new ArrayList<MesswertFieldMapping>();
        List<String> localBefunde = MesswertUtil.getSetupBefunde();
        for (String localBefund : localBefunde) {
            List<String> localBefundeFields = MesswertUtil.getSetupBefundFields(localBefund);
            for (String localBefundField : localBefundeFields) {
                boolean found = false;
                for (MesswertFieldMapping mapping : existingMappings) {
                    if (!mapping.isLocalMatching(localBefund, localBefundField)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                localMappings.add(new MesswertFieldMapping(localBefund, localBefundField));
            }
        }
        ret.addAll(localMappings);
        return ret;
    }

    public static void saveMappings(List<MesswertFieldMapping> mappings) {
        StringBuilder sb;
        if (ContextServiceHolder.get().getActiveMandator().isPresent()) {
            sb = new StringBuilder();
            for (MesswertFieldMapping befundFieldMapping : mappings) {
                if (sb.length() > 0) {
                    sb.append(";;");
                }
                sb.append(befundFieldMapping.exportToString());
            }
        } else {
            throw new IllegalStateException("No mandant config available");
        }
        ConfigServiceHolder.setMandator((String)MAPPING_CONFIG, (String)sb.toString());
    }

    public static boolean isExistingMesswert(String name) {
        Messwert setup = MesswertUtil.getSetup();
        Map setupMap = setup.getMap("Befunde");
        String names = (String)setupMap.get("names");
        if (names != null) {
            String[] namesParts;
            String[] stringArray = namesParts = names.split(";;");
            int n = namesParts.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.equals(name)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

