/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.archie.wzw;

import ch.elexis.archie.wzw.BaseStats;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AlleLeistungenRoh
extends BaseStats {
    static final String NAME = "Alle Leistungen roh";
    static final String DESC = "Listet s\u00e4mtliche Leistungen im gegebenen Zeitraum";
    static final String[] HEADINGS = new String[]{"Mandant", "Patient-ID", "Patient-Name", "Patient Geschlecht", "Patient Alter", "Datum", "Gesetz", "Codesystem", "Code", "Text", "Anzahl", "Umsatz"};

    public AlleLeistungenRoh() {
        super(NAME, DESC, HEADINGS);
    }

    protected IStatus createContent(IProgressMonitor monitor) {
        ArrayList<String[]> lines = new ArrayList<String[]>(10000);
        List<IEncounter> conses = this.getConses(monitor);
        if (!conses.isEmpty()) {
            int clicksPerRound = this.HUGE_NUMBER / conses.size();
            for (IEncounter k : conses) {
                ICoverage fall;
                if (!k.isDeleted() && (fall = k.getCoverage()) != null) {
                    IPatient pat = fall.getPatient();
                    IMandator m = k.getMandator();
                    String md = m == null ? "?" : m.getLabel();
                    String g = fall.getBillingSystem().getName();
                    if (pat != null) {
                        for (IBilled v : k.getBilled()) {
                            IBillable vv = v.getBillable();
                            if (vv != null) {
                                String[] line = new String[]{md, pat.getPatientNr(), pat.getLabel(), pat.getGender().toString(), Integer.toString(pat.getAgeInYears()), k.getDate().toString(), g == null ? "?" : g, vv.getCodeSystemName(), vv.getCode() == null ? "?" : vv.getCode(), vv.getText(), Double.toString(v.getAmount()), Double.toString(v.getTotal().getAmount())};
                                lines.add(line);
                                continue;
                            }
                            System.out.println(v.getLabel());
                        }
                    }
                }
                monitor.worked(clicksPerRound);
                if (!monitor.isCanceled()) continue;
                return Status.CANCEL_STATUS;
            }
        }
        this.dataSet.setContent(lines);
        return Status.OK_STATUS;
    }
}

