/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.archie.patientstatistik;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.TimeTool;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EStructuralFeature;

public class Counter
extends Job {
    private static final int tasksum = 1000000;
    private int perCase = 1000000;
    private int perKons = 1;
    private HashMap<IBillable, List<IBilled>> result;
    private Patient p;
    private TimeTool von;
    private TimeTool bis;

    public HashMap<IBillable, List<IBilled>> getValues() {
        return this.result;
    }

    public Counter(Patient p, TimeTool von, TimeTool bis, final IJobFinishedListener lis) {
        super("Verrechnungsz\u00e4hler");
        this.setUser(true);
        this.setSystem(false);
        this.setPriority(30);
        this.p = p;
        this.von = von;
        this.bis = bis;
        if (lis != null) {
            this.addJobChangeListener(new IJobChangeListener(){

                public void sleeping(IJobChangeEvent event) {
                }

                public void scheduled(IJobChangeEvent event) {
                }

                public void running(IJobChangeEvent event) {
                }

                public void done(IJobChangeEvent event) {
                    UiDesk.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            lis.jobFinished(Counter.this);
                        }
                    });
                }

                public void awake(IJobChangeEvent event) {
                }

                public void aboutToRun(IJobChangeEvent event) {
                }
            });
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Z\u00e4hle Verrechnungen", 1000000);
        this.result = new HashMap();
        IPatient patient = (IPatient)NoPoUtil.loadAsIdentifiable((PersistentObject)this.p, IPatient.class).get();
        List coverages = patient.getCoverages();
        if (!coverages.isEmpty()) {
            this.perCase = 1000000 / coverages.size();
            IQuery query = CoreModelServiceHolder.get().getQuery(IEncounter.class);
            query.startGroup();
            for (ICoverage coverage : coverages) {
                query.or((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__COVERAGE, IQuery.COMPARATOR.EQUALS, (Object)coverage);
            }
            query.andJoinGroups();
            if (this.von != null) {
                query.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__DATE, IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)this.von.toLocalDate());
            }
            if (this.bis != null) {
                query.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__DATE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)this.bis.toLocalDate());
            }
            List kk = query.execute();
            this.perKons = this.perCase / kk.size();
            for (IEncounter encounter : kk) {
                for (IBilled v : encounter.getBilled()) {
                    IBillable iv = v.getBillable();
                    List<IBilled> liv = this.result.get(iv);
                    if (liv == null) {
                        liv = new LinkedList<IBilled>();
                        this.result.put(iv, liv);
                    }
                    liv.add(v);
                }
                monitor.worked(this.perKons);
                if (!monitor.isCanceled()) continue;
                return Status.CANCEL_STATUS;
            }
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public static interface IJobFinishedListener {
        public void jobFinished(Counter var1);
    }
}

