/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.dialogs;

import ch.elexis.agenda.Messages;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.data.UiMandant;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.data.Mandant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FarbenSelektor
extends TitleAreaDialog {
    private List<String> areas;
    private Map<String, Color> areaColors;
    private Map<String, Color> tempAreaColors;
    private ConfigServicePreferenceStore prefs = new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL);
    private Map<String, Boolean> useMandatorColors;
    private Map<String, Label> areaToColorLabelMap = new HashMap<String, Label>();

    public FarbenSelektor(Shell parentShell) {
        super(parentShell);
        this.useMandatorColors = new HashMap<String, Boolean>();
        this.areaColors = new HashMap<String, Color>();
        this.loadCheckboxPreferences();
        this.tempAreaColors = new HashMap<String, Color>();
        this.areas = new ArrayList<String>(ConfigServiceHolder.get().getAsList("agenda/bereiche"));
        this.loadColorPreferences();
        this.checkAreaTypes();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.AgendaFarben_Titel);
        this.setMessage(Messages.AgendaFarben_Bereich_Description);
        Composite groupContainer = new Composite(container, 0);
        GridLayout groupLayout = new GridLayout(2, false);
        groupContainer.setLayout((Layout)groupLayout);
        groupContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        Group groupAreas = new Group(groupContainer, 0);
        groupAreas.setText(Messages.Agenda_Bereiche_Title);
        groupAreas.setLayout((Layout)new GridLayout(1, false));
        groupAreas.setLayoutData((Object)new GridData(4, 4, true, true));
        Group groupColors = new Group(groupContainer, 0);
        groupColors.setText(Messages.AgendaFarben_Title);
        groupColors.setLayout((Layout)new GridLayout(1, false));
        groupColors.setLayoutData((Object)new GridData(4, 4, true, true));
        for (String area : this.areas) {
            this.createAreaColorSelector(groupAreas, groupColors, area);
        }
        return container;
    }

    private void createAreaColorSelector(Group groupAreas, Group groupColors, final String area) {
        boolean isCheckboxAvailable;
        Button useMandatorColorsCheckbox;
        Composite areaComposite = new Composite((Composite)groupAreas, 0);
        areaComposite.setLayout((Layout)new GridLayout(2, false));
        areaComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label areaLabel = new Label(areaComposite, 0);
        areaLabel.setText(area);
        areaLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        String type = ConfigServiceHolder.getGlobal((String)("agenda/bereich/" + area + "/type"), null);
        if (type != null) {
            useMandatorColorsCheckbox = new Button(areaComposite, 32);
            useMandatorColorsCheckbox.setText(Messages.Agenda_Mandator);
            useMandatorColorsCheckbox.setSelection(this.useMandatorColors.getOrDefault(area, false).booleanValue());
            isCheckboxAvailable = true;
        } else {
            useMandatorColorsCheckbox = null;
            isCheckboxAvailable = false;
        }
        Composite colorComposite = new Composite((Composite)groupColors, 0);
        colorComposite.setLayout((Layout)new GridLayout(2, false));
        colorComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Label colorLabel = new Label(colorComposite, 0);
        colorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        colorLabel.setBackground(this.areaColors.get(area));
        colorLabel.setData((Object)colorLabel);
        this.areaToColorLabelMap.put(area, colorLabel);
        final Label deleteImageLabel = new Label(colorComposite, 0);
        deleteImageLabel.setImage(Images.IMG_DELETE.getImage());
        GridData imageLabelGridData = new GridData(131072, 0x1000000, false, false);
        imageLabelGridData.heightHint = 16;
        deleteImageLabel.setLayoutData((Object)imageLabelGridData);
        deleteImageLabel.setEnabled(!isCheckboxAvailable || useMandatorColorsCheckbox != null && !useMandatorColorsCheckbox.getSelection());
        if (isCheckboxAvailable && useMandatorColorsCheckbox != null) {
            useMandatorColorsCheckbox.addListener(13, e -> {
                boolean isSelected = useMandatorColorsCheckbox.getSelection();
                this.useMandatorColors.put(area, isSelected);
                deleteImageLabel.setEnabled(!isSelected);
                if (isSelected) {
                    String mandatorId = this.extractMandatorId(type);
                    Color mandatorColor = this.getColorForMandator(mandatorId);
                    if (mandatorColor != null) {
                        this.areaColors.put(area, mandatorColor);
                        this.refreshColorDisplay(areaComposite, area);
                    }
                } else {
                    this.loadColorFromPreferences(area);
                    this.refreshColorDisplay(areaComposite, area);
                }
            });
        }
        deleteImageLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (deleteImageLabel.isEnabled()) {
                    FarbenSelektor.this.areaColors.put(area, null);
                    colorLabel.setBackground(null);
                    FarbenSelektor.this.saveColorPreferences();
                }
            }
        });
        colorLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (!isCheckboxAvailable || !FarbenSelektor.this.useMandatorColors.getOrDefault(area, false).booleanValue()) {
                    Label sourceLabel = (Label)e.widget;
                    ColorDialog colorDialog = new ColorDialog(FarbenSelektor.this.getShell());
                    RGB rgb = colorDialog.open();
                    if (rgb != null) {
                        Color newColor = new Color((Device)FarbenSelektor.this.getShell().getDisplay(), rgb);
                        FarbenSelektor.this.tempAreaColors.put(area, newColor);
                        FarbenSelektor.this.areaColors.put(area, newColor);
                        sourceLabel.setBackground(newColor);
                        FarbenSelektor.this.saveColorPreferences();
                    }
                }
            }
        });
    }

    private void saveColorPreferences() {
        StringBuilder sb = new StringBuilder();
        StringBuilder checkboxState = new StringBuilder();
        for (String area : this.areas) {
            Color color = this.areaColors.get(area);
            if (color != null && !color.isDisposed()) {
                RGB rgb = color.getRGB();
                sb.append(area).append(":").append(rgb.red).append(",").append(rgb.green).append(",").append(rgb.blue).append(";");
            } else {
                sb.append(area).append("::;");
            }
            Boolean useMandatorColor = this.useMandatorColors.getOrDefault(area, false);
            checkboxState.append(area).append(":").append(useMandatorColor != false ? "1" : "0").append(";");
        }
        this.prefs.setValue("agenda/bereich/farben", sb.toString());
        this.prefs.setValue("USE_MANDATOR_COLORS", checkboxState.toString());
    }

    private void loadCheckboxPreferences() {
        this.useMandatorColors.clear();
        Optional.ofNullable(this.prefs.getString("USE_MANDATOR_COLORS")).map(savedStates -> Arrays.stream(savedStates.split(";"))).orElse(Stream.empty()).map(entry -> entry.split(":")).filter(parts -> ((String[])parts).length == 2).forEach(parts -> {
            String area = parts[0];
            boolean state = "1".equals(parts[1]);
            this.useMandatorColors.put(area, state);
        });
    }

    public void create() {
        super.create();
        this.loadColorPreferences();
    }

    protected void okPressed() {
        this.tempAreaColors.entrySet().stream().filter(entry -> entry.getValue() != null && !((Color)entry.getValue()).isDisposed()).forEach(entry -> {
            Color color = this.areaColors.put((String)entry.getKey(), (Color)entry.getValue());
        });
        this.tempAreaColors.clear();
        this.saveColorPreferences();
        super.okPressed();
    }

    public boolean close() {
        return super.close();
    }

    private void checkAreaTypes() {
        this.areas.stream().map(area -> new AbstractMap.SimpleEntry<String, String>((String)area, ConfigServiceHolder.getGlobal((String)("agenda/bereich/" + area + "/type"), null))).filter(entry -> entry.getValue() != null).forEach(entry -> {
            String area = (String)entry.getKey();
            String type = (String)entry.getValue();
            String mandatorId = this.extractMandatorId(type);
            Optional.ofNullable(this.getColorForMandator(mandatorId)).filter(color -> !color.isDisposed() && this.useMandatorColors.getOrDefault(area, false) != false).ifPresent(color -> {
                Color color2 = this.areaColors.put(area, (Color)color);
            });
        });
    }

    private String extractMandatorId(String type) {
        if (type.startsWith("CONTACT/")) {
            return type.substring("CONTACT/".length());
        }
        return type;
    }

    private Color getColorForMandator(String mandatorId) {
        Optional mandator = CoreModelServiceHolder.get().load(mandatorId, IMandator.class);
        if (mandator.isPresent()) {
            return UiMandant.getColorForMandator((Mandant)Mandant.load((String)((IMandator)mandator.get()).getId()));
        }
        return null;
    }

    private void refreshColorDisplay(Composite areaComposite, String area) {
        Color newColor = this.areaColors.get(area);
        Label colorLabel = this.areaToColorLabelMap.get(area);
        if (newColor != null && !newColor.isDisposed() && colorLabel != null) {
            colorLabel.setBackground(newColor);
        }
    }

    private void loadColorFromPreferences(String area) {
        String savedColors = this.prefs.getString("agenda/bereich/farben");
        Arrays.stream(savedColors.split(";")).map(entry -> entry.split(":")).filter(parts -> ((String[])parts).length == 2 && parts[0].equals(area)).findFirst().map(parts -> this.parseColorFromString(parts[1])).ifPresent(color -> {
            Color color2 = this.areaColors.put(area, (Color)color);
        });
    }

    private void loadColorPreferences() {
        this.areaColors.clear();
        Optional.ofNullable(this.prefs.getString("agenda/bereich/farben")).map(savedColors -> Arrays.stream(savedColors.split(";"))).orElse(Stream.empty()).forEach(entry -> {
            String[] parts = entry.split(":");
            if (parts.length == 2) {
                String area = parts[0];
                Color color = this.parseColorFromString(parts[1]);
                this.areaColors.put(area, color);
            }
        });
    }

    private Color parseColorFromString(String colorString) {
        return Optional.ofNullable(colorString).filter(str -> !str.isEmpty()).map(str -> Arrays.stream(str.split(",")).mapToInt(Integer::parseInt).toArray()).filter(rgbParts -> ((int[])rgbParts).length == 3).map(rgbParts -> new Color((Device)Display.getCurrent(), new RGB(rgbParts[0], rgbParts[1], rgbParts[2]))).orElse(null);
    }
}

