/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.data;

import ch.elexis.agenda.Messages;
import ch.elexis.agenda.data.IPlannable;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IPeriod;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.holder.AppointmentHistoryServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.dialogs.MessageDialog;

public class Termin
extends PersistentObject
implements Cloneable,
Comparable<Termin>,
IPlannable,
IPeriod {
    public static final String FLD_BEREICH = "BeiWem";
    public static final String FLD_TERMINTYP = "Typ";
    public static final String FLD_PATIENT = "Wer";
    public static final String FLD_EXTENSION = "Extension";
    public static final String FLD_TERMINSTATUS = "Status";
    public static final String FLD_CREATOR = "ErstelltVon";
    public static final String FLD_GRUND = "Grund";
    public static final String FLD_DAUER = "Dauer";
    public static final String FLD_BEGINN = "Beginn";
    public static final String FLD_PRIORITY = "priority";
    public static final String FLD_CASE_TYPE = "caseType";
    public static final String FLD_INSURANCE_TYPE = "insuranceType";
    public static final String FLD_TREATMENT_REASON = "treatmentReason";
    public static final String FLD_TAG = "Tag";
    public static final String FLD_LASTEDIT = "lastedit";
    public static final String FLD_STATUSHIST = "StatusHistory";
    public static final String FLD_LINKGROUP = "linkgroup";
    public static final String TABLENAME = "AGNTERMINE";
    public static final String VERSION = "1.2.7";
    public static String[] TerminTypes;
    public static String[] TerminStatus;
    public static String[] TerminBereiche;
    private static final JdbcLink j;
    public static final Cache<String, Boolean> cachedAttributeKeys;
    public static final int LEER = 0;
    public static final int FREI = 0;
    public static final int RESERVIERT = 1;
    public static final int STANDARD = 2;
    public static final byte SW_LOCKED = 4;

    static {
        j = Termin.getConnection();
        cachedAttributeKeys = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
        Termin.addMapping((String)TABLENAME, (String[])new String[]{"BeiWem=Bereich", "Wer=PatID", FLD_TAG, FLD_BEGINN, FLD_DAUER, FLD_GRUND, "Typ=TerminTyp", "Status=TerminStatus", FLD_CREATOR, "ErstelltWann=Angelegt", FLD_LASTEDIT, "PalmID", "flags", "deleted", FLD_EXTENSION, FLD_LINKGROUP, FLD_STATUSHIST, FLD_PRIORITY});
        TimeTool.setDefaultResolution((int)60000);
        TerminTypes = CoreHub.globalCfg.getStringArray("agenda/TerminTypen");
        TerminStatus = CoreHub.globalCfg.getStringArray("agenda/TerminStatus");
        TerminBereiche = CoreHub.globalCfg.get("agenda/bereiche", Messages.TagesView_14).split(",");
        if (TerminTypes == null || TerminTypes.length < 3) {
            TerminTypes = new String[]{Messages.Termin_range_free, Messages.Termin_range_locked, Messages.Termin_normalAppointment};
        }
        if (TerminStatus == null || TerminStatus.length < 2) {
            TerminStatus = new String[]{"-", Messages.Termin_plannedAppointment};
        }
    }

    private void updateDuration(int newDuration) {
        TimeTool oldEndTime = this.getEndTime();
        this.setDurationInternal(newDuration);
        TimeTool newEndTime = this.getEndTime();
        IAppointment appointment = this.toIAppointment();
        AppointmentHistoryServiceHolder.get().logAppointmentDurationChange(appointment, oldEndTime.toLocalDateTime(), newEndTime.toLocalDateTime());
    }

    public static void init() {
        try {
            ConfigServiceHolder.setUser((String)"agenda/zeige_geloeschte_default", (String)"0");
            ConfigServiceHolder.setGlobal((String)"agenda/TerminTypen_default", (String)Messages.Termin_freeLockedNormalExtraVisit);
            ConfigServiceHolder.setGlobal((String)"agenda/TerminStatus_default", (String)Messages.Termin_plannedHereFinishedMissed);
            ConfigServiceHolder.setUser((String)("agenda/bilder/typ/" + Termin.typFrei()), (String)"icons/gruen.png");
            ConfigServiceHolder.setUser((String)("agenda/bilder/typ/" + Termin.typReserviert()), (String)"icons/einbahn.png");
            ConfigServiceHolder.setUser((String)("agenda/bilder/typ/" + Messages.Termin_normal), (String)"icons/kons.ico");
            ConfigServiceHolder.setUser((String)("agenda/bilder/typ/" + Messages.Termin_extra), (String)"icons/blaulicht.ico");
            ConfigServiceHolder.setUser((String)("agenda/bilder/typ/" + Messages.Termin_visit), (String)"icons/ambulanz.ico");
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
        }
    }

    public static void addBereich(String bereich) {
        Object nber = ConfigServiceHolder.getGlobal((String)"agenda/bereiche", (String)Messages.TagesView_14);
        nber = (String)nber + "," + bereich;
        ConfigServiceHolder.setGlobal((String)"agenda/bereiche", (String)nber);
        TerminBereiche = ((String)nber).split(",");
    }

    public static void addType(String typ) {
        String tt = StringTool.join((String[])TerminTypes, (String)",") + "," + typ;
        ConfigServiceHolder.setGlobal((String)"agenda/TerminTypen", (String)tt);
        TerminTypes = tt.split(",");
    }

    public Termin() {
    }

    public Termin(String id) {
        super(id);
    }

    public static Termin load(String id) {
        Termin ret = new Termin(id);
        return ret;
    }

    public Termin(String bereich, TimeSpan ts, String typ) {
        String tag = ts.from.toString(9);
        int von = ts.from.get(11) * 60 + ts.from.get(12);
        int dauer = ts.getSeconds() / 60;
        this.create(null);
        String stamp = Termin.createTimeStamp();
        this.set(new String[]{FLD_BEREICH, FLD_TAG, FLD_BEGINN, FLD_DAUER, FLD_TERMINTYP, FLD_TERMINSTATUS, "ErstelltWann", FLD_LASTEDIT, FLD_STATUSHIST}, new String[]{bereich, tag, Integer.toString(von), Integer.toString(dauer), typ, Termin.statusStandard(), stamp, stamp, this.statusline(Termin.statusStandard())});
    }

    public Termin(String bereich, String Tag, int von, int bis, String typ, String status) {
        this.create(null);
        String ts = Termin.createTimeStamp();
        this.set(new String[]{FLD_BEREICH, FLD_TAG, FLD_BEGINN, FLD_DAUER, FLD_TERMINTYP, FLD_TERMINSTATUS, "ErstelltWann", FLD_LASTEDIT, FLD_STATUSHIST}, new String[]{bereich, Tag, Integer.toString(von), Integer.toString(bis - von), typ, status, ts, ts, this.statusline(Termin.statusStandard())});
    }

    public Termin(String bereich, String Tag, int von, int bis, String typ, String status, String priority) {
        this(bereich, Tag, von, bis, typ, status);
        this.set(FLD_PRIORITY, priority);
    }

    public Termin(String ID, String bereich, String Tag, int von, int bis, String typ, String status) {
        this.create(ID);
        String ts = Termin.createTimeStamp();
        this.set(new String[]{FLD_BEREICH, FLD_TAG, FLD_BEGINN, FLD_DAUER, FLD_TERMINTYP, FLD_TERMINSTATUS, "ErstelltWann", FLD_LASTEDIT, FLD_STATUSHIST}, new String[]{bereich, Tag, Integer.toString(von), Integer.toString(bis - von), typ, status, ts, ts, this.statusline(Termin.statusStandard())});
    }

    public String getKey(String field) {
        String key = super.getKey(field);
        cachedAttributeKeys.put((Object)key, (Object)true);
        return key;
    }

    public void clearCachedAttributes() {
        Iterator iterator = cachedAttributeKeys.asMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry key = iterator.next();
            if (((String)key.getKey()).contains(this.getId())) {
                Termin.getDefaultConnection().getCache().remove((Object)((String)key.getKey()));
            }
            iterator.remove();
        }
    }

    public Object clone() {
        Termin ret = new Termin(this.get(FLD_BEREICH), this.get(FLD_TAG), this.getStartMinute(), this.getStartMinute() + this.getDauer(), this.getType(), this.getStatus(), this.get(FLD_PRIORITY));
        Kontakt k = this.getKontakt();
        if (k != null) {
            ret.setKontakt(this.getKontakt());
        }
        return ret;
    }

    @Override
    public boolean isRecurringDate() {
        Termin t = Termin.load(this.get(FLD_LINKGROUP));
        return t != null && t.exists();
    }

    public static String typStandard() {
        return TerminTypes[2];
    }

    public static String typFrei() {
        return TerminTypes[0];
    }

    public static String typReserviert() {
        return TerminTypes[1];
    }

    public static String statusLeer() {
        return TerminStatus[0];
    }

    public static String statusStandard() {
        return TerminStatus[1];
    }

    public static List<Termin> getLinked(Termin orig) {
        if (StringTool.isNothing((Object)orig.get(FLD_LINKGROUP))) {
            return Collections.singletonList(orig);
        }
        Query qbe = new Query(Termin.class);
        qbe.add(FLD_LINKGROUP, "=", orig.get(FLD_LINKGROUP));
        return qbe.execute();
    }

    public static String createTimeStamp() {
        return Integer.toString(TimeTool.getTimeInSeconds() / 60);
    }

    public TimeTool getModifyTime() {
        int min = Termin.checkZero((Object)this.get(FLD_LASTEDIT));
        TimeTool ret = new TimeTool(min, 60000);
        return ret;
    }

    public TimeTool getCreateTime() {
        int min = Termin.checkZero((Object)this.get("ErstelltWann"));
        return new TimeTool(min, 60000);
    }

    @Deprecated
    public void setFlag(byte flag) {
        int flags = Termin.checkZero((Object)this.get("flags"));
        this.set(new String[]{"flags", FLD_LASTEDIT}, new String[]{Integer.toString(flags |= 1 << flag), Termin.createTimeStamp()});
    }

    @Deprecated
    public void clrFlag(byte flag) {
        int flags = Termin.checkZero((Object)this.get("flags"));
        flags &= ~(1 << flag);
        this.set(new String[]{"flags", FLD_LASTEDIT}, new String[]{Integer.toString(flag), Termin.createTimeStamp()});
    }

    @Deprecated
    public boolean getFlag(byte flag) {
        int flags = Termin.checkZero((Object)this.get("flags"));
        return (flags & 1 << flag) != 0;
    }

    public boolean isLocked() {
        return this.getFlag((byte)4);
    }

    public void setLocked(boolean mode) {
        if (mode) {
            this.setFlag((byte)4);
        } else {
            this.clrFlag((byte)4);
        }
    }

    public boolean checkLock() {
        if (this.isLocked()) {
            SWTHelper.alert((String)Messages.Termin_appointment_locked, (String)Messages.Termin_appCantBeChanged);
            return true;
        }
        return false;
    }

    public boolean delete(boolean askForConfirmation) {
        boolean isLinked;
        boolean confirmed;
        boolean bl = confirmed = !askForConfirmation;
        if (this.checkLock()) {
            return false;
        }
        String linkgroup = this.get(FLD_LINKGROUP);
        boolean bl2 = isLinked = linkgroup != null && !linkgroup.isEmpty();
        if (isLinked && askForConfirmation) {
            MessageDialog msd = new MessageDialog(UiDesk.getTopShell(), Messages.Termin_deleteSeries, null, Messages.Termin_thisAppIsPartOfSerie, 3, new String[]{Messages.Termin_yes, Messages.Termin_no}, 1);
            int retval = msd.open();
            if (retval == -1) {
                return false;
            }
            boolean bl3 = confirmed = retval == 0;
        }
        if (isLinked) {
            List<Termin> linked = Termin.getLinked(this);
            if (confirmed) {
                for (Termin ae : linked) {
                    ae.set(new String[]{FLD_LASTEDIT, "deleted"}, new String[]{Termin.createTimeStamp(), "1"});
                }
            } else {
                if (this.getId().equals(linkgroup) && linked.size() > 1) {
                    int index = 0;
                    Termin moveto = linked.get(index);
                    while (moveto.getId().equals(linkgroup)) {
                        moveto = linked.get(++index);
                    }
                    moveto.set(FLD_PATIENT, this.get(FLD_PATIENT));
                    moveto.set(FLD_GRUND, this.get(FLD_GRUND));
                    moveto.set(FLD_CREATOR, this.get(FLD_CREATOR));
                    moveto.set(FLD_EXTENSION, this.get(FLD_EXTENSION));
                    for (Termin termin : linked) {
                        termin.set(FLD_LINKGROUP, moveto.getId());
                    }
                }
                this.set(new String[]{"deleted", FLD_LASTEDIT}, new String[]{"1", Termin.createTimeStamp()});
            }
        } else {
            this.set(new String[]{"deleted", FLD_LASTEDIT}, new String[]{"1", Termin.createTimeStamp()});
        }
        return true;
    }

    public boolean delete() {
        return this.delete(true);
    }

    public void setType(String Type2) {
        if (!this.checkLock()) {
            if (StringTool.isNothing((Object)Type2)) {
                return;
            }
            if (Type2.equals(Termin.typFrei())) {
                super.delete();
            } else {
                this.set(new String[]{FLD_TERMINTYP, FLD_LASTEDIT}, new String[]{Type2, Termin.createTimeStamp()});
            }
        }
    }

    private String statusline(String stat) {
        String activeUser = ((IUser)ContextServiceHolder.get().getActiveUser().get()).getLabel();
        return Termin.createTimeStamp() + ";" + stat + " [" + activeUser + "]";
    }

    public void setStatus(String stat) {
        if (StringTool.isNothing((Object)stat)) {
            return;
        }
        if (!this.checkLock()) {
            this.set(FLD_STATUSHIST, this.get(FLD_STATUSHIST) + "\n" + this.statusline(stat));
            this.set(new String[]{FLD_TERMINSTATUS, FLD_LASTEDIT}, new String[]{stat, Termin.createTimeStamp()});
        }
    }

    public String getStatusHistoryDesc() {
        return this.getStatusHistoryDesc(false);
    }

    public String getStatusHistoryDesc(boolean fullTime) {
        String[] lines;
        StringBuilder sb = new StringBuilder();
        String[] stringArray = lines = this.get(FLD_STATUSHIST).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            String[] f = l.split(";");
            if (f.length == 2) {
                TimeTool tt = new TimeTool(Termin.checkZero((Object)f[0]), 60000);
                if (fullTime) {
                    sb.append(tt.toString(0)).append(": ").append(f[1]).append("\n");
                } else {
                    sb.append(tt.toString(3)).append(": ").append(f[1]).append("\n");
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    public boolean isValid() {
        int l = Termin.checkZero((Object)this.get(FLD_DAUER));
        return l > 0;
    }

    public void setGrund(String grund) {
        if (!this.checkLock()) {
            this.set(new String[]{FLD_GRUND, FLD_LASTEDIT}, new String[]{grund, Termin.createTimeStamp()});
        }
    }

    public String getGrund() {
        return this.get(FLD_GRUND);
    }

    public void set(String bereich, String tag, int von, int bis, String typ, String status) {
        if (!this.checkLock()) {
            this.set(new String[]{FLD_BEREICH, FLD_TAG, FLD_BEGINN, FLD_DAUER, FLD_TERMINTYP, FLD_LASTEDIT}, new String[]{bereich, tag, Integer.toString(von), Integer.toString(bis - von), typ, Termin.createTimeStamp()});
            this.setStatus(status);
        }
    }

    public void set(String bereich, TimeTool wann, int dauer, String typ, String status, Patient pat, String Grund) {
        String Tag = wann.toString(9);
        int Beginn = wann.get(11) * 60 + wann.get(12);
        this.set(new String[]{FLD_BEREICH, FLD_TAG, FLD_BEGINN, FLD_DAUER, FLD_TERMINTYP, FLD_PATIENT, FLD_GRUND, FLD_LASTEDIT}, new String[]{bereich, Tag, Integer.toString(Beginn), Integer.toString(dauer), typ, status, pat.getId(), Grund, Termin.createTimeStamp()});
        this.setStatus(status);
    }

    public String getPersonalia() {
        String patid = this.get(FLD_PATIENT);
        Patient pat = Patient.load((String)patid);
        String Personalien = "";
        Personalien = pat.exists() ? pat.getPersonalia() : patid;
        if (this.get("deleted").equals("1")) {
            return Personalien + Messages.Termin_deleted;
        }
        return Personalien;
    }

    @Override
    public String getStatus() {
        return this.get(FLD_TERMINSTATUS);
    }

    public int getLastedit() {
        return this.getInt(FLD_LASTEDIT);
    }

    public void setKontakt(Kontakt pers) {
        if (!this.checkLock()) {
            this.set(new String[]{FLD_PATIENT, FLD_LASTEDIT}, new String[]{pers.getId(), Termin.createTimeStamp()});
        }
    }

    public void setText(String text) {
        if (!this.checkLock()) {
            this.set(new String[]{FLD_PATIENT, FLD_LASTEDIT}, new String[]{text, Termin.createTimeStamp()});
        }
    }

    public Kontakt getKontakt() {
        String pid = this.get(FLD_PATIENT);
        Patient pat = Patient.load((String)pid);
        if (pat.exists()) {
            return pat;
        }
        return null;
    }

    @Override
    public String getText() {
        return this.get(FLD_PATIENT);
    }

    public String getBereich() {
        return this.get(FLD_BEREICH);
    }

    public static String[] findID(String pers) {
        String[] ret = new String[]{"", "", ""};
        if (StringTool.isNothing((Object)pers)) {
            return ret;
        }
        String[] p1 = pers.split("[\\s,][\\s,]*[\\s,]*");
        if (p1.length == 1) {
            ret[0] = p1[0];
            return ret;
        }
        Object nam = "";
        String vn = null;
        String gd = null;
        int i = p1.length - 1;
        while (i >= 0) {
            p1[i] = p1[i].trim();
            if (p1[i].matches("\\d{1,2}\\.\\d{1,2}\\.\\d{2,4}")) {
                if (gd == null) {
                    gd = p1[i];
                }
            } else if (vn == null) {
                vn = p1[i];
            } else {
                nam = p1[i] + " " + (String)nam;
            }
            --i;
        }
        if (nam != null) {
            ret[0] = nam;
        }
        if (vn != null) {
            ret[1] = vn;
        }
        if (gd != null) {
            TimeTool tt = new TimeTool(gd);
            ret[2] = tt.toString(5);
        }
        ret[0] = ret[0].trim();
        ret[1] = ret[1].trim();
        ret[2] = ret[2].trim();
        return ret;
    }

    public boolean equals(Object o) {
        if (o instanceof Termin) {
            return super.isMatching((IPersistentObject)((Termin)o), 0, new String[]{FLD_TAG, FLD_BEGINN, FLD_DAUER, FLD_BEREICH});
        }
        return false;
    }

    public boolean isEqual(Termin ae) {
        return super.isMatching((IPersistentObject)ae, 0, new String[]{FLD_TAG, FLD_BEGINN, FLD_DAUER, FLD_BEREICH, FLD_TERMINTYP, FLD_TERMINSTATUS, FLD_CREATOR, FLD_PATIENT});
    }

    public TimeTool getStartTime() {
        String[] res = new String[2];
        this.get(new String[]{FLD_TAG, FLD_BEGINN}, res);
        TimeTool start = new TimeTool(res[0]);
        start.addMinutes(Termin.checkZero((Object)res[1]));
        return start;
    }

    public TimeSpan getTimeSpan() {
        String[] res = new String[3];
        this.get(new String[]{FLD_TAG, FLD_BEGINN, FLD_DAUER}, res);
        TimeTool start = new TimeTool(res[0]);
        start.addMinutes(Termin.checkZero((Object)res[1]));
        return new TimeSpan(start, Termin.checkZero((Object)res[2]));
    }

    public void setStartTime(TimeTool t) {
        if (this.checkLock()) {
            return;
        }
        String Tag = t.toString(9);
        int Beginn = t.get(11) * 60 + t.get(12);
        if (Beginn > 0) {
            this.set(new String[]{FLD_TAG, FLD_BEGINN, FLD_LASTEDIT}, new String[]{Tag, Integer.toString(Beginn), Termin.createTimeStamp()});
        }
    }

    public void setEndTime(TimeTool o) {
        if (!this.checkLock()) {
            TimeSpan ts = this.getTimeSpan();
            ts.until = o;
            this.set(new String[]{FLD_DAUER, FLD_LASTEDIT}, new String[]{Integer.toString(ts.getSeconds() / 60), Termin.createTimeStamp()});
        }
    }

    public void setBereich(String bereich) {
        if (!this.checkLock()) {
            this.set(new String[]{FLD_BEREICH, FLD_LASTEDIT}, new String[]{bereich, Termin.createTimeStamp()});
        }
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int level) {
        String[] vals = new String[4];
        this.get(new String[]{FLD_TAG, FLD_DAUER, FLD_BEGINN, FLD_BEREICH}, vals);
        TimeTool d = new TimeTool(vals[0]);
        d.addMinutes(Termin.checkZero((Object)vals[2]));
        String f = d.toString(12) + ", " + d.toString(1);
        if (level > 0) {
            d.addMinutes(Termin.checkZero((Object)vals[1]));
            f = f + "-" + d.toString(3);
        }
        if (level > 1) {
            f = f + " (" + vals[3] + ")";
        }
        return f;
    }

    public int getBeginn() {
        return this.getInt(FLD_BEGINN);
    }

    public static String intTimeToString(int t) {
        int hour = t / 60;
        int minute = t - hour * 60;
        StringBuffer ret = new StringBuffer();
        ret.append(StringTool.pad((int)1, (char)'0', (String)Integer.toString(hour), (int)2));
        ret.append(":");
        ret.append(StringTool.pad((int)1, (char)'0', (String)Integer.toString(minute), (int)2));
        return ret.toString();
    }

    public int getDauer() {
        return this.getInt(FLD_DAUER);
    }

    static int TimeInMinutes(TimeTool t) {
        return t.get(11) * 60 + t.get(12);
    }

    @Override
    public int compareTo(Termin o) {
        TimeSpan t0 = this.getTimeSpan();
        TimeSpan t1 = o.getTimeSpan();
        if (t0.from.isAfter(t1.from)) {
            return 1;
        }
        if (t0.from.isBefore(t1.from)) {
            return -1;
        }
        return 0;
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String dump() {
        StringBuffer res = new StringBuffer(200);
        String[] fields = new String[]{FLD_TAG, FLD_BEREICH, FLD_PATIENT, FLD_TERMINTYP, FLD_TERMINSTATUS};
        String[] result = new String[fields.length];
        this.get(fields, result);
        result[2] = Patient.load((String)result[2]).get("Name");
        int i = 0;
        while (i < fields.length) {
            res.append(fields[i]).append("=").append(result[i]).append(",");
            ++i;
        }
        return res.toString();
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        TimeSpan ts = this.getTimeSpan();
        sb.append(new TimeTool(this.getDay()).toString(4)).append(",");
        sb.append(ts.from.toString(3)).append("-").append(ts.until.toString(3)).append(" ").append(this.getPersonalia()).append(" (").append(this.getType()).append(",").append(this.getStatus()).append(") ");
        return sb.toString();
    }

    @Override
    public String getDay() {
        return this.get(FLD_TAG);
    }

    @Override
    public int getDurationInMinutes() {
        return this.getInt(FLD_DAUER);
    }

    @Override
    public int getStartMinute() {
        return Termin.checkZero((Object)this.get(FLD_BEGINN));
    }

    @Override
    public String getTitle() {
        return this.getPersonalia();
    }

    @Override
    public String getReason() {
        return this.getGrund();
    }

    @Override
    public String getType() {
        return this.get(FLD_TERMINTYP);
    }

    @Override
    public void setStartMinute(int min) {
        if (!this.checkLock()) {
            this.set(new String[]{FLD_BEGINN, FLD_LASTEDIT}, new String[]{Integer.toString(min), Termin.createTimeStamp()});
        }
    }

    private void setDurationInternal(int min) {
        this.set(new String[]{FLD_DAUER, FLD_LASTEDIT}, new String[]{Integer.toString(min), Termin.createTimeStamp()});
    }

    @Override
    public void setDurationInMinutes(int min) {
        if (!this.checkLock()) {
            int currentDuration = this.getDurationInMinutes();
            if (min != currentDuration) {
                this.updateDuration(min);
            } else {
                this.setDurationInternal(min);
            }
        }
    }

    public int getCacheTime() {
        return 5;
    }

    public boolean isDragOK() {
        return true;
    }

    public boolean crossesTimeFrame(int begin, int dauer) {
        int aMin = this.getBeginn();
        int aMax = this.getBeginn() + this.getDauer();
        return aMax > begin && aMin < begin + dauer;
    }

    public static boolean overlaps(String area, TimeTool time, int duration, @Nullable String idToIgnore) {
        Query tQuery = new Query(Termin.class);
        tQuery.add(FLD_BEREICH, "=", area);
        tQuery.add(FLD_TAG, "=", time.toString(9));
        List termine = tQuery.execute();
        TimeSpan tsInQuestion = new TimeSpan(time, duration);
        tsInQuestion.until.getTimeAsLong();
        for (Termin t : termine) {
            String id = t.getId();
            if (id.equals(idToIgnore) || tsInQuestion.overlap(t.getTimeSpan()) == null) continue;
            return true;
        }
        return false;
    }

    public TimeTool getEndTime() {
        String[] vals = new String[3];
        this.get(new String[]{FLD_TAG, FLD_BEGINN, FLD_DAUER}, vals);
        TimeTool ret = new TimeTool(vals[0]);
        ret.addMinutes(Termin.checkZero((Object)vals[1]));
        ret.addMinutes(Termin.checkZero((Object)vals[2]));
        return ret;
    }

    public IAppointment toIAppointment() {
        return (IAppointment)CoreModelServiceHolder.get().load(this.getId(), IAppointment.class, true).orElseThrow(() -> new IllegalStateException("Could not convert Termin [" + this.getId() + "]"));
    }

    public static class Free
    implements IPlannable {
        String day;
        int start;
        int length;

        public Free(String d, int s, int l) {
            this.day = d;
            this.start = s;
            this.length = l;
        }

        @Override
        public String getDay() {
            return this.day;
        }

        @Override
        public int getDurationInMinutes() {
            return this.length;
        }

        @Override
        public int getStartMinute() {
            return this.start;
        }

        @Override
        public String getStatus() {
            return Termin.statusLeer();
        }

        @Override
        public String getText() {
            return "";
        }

        @Override
        public String getTitle() {
            return String.format(Messages.MinutesFree, this.length);
        }

        @Override
        public String getType() {
            return Termin.typFrei();
        }

        @Override
        public void setStartMinute(int min) {
            this.start = min;
        }

        @Override
        public void setDurationInMinutes(int min) {
            this.length = min;
        }

        @Override
        public boolean isRecurringDate() {
            return false;
        }

        @Override
        public String getReason() {
            return "";
        }
    }

    public static class remark
    extends PersistentObject {
        public String bemerkung;

        static {
            remark.addMapping((String)"agnRemarks", (String[])new String[]{"remark"});
        }

        public remark(String id) {
            super(id);
            if (this.exists()) {
                this.bemerkung = this.get("remark");
            } else {
                this.create(id);
                this.bemerkung = "";
            }
        }

        public void set(String newval) {
            if (StringTool.isNothing((Object)newval)) {
                j.exec("DELETE from agnRemarks WHERE ID=" + this.getWrappedId());
            } else {
                this.set("remark", newval);
            }
            this.bemerkung = newval;
        }

        protected String getTableName() {
            return "agnRemarks";
        }

        public String getLabel() {
            return this.bemerkung;
        }
    }
}

