/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.actions;

import ch.elexis.agenda.Messages;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.util.AppointmentUtil;
import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.locks.LockRequestingRestrictedAction;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;

public class AgendaActions {
    private static LockRequestingRestrictedAction<IAppointment> delTerminAction;
    private static IAction terminStatusAction;

    public static void updateActions() {
        AgendaActions.getTerminStatusAction().setEnabled(AccessControlServiceHolder.get().evaluate(EvACE.of(IAppointment.class, (Right)Right.VIEW).and(Right.UPDATE)));
        ((RestrictedAction)AgendaActions.getDelTerminAction()).reflectRight();
    }

    public static IAction getDelTerminAction() {
        if (delTerminAction == null) {
            AgendaActions.makeActions();
        }
        return delTerminAction;
    }

    public static IAction getTerminStatusAction() {
        if (terminStatusAction == null) {
            AgendaActions.makeActions();
        }
        return terminStatusAction;
    }

    private static void makeActions() {
        delTerminAction = new LockRequestingRestrictedAction<IAppointment>((EvaluatableACE)EvACE.of(IAppointment.class, (Right)Right.DELETE), Messages.AgendaActions_deleteDate){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.AgendaActions_deleteDate);
            }

            public IAppointment getTargetedObject() {
                return ContextServiceHolder.get().getTyped(IAppointment.class).orElse(null);
            }

            public void doRun(IAppointment element) {
                if (AppointmentUtil.isLocked(element)) {
                    return;
                }
                ECommandService cmdSvc = (ECommandService)PlatformUI.getWorkbench().getService(ECommandService.class);
                EHandlerService hdlSvc = (EHandlerService)PlatformUI.getWorkbench().getService(EHandlerService.class);
                ParameterizedCommand cmd = cmdSvc.createCommand("ch.elexis.agenda.commands.delete", Collections.emptyMap());
                hdlSvc.executeHandler(cmd);
                ContextServiceHolder.get().postEvent("info/elexis/model/reload", IAppointment.class);
            }
        };
        terminStatusAction = new Action(Messages.AgendaActions_state, 4){
            Menu mine = null;
            Listener showListener = null;
            {
                this.setMenuCreator(new IMenuCreator(){

                    public void dispose() {
                        if (mine != null) {
                            this.removeShowListener();
                            mine.dispose();
                        }
                    }

                    public Menu getMenu(Control parent) {
                        mine = new Menu(parent);
                        this.fillMenu();
                        this.addShowListener();
                        return mine;
                    }

                    public Menu getMenu(Menu parent) {
                        mine = new Menu(parent);
                        this.fillMenu();
                        this.addShowListener();
                        return mine;
                    }

                    private void removeShowListener() {
                        if (mine != null && showListener != null) {
                            mine.removeListener(22, showListener);
                        }
                    }

                    private void addShowListener() {
                        if (mine != null) {
                            this.removeShowListener();
                            showListener = event -> {
                                Menu menu = (Menu)event.widget;
                                ContextServiceHolder.get().getTyped(IAppointment.class).ifPresent(appt -> {
                                    String actStatus = appt.getState();
                                    if (actStatus != null) {
                                        MenuItem[] menuItemArray = menu.getItems();
                                        int n = menuItemArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            MenuItem menuItem = menuItemArray[n2];
                                            menuItem.setSelection(StringUtils.equals((CharSequence)actStatus, (CharSequence)menuItem.getText()));
                                            ++n2;
                                        }
                                    }
                                });
                            };
                            mine.addListener(22, showListener);
                        }
                    }
                });
            }

            void fillMenu() {
                String[] stringArray = Termin.TerminStatus;
                int n = Termin.TerminStatus.length;
                int n2 = 0;
                while (n2 < n) {
                    String t = stringArray[n2];
                    MenuItem it = new MenuItem(this.mine, 32);
                    it.setText(t);
                    it.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(final SelectionEvent e) {
                            ContextServiceHolder.get().getTyped(IAppointment.class).ifPresent(appt -> AcquireLockBlockingUi.aquireAndRun((Identifiable)appt, (ILockHandler)new ILockHandler((IAppointment)appt){
                                private final /* synthetic */ IAppointment val$appt;
                                {
                                    this.val$appt = iAppointment;
                                }

                                public void lockFailed() {
                                }

                                public void lockAcquired() {
                                    MenuItem it = (MenuItem)e.getSource();
                                    this.val$appt.setState(it.getText());
                                    CoreModelServiceHolder.get().save((Identifiable)this.val$appt);
                                    ContextServiceHolder.get().postEvent("info/elexis/model/reload", IAppointment.class);
                                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)this.val$appt);
                                }
                            }));
                        }
                    });
                    ++n2;
                }
            }
        };
    }
}

