/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.dialogs;

import ch.elexis.agenda.commands.EmailSender;
import ch.elexis.agenda.composite.AppointmentDetailComposite;
import ch.elexis.agenda.composite.EmailComposite;
import ch.elexis.agenda.ui.Messages;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IImage;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.agenda.CollisionErrorLevel;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.ITextReplacementService;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.utils.CoreUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import jakarta.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Hashtable;
import java.util.function.Supplier;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class AppointmentDialog
extends Dialog {
    private IAppointment appointment;
    @Inject
    @Service(filterExpression="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Inject
    private IContextService contextService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ITextReplacementService textReplacementService;
    private AppointmentDetailComposite detailComposite;
    private EmailSender emailSender;
    private boolean expanded;
    private CollisionErrorLevel collisionErrorLevel;
    private boolean initColliding = false;
    private boolean showAllDay = false;
    private boolean scheduleChangeMode = false;

    public AppointmentDialog(IAppointment appointment) {
        super(Display.getDefault().getActiveShell());
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
        this.coreModelService.refresh((Identifiable)appointment);
        this.appointment = appointment;
        this.emailSender = new EmailSender(this.textReplacementService, this.contextService);
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeAppointmentIfNecessary();
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, true));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.detailComposite = new AppointmentDetailComposite(container, 0, this.appointment);
        this.detailComposite.setShowAllDay(this.showAllDay);
        this.detailComposite.setExpanded(this.expanded);
        this.detailComposite.setScheduleChangeMode(this.scheduleChangeMode);
        this.detailComposite.setLayoutData(new GridData(4, 4, true, true));
        if (this.collisionErrorLevel != null) {
            this.detailComposite.setCollisionErrorLevel(this.collisionErrorLevel, colliding -> {
                if (this.collisionErrorLevel == CollisionErrorLevel.ERROR) {
                    Button okButton = this.getButton(0);
                    if (okButton != null) {
                        if (colliding.booleanValue()) {
                            okButton.setEnabled(false);
                            okButton.setText(Messages.TermineLockedTimesUpdater_4);
                        } else {
                            okButton.setEnabled(true);
                            okButton.setText(IDialogConstants.OK_LABEL);
                        }
                    } else {
                        this.initColliding = colliding;
                    }
                }
            });
        }
        this.contextService.getRootContext().setNamed("sendMailDialog.taskDescriptor", null);
        return container;
    }

    protected Control createButtonBar(Composite parent) {
        Button okButton;
        Control ret = super.createButtonBar(parent);
        if (this.initColliding && (okButton = this.getButton(0)) != null) {
            okButton.setEnabled(false);
            okButton.setText(Messages.TermineLockedTimesUpdater_4);
        }
        return ret;
    }

    protected Point getInitialSize() {
        if (this.detailComposite != null && this.expanded) {
            if (CoreUtil.isLinux()) {
                return new Point(1000, 900);
            }
            return new Point(1000, 800);
        }
        if (CoreUtil.isLinux()) {
            return new Point(800, 560);
        }
        return new Point(700, 490);
    }

    protected void configureShell(final Shell newShell) {
        super.configureShell(newShell);
        if (CoreUtil.isLinux()) {
            newShell.setMinimumSize(800, 560);
        } else {
            newShell.setMinimumSize(700, 500);
        }
        newShell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = newShell.getSize();
                if (size.x >= 880 && size.y >= 750) {
                    if (!AppointmentDialog.this.expanded) {
                        AppointmentDialog.this.expanded = true;
                        AppointmentDialog.this.detailComposite.setExpanded(true);
                        newShell.layout(true, true);
                    }
                } else if (AppointmentDialog.this.expanded) {
                    AppointmentDialog.this.expanded = false;
                    AppointmentDialog.this.detailComposite.setExpanded(false);
                    newShell.layout(true, true);
                }
            }
        });
    }

    protected void okPressed() {
        if (this.appointment.isLocked() && !this.detailComposite.isChangeLocked()) {
            SWTHelper.alert((String)Messages.Termin_appointment_locked, (String)Messages.Termin_appCantBeChanged);
            this.cancelPressed();
            return;
        }
        this.saveAndReloadAppointment();
        this.sendEmailIfConfirmationChecked();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.coreModelService.refresh((Identifiable)this.appointment, false, true);
        this.contextService.getRootContext().setNamed("sendMailDialog.taskDescriptor", null);
        this.contextService.getRootContext().setNamed("mail.alreadySent", null);
        super.cancelPressed();
    }

    protected boolean isResizable() {
        return true;
    }

    public void setCollisionErrorLevel(CollisionErrorLevel level) {
        this.collisionErrorLevel = level;
    }

    private void initializeAppointmentIfNecessary() {
        if (this.appointment == null) {
            this.appointment = (IAppointment)this.coreModelService.create(IAppointment.class);
            this.appointment.setStartTime(LocalDateTime.now());
        }
    }

    private void saveAndReloadAppointment() {
        if (this.appointment != null) {
            this.coreModelService.save((Identifiable)this.detailComposite.setToModel());
        }
        this.eventBroker.post("info/elexis/model/reload", IAppointment.class);
        this.eventBroker.post("info/elexis/model/update", (Object)this.appointment);
    }

    public void setExpanded(boolean expand) {
        this.expanded = expand;
    }

    public void setScheduleChangeMode(boolean mode) {
        this.scheduleChangeMode = mode;
    }

    public void setShowAllDay(boolean showAllDay) {
        this.showAllDay = showAllDay;
    }

    private void sendEmailIfConfirmationChecked() {
        Boolean alreadySent = this.contextService.getNamed("mail.alreadySent").map(Boolean.class::cast).orElse(false);
        if (this.detailComposite.getEmailCheckboxStatus() && !alreadySent.booleanValue()) {
            this.contextService.setNamed("ch.elexis.core.mail.image.elexismailappointmentqr", (Object)new AppointmentQrSupplier(this.appointment));
            EmailComposite.EmailDetails emailDetails = this.detailComposite.getEmailDeteils();
            this.emailSender.sendEmail(emailDetails, this.appointment);
            this.contextService.setNamed("ch.elexis.core.mail.image.elexismailappointmentqr", null);
        }
        this.contextService.getRootContext().setNamed("mail.alreadySent", null);
    }

    private class AppointmentQrSupplier
    implements Supplier<IImage> {
        private IAppointment appointment;

        public AppointmentQrSupplier(IAppointment appointment) {
            this.appointment = appointment;
        }

        @Override
        public IImage get() {
            Hashtable<EncodeHintType, ErrorCorrectionLevel> hintMap = new Hashtable<EncodeHintType, ErrorCorrectionLevel>();
            hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            try {
                BitMatrix bitMatrix = qrCodeWriter.encode(this.appointment.getId(), BarcodeFormat.QR_CODE, 200, 200, hintMap);
                int width = bitMatrix.getWidth();
                int height = bitMatrix.getHeight();
                ImageData data = new ImageData(width, height, 24, new PaletteData(255, 65280, 0xFF0000));
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        data.setPixel(x, y, bitMatrix.get(x, y) ? 0 : 0xFFFFFF);
                        ++x;
                    }
                    ++y;
                }
                ImageLoader loader = new ImageLoader();
                loader.data = new ImageData[]{data};
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                loader.save((OutputStream)out, 5);
                IImage ret = (IImage)AppointmentDialog.this.coreModelService.create(IImage.class);
                ret.setTitle("elexismailappointmentqr.png");
                ret.setDate(LocalDate.now());
                ret.setImage(out.toByteArray());
                return ret;
            }
            catch (WriterException e) {
                LoggerFactory.getLogger(AppointmentDialog.class).error("Error creating QR", (Throwable)e);
                return null;
            }
        }
    }
}

