/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.views;

import ch.elexis.agenda.BereichSelectionHandler;
import ch.elexis.agenda.Messages;
import ch.elexis.agenda.data.TagesNachricht;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.agenda.views.BaseAgendaView;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IAppointmentSeries;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.model.util.ElexisIdGenerator;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.slf4j.LoggerFactory;

public class AgendaGross
extends BaseAgendaView {
    public static final String ID = "ch.elexis.agenda.largeview";
    public static final String CFG_VERTRELATION = "vertrelation";
    private static final String SEPARATOR = ",";
    private static final int[] DEFAULT_COLUMN_WIDTHS = new int[]{60, 60, 105, 80, 300, 200};
    DateTime calendar;
    Composite cButtons;
    Text dayMessage;
    Text terminDetail;
    Label lbDetails;
    Label lbDayString;
    private int[] sashWeights = null;
    private SashForm sash;
    private static Button[] bChange;
    private static final String[] columnTitles;

    static {
        columnTitles = new String[]{"von", "bis", "Typ", "Status", "Personalien", "Grund"};
    }

    public AgendaGross() {
        BereichSelectionHandler.addBereichSelectionListener(this);
    }

    @Override
    public void create(Composite parent) {
        int[] nArray;
        parent.setLayout((Layout)new GridLayout());
        this.cButtons = new Composite(parent, 2048);
        RowLayout rl = new RowLayout();
        this.cButtons.setLayout((Layout)rl);
        this.cButtons.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.sash = new SashForm(parent, 256);
        this.sash.setLayout((Layout)new GridLayout());
        this.sash.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.updateAreasButtons();
        Composite ret = new Composite((Composite)this.sash, 0);
        Composite right = new Composite((Composite)this.sash, 2048);
        ret.setLayout((Layout)new GridLayout());
        right.setLayout((Layout)new GridLayout());
        right.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tv = new TableViewer(ret, 65540);
        this.tv.getControl().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.calendar = new DateTime(right, 17408);
        this.calendar.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.calendar.setDate(this.agenda.getActDate().get(1), this.agenda.getActDate().get(2), this.agenda.getActDate().get(5));
        Button bToday = new Button(right, 8);
        bToday.setText(Messages.AgendaGross_today);
        bToday.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        bToday.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TimeTool dat = new TimeTool();
                AgendaGross.this.agenda.setActDate(dat);
                AgendaGross.this.calendar.setDate(dat.get(1), dat.get(2), dat.get(5));
                AgendaGross.this.updateDate();
            }
        });
        this.dayMessage = SWTHelper.createText((Composite)right, (int)4, (int)512);
        GridData gd = (GridData)this.dayMessage.getLayoutData();
        gd.widthHint = this.calendar.computeSize((int)-1, (int)-1).x;
        this.dayMessage.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                String tx = AgendaGross.this.dayMessage.getText();
                TagesNachricht tn = TagesNachricht.load(AgendaGross.this.agenda.getActDate());
                if (tn.exists()) {
                    tn.setLangtext(tx);
                } else {
                    tn = new TagesNachricht(AgendaGross.this.agenda.getActDate(), " - ", tx);
                }
            }
        });
        this.terminDetail = SWTHelper.createText((Composite)right, (int)5, (int)0);
        this.terminDetail.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.lbDetails = new Label(right, 64);
        this.lbDetails.setText("-");
        this.lbDetails.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.lbDayString = new Label(ret, 0);
        this.tv.setLabelProvider((IBaseLabelProvider)new AgendaLabelProvider());
        Table table = this.tv.getTable();
        int[] columnWidths = this.loadColumnWidths();
        int i = 0;
        while (i < columnTitles.length) {
            TableColumn tc = new TableColumn(table, 0);
            tc.setText(columnTitles[i]);
            tc.setWidth(columnWidths[i]);
            ++i;
        }
        table.setHeaderVisible(true);
        this.makePrivateActions();
        this.calendar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LocalDate localDate = LocalDate.of(AgendaGross.this.calendar.getYear(), AgendaGross.this.calendar.getMonth() + 1, AgendaGross.this.calendar.getDay());
                AgendaGross.this.agenda.setActDate(new TimeTool(localDate));
                ContextServiceHolder.get().postEvent("ch/elexis/agenda/DATE_CHANGED", (Object)localDate);
                AgendaGross.this.updateDate();
            }
        });
        if (this.sashWeights == null) {
            int[] nArray2 = new int[2];
            nArray2[0] = 70;
            nArray = nArray2;
            nArray2[1] = 30;
        } else {
            nArray = this.sashWeights;
        }
        this.sash.setWeights(nArray);
        this.tv.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AgendaGross.this.saveColumnSizes();
            }
        });
        this.initialize();
    }

    private void updateAreasButtons() {
        if (bChange != null && bChange.length > 0) {
            Button[] buttonArray = bChange;
            int n = bChange.length;
            int n2 = 0;
            while (n2 < n) {
                Button button = buttonArray[n2];
                if (button != null && !button.isDisposed()) {
                    button.setVisible(false);
                    button.dispose();
                }
                ++n2;
            }
        }
        String[] bereiche = AppointmentServiceHolder.get().getAoboAreas().stream().map(a -> a.getName()).collect(Collectors.toList()).toArray(new String[0]);
        ChangeBereichAdapter chb = new ChangeBereichAdapter();
        bChange = new Button[bereiche.length];
        int i = 0;
        while (i < bereiche.length) {
            AgendaGross.bChange[i] = new Button(this.cButtons, 16);
            bChange[i].setText(bereiche[i]);
            bChange[i].addSelectionListener((SelectionListener)chb);
            if (bereiche[i].equals(this.agenda.getActResource())) {
                bChange[i].setSelection(true);
            }
            ++i;
        }
        this.cButtons.layout();
    }

    protected void initialize() {
        this.setDayMessage();
    }

    protected void setDayMessage() {
        TagesNachricht tn = TagesNachricht.load(this.agenda.getActDate());
        this.lbDayString.setText("");
        this.dayMessage.setText("");
        if (tn.exists()) {
            this.lbDayString.setText(tn.getZeile());
            this.dayMessage.setText(tn.getLangtext());
        }
    }

    protected void updateDate() {
        this.setDayMessage();
        this.tv.refresh();
    }

    @Override
    protected void userChanged() {
        super.userChanged();
        this.updateAreasButtons();
    }

    private void saveColumnSizes() {
        if (ConfigServiceHolder.getUser((String)"agenda/big/savecolumnwidth", (boolean)true)) {
            TableColumn[] columns;
            StringBuilder sb = new StringBuilder();
            TableColumn[] tableColumnArray = columns = this.tv.getTable().getColumns();
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn tc = tableColumnArray[n2];
                sb.append(tc.getWidth());
                sb.append(SEPARATOR);
                ++n2;
            }
            ConfigServiceHolder.setUser((String)"agenda/big/columnwidth", (String)sb.toString());
        }
    }

    private int[] loadColumnWidths() {
        int[] colWidth = DEFAULT_COLUMN_WIDTHS;
        if (ConfigServiceHolder.getUser((String)"agenda/big/savecolumnwidth", (boolean)true)) {
            String defaultColWidths = Arrays.toString(DEFAULT_COLUMN_WIDTHS).replace("[", "").replace("]", "");
            String userColWidths = ConfigServiceHolder.getUser((String)"agenda/big/columnwidth", (String)defaultColWidths);
            String[] widthStrings = userColWidths.split(SEPARATOR);
            int i = 0;
            while (i < widthStrings.length) {
                colWidth[i] = Integer.parseInt(widthStrings[i].trim());
                ++i;
            }
        }
        return colWidth;
    }

    @Override
    public void setAppointment(IAppointment appointment) {
        IContact contact = appointment.getContact();
        StringBuilder sb = new StringBuilder(200);
        sb.append(DateTimeFormatter.ofPattern("HH:mm").format(appointment.getStartTime())).append("-").append(Plannables.isNotAllDay(appointment) ? DateTimeFormatter.ofPattern("HH:mm").format(appointment.getEndTime()) : "-").append(" ");
        if (appointment.isRecurring()) {
            Optional series = AppointmentServiceHolder.get().getAppointmentSeries(appointment);
            if (series.isPresent() && ((IAppointmentSeries)series.get()).getContact() != null && ((IAppointmentSeries)series.get()).getContact().isPerson()) {
                sb.append(PersonFormatUtil.getPersonalia((IPerson)((IAppointmentSeries)series.get()).getContact().asIPerson()));
            }
        } else if (appointment.getContact() != null && appointment.getContact().isPerson()) {
            sb.append(PersonFormatUtil.getPersonalia((IPerson)appointment.getContact().asIPerson()));
        }
        sb.append("\n(").append(appointment.getType()).append(SEPARATOR).append(appointment.getState()).append(")\n--------\n").append(appointment.getReason());
        this.terminDetail.setText(sb.toString());
        sb.setLength(0);
        sb.append(StringTool.unNull((String)appointment.getCreatedBy())).append("/").append(this.getCreateTime(appointment).toString(0));
        this.lbDetails.setText(sb.toString());
        ContextServiceHolder.get().setTyped((Object)appointment);
        if (contact != null && contact.isPatient()) {
            ContextServiceHolder.get().setActivePatient(contact.asIPatient());
        }
    }

    public TimeTool getCreateTime(IAppointment appointment) {
        int min = 0;
        try {
            min = Integer.parseInt(appointment.getCreated());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).warn("Could not parse appointment create time [" + appointment.getCreated() + "]");
        }
        return new TimeTool(min, 60000);
    }

    private void makePrivateActions() {
        this.newViewAction = new Action(Messages.AgendaGross_newWindow){

            public void run() {
                try {
                    AgendaGross.this.getViewSite().getPage().showView(AgendaGross.ID, ElexisIdGenerator.generateId(), 2);
                }
                catch (PartInitException e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        };
    }

    @Override
    public void bereichSelectionEvent(String bereich) {
        super.bereichSelectionEvent(bereich);
        Button[] buttonArray = bChange;
        int n = bChange.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            if (b != null && !b.isDisposed()) {
                if (b.getText().equalsIgnoreCase(bereich)) {
                    b.setSelection(true);
                } else {
                    b.setSelection(false);
                }
            }
            ++n2;
        }
    }

    public void saveState(IMemento memento) {
        int[] w = this.sash.getWeights();
        memento.putString(CFG_VERTRELATION, Integer.toString(w[0]) + SEPARATOR + Integer.toString(w[1]));
        super.saveState(memento);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento == null) {
            this.sashWeights = new int[]{70, 30};
        } else {
            String state = memento.getString(CFG_VERTRELATION);
            if (state == null) {
                state = "70,30";
            }
            String[] sw = state.split(SEPARATOR);
            this.sashWeights = new int[]{Integer.parseInt(sw[0]), Integer.parseInt(sw[1])};
        }
        super.init(site, memento);
    }

    private class AgendaLabelProvider
    extends LabelProvider
    implements ITableColorProvider,
    ITableLabelProvider {
        private AgendaLabelProvider() {
        }

        public Color getBackground(Object element, int columnIndex) {
            if (element instanceof IAppointment) {
                IAppointment p = (IAppointment)element;
                if (columnIndex == 3) {
                    return AgendaGross.this.getStateColor(p);
                }
                return AgendaGross.this.getTypColor(p);
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (element instanceof IAppointment) {
                IAppointment p = (IAppointment)element;
                if (columnIndex == 3) {
                    return SWTHelper.getContrast((Color)AgendaGross.this.getStateColor(p));
                }
                return SWTHelper.getContrast((Color)AgendaGross.this.getTypColor(p));
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            IAppointment ip;
            if (columnIndex != 4) {
                return null;
            }
            if (element instanceof IAppointment && (ip = (IAppointment)element).isRecurring()) {
                return UiDesk.getImage((String)"ch.elexis.agenda.series");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IAppointment) {
                IAppointment ip = (IAppointment)element;
                switch (columnIndex) {
                    case 0: {
                        return DateTimeFormatter.ofPattern("HH:mm").format(ip.getStartTime());
                    }
                    case 1: {
                        if (Plannables.isNotAllDay(ip)) {
                            return DateTimeFormatter.ofPattern("HH:mm").format(ip.getEndTime());
                        }
                        return "-";
                    }
                    case 2: {
                        return ip.getType();
                    }
                    case 3: {
                        return ip.getState();
                    }
                    case 4: {
                        return ip.isRecurring() ? ((IAppointmentSeries)AppointmentServiceHolder.get().getAppointmentSeries(ip).get()).getRootAppointment().getSubjectOrPatient() : ip.getSubjectOrPatient();
                    }
                    case 5: {
                        String[] tokens;
                        String grund = ip.getReason();
                        if (grund != null && (tokens = grund.split("[\r\n]+")).length > 0) {
                            grund = tokens[0];
                        }
                        return grund == null ? "" : grund;
                    }
                }
            }
            return "?";
        }
    }

    private class ChangeBereichAdapter
    extends SelectionAdapter {
        private ChangeBereichAdapter() {
        }

        public void widgetSelected(SelectionEvent ev) {
            Button source = (Button)ev.getSource();
            String bereich = source.getText();
            AgendaGross.this.setBereich(bereich);
            AgendaGross.this.tv.refresh();
        }
    }
}

