/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.data;

import ch.elexis.agenda.data.Termin;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.scripting.CSVWriter;
import ch.rgw.tools.ExHandler;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;

public class CSVExporter {
    public void doExport(String filename, List<Termin> termine) {
        try {
            CSVWriter csv = new CSVWriter((Writer)new FileWriter(filename));
            String[] header = new String[]{"UUID", "Bereich", "Typ", "Datum", "Startzeit", "Dauer", "Grund", "Patient-UUID-oder-Name"};
            String[] fields = new String[]{"ID", "BeiWem", "Typ", "Tag", "Beginn", "Dauer", "Grund", "Wer"};
            csv.writeNext(header);
            for (Termin t : termine) {
                String[] line = new String[fields.length];
                t.get(fields, line);
                csv.writeNext(line);
            }
            csv.close();
            SWTHelper.showInfo((String)"Termine exportiert", (String)("Der Export nach " + filename + " ist abgeschlossen"));
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            SWTHelper.showError((String)"Fehler", (String)ex.getMessage());
        }
    }
}

