/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.ui;

import ch.elexis.agenda.ui.Messages;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.agenda.CollisionErrorLevel;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.locks.LockRequestingRestrictedAction;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.dialogs.AppointmentDialog;
import ch.rgw.tools.TimeTool;
import jakarta.inject.Inject;
import java.time.format.TextStyle;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class TerminListeView
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.elexis.agenda.Terminliste";
    ScrolledForm form;
    CommonViewer cv = new CommonViewer();
    LockRequestingRestrictedAction<IAppointment> terminAendernAction;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    @Inject
    void activePatient(@org.eclipse.e4.core.di.annotations.Optional IPatient patient) {
        Display.getDefault().asyncExec(() -> this.refresh());
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    public void reload(@UIEventTopic(value="info/elexis/model/update") IAppointment appointment) {
        if (this.cv != null) {
            this.cv.notify(CommonViewer.Message.update, (Object)appointment);
        }
    }

    public TerminListeView() {
        this.terminAendernAction = new LockRequestingRestrictedAction<IAppointment>((EvaluatableACE)EvACE.of(IAppointment.class, (Right)Right.UPDATE), ch.elexis.agenda.Messages.TagesView_changeTermin){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(ch.elexis.agenda.Messages.TagesView_changeThisTermin);
            }

            public IAppointment getTargetedObject() {
                return ContextServiceHolder.get().getTyped(IAppointment.class).orElse(null);
            }

            public void doRun(final IAppointment element) {
                AcquireLockBlockingUi.aquireAndRun((Identifiable)element, (ILockHandler)new ILockHandler(){

                    public void lockFailed() {
                    }

                    public void lockAcquired() {
                        AppointmentDialog dlg = new AppointmentDialog(element);
                        dlg.setCollisionErrorLevel(CollisionErrorLevel.ERROR);
                        dlg.open();
                    }
                });
                if (TerminListeView.this.cv != null) {
                    TerminListeView.this.cv.notify(CommonViewer.Message.update);
                }
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.form = UiDesk.getToolkit().createScrolledForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        CommonViewerContentProvider contentProvider = new CommonViewerContentProvider(this.cv){
            private static final int QUERY_LIMIT = 50;

            public Object[] getElements(Object inputElement) {
                Optional actPat = ContextServiceHolder.get().getActivePatient();
                IQuery<IAppointment> query = this.getBaseQuery();
                if (!actPat.isPresent()) {
                    return new Object[0];
                }
                query.and("patId", IQuery.COMPARATOR.EQUALS, (Object)((IPatient)actPat.get()).getId());
                query.orderBy("tag", IQuery.ORDER.DESC);
                List<IAppointment> elements = query.execute().stream().filter(a -> Plannables.isNotAllDay(a)).toList();
                this.commonViewer.setLimitReached(elements.size() == 50, 50);
                return elements.toArray(new Object[elements.size()]);
            }

            protected IQuery<IAppointment> getBaseQuery() {
                IQuery ret = CoreModelServiceHolder.get().getQuery(IAppointment.class);
                if (!this.ignoreLimit) {
                    ret.limit(50);
                }
                return ret;
            }

            public void init() {
                super.init();
                this.setIgnoreLimit(false);
            }
        };
        ViewerConfigurer vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)contentProvider, new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IAppointment) {
                    IAppointment termin = (IAppointment)element;
                    StringBuilder sbLabel = new StringBuilder();
                    if (termin.getStartTime() != null) {
                        TimeTool tt = new TimeTool(termin.getStartTime());
                        sbLabel.append(tt.toString(4));
                        String dayShort = termin.getStartTime().getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.getDefault());
                        if (dayShort != null) {
                            sbLabel.append(" (" + dayShort + ")");
                        }
                        sbLabel.append(", ");
                        sbLabel.append(tt.toString(3));
                    } else {
                        sbLabel.append("?");
                    }
                    sbLabel.append(" - ");
                    if (termin.getEndTime() != null) {
                        TimeTool te = new TimeTool(termin.getEndTime());
                        sbLabel.append(te.toString(3));
                    } else {
                        sbLabel.append("?");
                    }
                    sbLabel.append(" (");
                    sbLabel.append(termin.getType());
                    sbLabel.append(", ");
                    sbLabel.append(termin.getState());
                    sbLabel.append("), ");
                    sbLabel.append(termin.getSchedule());
                    if (termin.getReason() != null && !termin.getReason().isEmpty()) {
                        sbLabel.append(" (");
                        sbLabel.append(termin.getReason());
                        sbLabel.append(")");
                    }
                    return sbLabel.toString();
                }
                return super.getText(element);
            }
        }, (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(2, 66048, this.cv));
        vc.setContentType(ViewerConfigurer.ContentType.GENERICOBJECT);
        this.cv.create(vc, body, 0, (Object)this);
        this.cv.getViewerWidget().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TerminListeView.this.terminAendernAction.run();
            }
        });
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
    }

    public void setFocus() {
    }

    private void updateSelection(IPatient patient) {
        if (patient == null) {
            this.form.setText(Messages.TerminListView_noPatientSelected);
        } else {
            this.form.setText(patient.getLabel());
            this.cv.notify(CommonViewer.Message.update);
        }
    }

    public void sort(final int sortDirection) {
        this.cv.getViewerWidget().setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IAppointment && e2 instanceof IAppointment) {
                    int rc = ((IAppointment)e1).getStartTime().compareTo(((IAppointment)e2).getStartTime());
                    if (sortDirection == 1024) {
                        rc = -rc;
                    }
                    return rc;
                }
                return super.compare(viewer, e1, e2);
            }
        });
    }

    public void refresh() {
        if (CoreUiUtil.isActiveControl((Control)this.form)) {
            this.updateSelection(ContextServiceHolder.get().getActivePatient().orElse(null));
        }
    }
}

