/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.dialogs;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IAppointmentBuilder;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.AppointmentState;
import ch.elexis.core.types.AppointmentType;
import ch.elexis.core.ui.util.SWTHelper;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TagesgrenzenDialog
extends TitleAreaDialog {
    LocalDate day;
    Text text;
    String beiwem;
    List<IAppointment> lRes;

    public TagesgrenzenDialog(Shell parent, String tag, String bereich) {
        super(parent);
        this.day = LocalDate.parse(tag, DateTimeFormatter.ofPattern("yyyyMMdd"));
        this.beiwem = bereich;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout());
        this.text = SWTHelper.createText((Composite)ret, (int)6, (int)2048);
        IQuery query = CoreModelServiceHolder.get().getQuery(IAppointment.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IAPPOINTMENT__SCHEDULE, IQuery.COMPARATOR.EQUALS, (Object)this.beiwem);
        query.and("tag", IQuery.COMPARATOR.EQUALS, (Object)this.day);
        String typReserved = AppointmentServiceHolder.get().getType(AppointmentType.BOOKED);
        query.and((EStructuralFeature)ModelPackage.Literals.IAPPOINTMENT__TYPE, IQuery.COMPARATOR.EQUALS, (Object)typReserved);
        query.orderByLeftPadded("beginn", IQuery.ORDER.ASC);
        this.lRes = query.execute();
        StringBuilder sb = new StringBuilder();
        for (IAppointment t : this.lRes) {
            sb.append(DateTimeFormatter.ofPattern("HH:mm").format(t.getStartTime())).append("-").append(t.getEndTime() != null ? DateTimeFormatter.ofPattern("HH:mm").format(t.getEndTime()) : "").append("\n");
        }
        this.text.setText(sb.toString());
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle("Tagesgrenzen");
        this.setMessage("Bitte geben Sie nicht planbare Zeitr\u00e4ume in der Form hh:mm-hh:mm jeweils in einer eigenen Zeile ein");
        this.getShell().setText("Agenda");
    }

    protected void okPressed() {
        String[] sl;
        for (IAppointment t : this.lRes) {
            CoreModelServiceHolder.get().delete((Deleteable)t);
        }
        String[] stringArray = sl = this.text.getText().split("\\s*[\\n*\\r*,]\\n?\\r?\\s*");
        int n = sl.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] lim = s.split("-");
            LocalTime startTime = LocalTime.parse(lim[0], DateTimeFormatter.ofPattern("HH:mm"));
            LocalTime endTime = LocalTime.parse(lim[1], DateTimeFormatter.ofPattern("HH:mm"));
            String typReserved = AppointmentServiceHolder.get().getType(AppointmentType.BOOKED);
            String emptyState = AppointmentServiceHolder.get().getState(AppointmentState.EMPTY);
            new IAppointmentBuilder(CoreModelServiceHolder.get(), this.beiwem, this.day.atTime(startTime), this.day.atTime(endTime), typReserved, emptyState).buildAndSave();
            ++n2;
        }
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }
}

