/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.util;

import ch.elexis.actions.Activator;
import ch.elexis.agenda.data.IPlannable;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.util.Messages;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Query;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Plannables {
    private static DecimalFormat df = new DecimalFormat("00");
    private static final Logger log = LoggerFactory.getLogger(Plannables.class);

    private Plannables() {
    }

    public static boolean isOverlapped(IPlannable p1, IPlannable p2) {
        if (p1.getDay().equals(p2.getDay())) {
            int Beginn = p1.getStartMinute();
            int oBeginn = p2.getStartMinute();
            int Dauer = p1.getDurationInMinutes();
            int oDauer = p2.getDurationInMinutes();
            if (Beginn < oBeginn) {
                return Beginn + Dauer > oBeginn;
            }
            if (Beginn > oBeginn) {
                return oBeginn + oDauer > Beginn;
            }
            return true;
        }
        return false;
    }

    public static boolean isEqual(IPlannable p1, IPlannable p2) {
        return p1.getDay().equals(p2.getDay()) && p1.getStartMinute() == p2.getStartMinute() && p1.getDurationInMinutes() == p2.getDurationInMinutes();
    }

    public static boolean collides(IPlannable p1, Collection<IPlannable> list) {
        for (IPlannable p2 : list) {
            if (Plannables.isEqual(p1, p2) || !Plannables.isOverlapped(p1, p2)) continue;
            return true;
        }
        return false;
    }

    public static boolean collides(TimeSpan ts, Collection<IPlannable> list, Termin exclude) {
        if (list == null) {
            return false;
        }
        for (IPlannable p : list) {
            if (exclude != null && Plannables.isEqual(p, exclude)) continue;
            TimeTool tt = new TimeTool(p.getDay());
            tt.add(12, p.getStartMinute());
            TimeSpan o = new TimeSpan(tt, p.getDurationInMinutes());
            if (ts.overlap(o) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean collides(TimeSpan ts, IPlannable[] list, Termin exclude) {
        if (list == null) {
            return false;
        }
        IPlannable[] iPlannableArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            IPlannable p = iPlannableArray[n2];
            if (exclude == null || !Plannables.isEqual(p, exclude)) {
                TimeTool tt = new TimeTool(p.getDay());
                tt.add(12, p.getStartMinute());
                TimeSpan o = new TimeSpan(tt, p.getDurationInMinutes());
                System.out.println(ts.dump() + " / " + o.dump());
                if (ts.overlap(o) != null) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static Color getTypColor(IPlannable p) {
        String coldesc = ConfigServiceHolder.getUserCached((String)("agenda/farben/typ/" + p.getType()), (String)"FFFFFF");
        return UiDesk.getColorFromRGB((String)coldesc);
    }

    public static Image getTypImage(IPlannable p) {
        return Plannables.getTypImage(p.getType());
    }

    public static Image getTypImage(String t) {
        String ipath = ConfigServiceHolder.getUserCached((String)("agenda/bilder/typ/" + t), null);
        if (!StringTool.isNothing((Object)ipath)) {
            Image ret = UiDesk.getImage((String)ipath);
            if (ret == null) {
                UiDesk.getImageRegistry().put(ipath, Activator.getImageDescriptor(ipath));
                ret = UiDesk.getImage((String)ipath);
            }
            return ret;
        }
        return null;
    }

    public static Color getStatusColor(IPlannable p) {
        if (p.getType().equals(Termin.typReserviert())) {
            String coldesc = ConfigServiceHolder.getUserCached((String)("agenda/farben/typ/" + p.getType()), (String)"000000");
            return UiDesk.getColorFromRGB((String)coldesc);
        }
        String coldesc = ConfigServiceHolder.getUserCached((String)("agenda/farben/status/" + p.getStatus()), (String)"000000");
        return UiDesk.getColorFromRGB((String)coldesc);
    }

    public static String getStartTimeAsString(IPlannable p) {
        int s = p.getStartMinute();
        int h = s / 60;
        int m = s % 60;
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(h)).append(":").append(df.format(m));
        return sb.toString();
    }

    public static String getEndTimeAsString(IPlannable p) {
        int s = p.getStartMinute() + p.getDurationInMinutes();
        int h = s / 60;
        int m = s % 60;
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(h)).append(":").append(df.format(m));
        return sb.toString();
    }

    public static Termin getFollowingTermin(String bereich, TimeTool date, Termin termin) {
        List<IPlannable> list = Plannables.loadTermine(bereich, date);
        boolean mark = false;
        for (IPlannable p : list) {
            if (mark) {
                return (Termin)p;
            }
            if (p.getStartMinute() != termin.getStartMinute()) continue;
            mark = true;
        }
        return null;
    }

    @Deprecated
    public static List<IPlannable> loadTermine(String bereich, TimeTool date) {
        List list;
        if (StringTool.isNothing((Object)bereich)) {
            return new ArrayList<IPlannable>();
        }
        Query qbe = new Query(Termin.class, "AGNTERMINE", false, new String[]{"Tag", "Beginn", "Dauer", "lastedit", "BeiWem"});
        String day = date.toString(9);
        qbe.add("Tag", "=", day);
        qbe.and();
        qbe.add("BeiWem", "=", bereich);
        if (ConfigServiceHolder.getUserCached((String)"agenda/zeige_geloeschte", (String)"0").equals("0")) {
            qbe.and();
            qbe.add("deleted", "=", "0");
        }
        if ((list = qbe.execute()) == null) {
            log.error(Messages.Plannables_databaseError);
            return new ArrayList<IPlannable>();
        }
        if (list.isEmpty()) {
            String[] flds;
            int d;
            Hashtable<String, String> map = Plannables.getDayPrefFor(bereich);
            String ds = map.get(TimeTool.wdays[(d = date.get(7)) - 1]);
            if (StringTool.isNothing((Object)ds)) {
                ds = "0000-0800\n1800-2359";
            }
            String[] stringArray = flds = ds.split("\r*\n\r*");
            int n = flds.length;
            int n2 = 0;
            while (n2 < n) {
                String fld = stringArray[n2];
                String from = fld.substring(0, 4);
                String until = fld.replaceAll("-", "").substring(4);
                list.add(new Termin(bereich, date.toString(9), TimeTool.getMinutesFromTimeString((String)from), TimeTool.getMinutesFromTimeString((String)until), Termin.typReserviert(), Termin.statusLeer()));
                ++n2;
            }
        }
        Collections.sort(list);
        return list;
    }

    public static IPlannable[] loadDays(String bereich, TimeTool date) {
        ArrayList<IPlannable> e = new ArrayList<IPlannable>(50);
        List<IPlannable> list = Plannables.loadTermine(bereich, date);
        IPlannable n = null;
        IPlannable last = null;
        String day = date.toString(9);
        for (IPlannable o : list) {
            n = o;
            if (n.getStartMinute() != 0) {
                if (last == null) {
                    Termin.Free res = new Termin.Free(day, 0, n.getStartMinute());
                    e.add(res);
                } else if (last.getStartMinute() + last.getDurationInMinutes() < n.getStartMinute()) {
                    Termin.Free fr = new Termin.Free(day, last.getStartMinute() + last.getDurationInMinutes(), n.getStartMinute());
                    for (IPlannable p : e) {
                        if (!Plannables.isOverlapped(p, fr)) continue;
                        fr.setStartMinute(p.getStartMinute() + p.getDurationInMinutes());
                    }
                    if (fr.getStartMinute() < n.getStartMinute()) {
                        fr.setDurationInMinutes(n.getStartMinute() - fr.getStartMinute());
                        e.add(fr);
                    }
                }
            }
            e.add(n);
            last = n;
        }
        if (e.isEmpty()) {
            Termin.Free ae = new Termin.Free(day, 0, 1439);
            e.add(ae);
            return e.toArray(new IPlannable[0]);
        }
        if (n != null && n.getStartMinute() + n.getDurationInMinutes() < 1439) {
            int b = n.getStartMinute() + n.getDurationInMinutes();
            Termin.Free en = new Termin.Free(day, b, 1439 - b);
            e.add(en);
        }
        return e.toArray(new IPlannable[0]);
    }

    public static void paint(GC gc, IPlannable p, Rectangle r, int start, int end) {
        double minutes = end - start;
        double pixelPerMinute = (double)r.width / minutes;
        int x = (int)Math.round((double)(p.getStartMinute() - start) * pixelPerMinute);
        int w = (int)Math.round((double)p.getDurationInMinutes() * pixelPerMinute);
        gc.setBackground(Plannables.getTypColor(p));
        gc.fillRectangle(x, r.y, w, r.height);
    }

    public static Hashtable<String, String> getTimePrefFor(String mandantLabel) {
        Hashtable<String, String> map = new Hashtable<String, String>();
        String mTimes = ConfigServiceHolder.getGlobal((String)("agenda/zeitvorgaben/" + mandantLabel), (String)"");
        if (!StringTool.isNothing((Object)mTimes)) {
            String[] types;
            String[] stringArray = types = mTimes.split("::");
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                String[] line = t.split("=");
                if (line.length != 2) {
                    log.warn(Messages.Plannables_errorInAppointmentText + mTimes);
                } else {
                    map.put(line[0], line[1]);
                }
                ++n2;
            }
        }
        if (map.get("std") == null) {
            map.put("std", "30");
        }
        return map;
    }

    public static void setTimePrefFor(String mandantLabel, Hashtable<String, String> map) {
        StringBuilder e = new StringBuilder(200);
        Enumeration<String> keys = map.keys();
        while (keys.hasMoreElements()) {
            String k = keys.nextElement();
            e.append(k).append("=").append(map.get(k));
            if (!keys.hasMoreElements()) continue;
            e.append("::");
        }
        ConfigServiceHolder.setGlobal((String)("agenda/zeitvorgaben/" + mandantLabel), (String)e.toString());
    }

    public static Hashtable<String, String> getDayPrefFor(String mandantLabel) {
        Hashtable map = StringTool.foldStrings((String)ConfigServiceHolder.getGlobal((String)("agenda/tagesvorgaben/" + mandantLabel), null));
        return map == null ? new Hashtable() : map;
    }

    public static void setDayPrefFor(String mandantLabel, Hashtable<String, String> map) {
        String flat = StringTool.flattenStrings(map);
        ConfigServiceHolder.setGlobal((String)("agenda/tagesvorgaben/" + mandantLabel), (String)flat);
    }

    public static boolean isNotAllDay(IAppointment appointment) {
        if (appointment != null) {
            return !appointment.isAllDay();
        }
        return false;
    }
}

