/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.composite;

import ch.elexis.agenda.ui.Messages;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.agenda.CollisionErrorLevel;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import jakarta.inject.Inject;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;

public class DayOverViewComposite
extends Canvas
implements PaintListener {
    @Inject
    private IAppointmentService appointmentService;
    @Inject
    private IConfigService configService;
    private CDateTime txtTimeFrom;
    private CDateTime txtTimeTo;
    private Spinner txtDuration;
    private int ts;
    private int te;
    private int tagStart;
    private int tagEnd;
    private int[] rasterValues;
    private int rasterIndex;
    private double minutes;
    private double pixelPerMinute;
    private Slider slider;
    private String msg;
    private Point d;
    private int sep;
    private List<IAppointment> list;
    private IAppointment appointment;
    private Group parent;
    private CollisionErrorLevel collisionErrorLevel;
    private Consumer<Boolean> collisionCallback;
    private String appointmentType;

    public DayOverViewComposite(Group parent, IAppointment appointment, CDateTime txtTimeFrom, CDateTime txtTimeTo, Spinner txtDuration) {
        super((Composite)parent, 0);
        this.tagStart = this.ts * 60;
        this.tagEnd = this.te * 60;
        this.rasterValues = new int[]{5, 10, 15, 30};
        this.collisionErrorLevel = CollisionErrorLevel.WARNING;
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
        this.parent = parent;
        this.ts = this.getRasterStartTime();
        this.te = this.getRasterEndTime();
        this.rasterIndex = this.getRasterIndex();
        this.appointment = appointment;
        this.txtTimeFrom = txtTimeFrom;
        this.txtDuration = txtDuration;
        this.txtTimeTo = txtTimeTo;
        this.addPaintListener(this);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.y > DayOverViewComposite.this.sep + 2) {
                    DayOverViewComposite.this.rasterIndex = DayOverViewComposite.this.rasterIndex >= DayOverViewComposite.this.rasterValues.length ? 0 : DayOverViewComposite.this.rasterIndex + 1;
                    DayOverViewComposite.this.setRasterIndex(DayOverViewComposite.this.rasterIndex);
                    DayOverViewComposite.this.redraw();
                } else {
                    Point loc = DayOverViewComposite.this.slider.getLocation();
                    DayOverViewComposite.this.slider.setLocation(e.x, loc.y);
                    DayOverViewComposite.this.slider.updateTimes();
                }
            }
        });
        this.slider = new Slider((Composite)this);
    }

    public void setAppointment(IAppointment appointment) {
        this.appointment = appointment;
    }

    public void setAppointmentType(String type) {
        this.refresh();
        this.appointmentType = type;
    }

    void recalc() {
        this.loadCurrentAppointments();
        this.tagStart = this.ts * 60;
        this.tagEnd = this.te * 60;
        int i = 0;
        if (!this.list.isEmpty()) {
            IAppointment pi = this.list.get(i);
            this.tagStart = this.isTerminTypeIsReserviert(pi) ? (pi.getDurationMinutes() < 31 ? 0 : pi.getDurationMinutes() - 30) : 0;
            i = this.list.size() - 1;
            pi = this.list.get(i);
            int end = this.getStartMinute(pi) + pi.getDurationMinutes();
            if (end < 1408) {
                this.tagEnd = 1439;
            }
            if (this.tagStart != 0) {
                this.tagStart = this.tagStart / 60 * 60;
            }
            if (this.tagEnd < 1439) {
                this.tagEnd = (this.tagEnd + 30) / 60 * 60;
            }
            this.minutes = this.tagEnd - this.tagStart;
            this.d = this.getSize();
            this.pixelPerMinute = (double)this.d.x / this.minutes;
            this.sep = this.d.y / 2;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.getParent().getSize().x, 60);
    }

    public void paintControl(PaintEvent pe) {
        this.recalc();
        GC g = pe.gc;
        Color def = g.getBackground();
        g.setBackground(this.getColor(5));
        Rectangle r = new Rectangle(0, 0, this.d.x, this.sep - 2);
        g.fillRectangle(r);
        for (IAppointment p : this.list) {
            this.paintAppointment(g, p, r, this.tagStart, this.tagEnd);
        }
        g.setBackground(def);
        g.setFont(this.getSmallFont());
        g.drawLine(0, this.sep, this.d.x, this.sep);
        if (this.rasterIndex >= this.rasterValues.length) {
            this.rasterIndex = 0;
            this.setRasterIndex(this.rasterIndex);
        }
        double chunkwidth = (double)this.rasterValues[this.rasterIndex] * this.pixelPerMinute;
        int chunksPerHour = 60 / this.rasterValues[this.rasterIndex];
        int ch = chunksPerHour - 1;
        int hr = this.tagStart / 60;
        if (chunkwidth < 0.1) {
            return;
        }
        double x = 0.0;
        while (x <= (double)this.d.x) {
            int lx = (int)Math.round(x);
            if (++ch == chunksPerHour) {
                g.drawLine(lx, this.sep - 1, lx, this.sep + 6);
                g.drawString(Integer.toString(hr++), lx, this.sep + 6);
                ch = 0;
            } else {
                g.drawLine(lx, this.sep, lx, this.sep + 4);
            }
            x += chunkwidth;
        }
        this.slider.redraw();
    }

    private void paintAppointment(GC gc, IAppointment p, Rectangle r, int start, int end) {
        double minutes = end - start;
        double pixelPerMinute = (double)r.width / minutes;
        int x = (int)Math.round((double)(this.getStartMinute(p) - start) * pixelPerMinute);
        int w = (int)Math.round((double)(Plannables.isNotAllDay(p) ? p.getDurationMinutes() : 1440) * pixelPerMinute);
        gc.setBackground(this.getTypColor(p));
        gc.fillRectangle(x, r.y, w, r.height);
    }

    public void set() {
        if (this.slider != null) {
            this.recalc();
            this.slider.set();
            this.updateCollision();
            this.redraw();
            this.getParent().layout();
        }
    }

    public void refresh() {
        if (this.slider != null) {
            this.recalc();
            this.updateCollision();
            this.redraw();
            this.getParent().layout();
        }
    }

    public void setCollisionErrorLevel(CollisionErrorLevel level, Consumer<Boolean> callback) {
        this.collisionErrorLevel = level;
        this.collisionCallback = callback;
        if (this.collisionCallback != null) {
            this.collisionCallback.accept(this.isColliding());
        }
    }

    private boolean isTerminTypeIsReserviert(IAppointment pi) {
        return pi.getType().equals(this.configService.getAsList("agenda/TerminTypen").get(1));
    }

    private boolean isTerminTypeIsFree(IAppointment pi) {
        return pi.getType().equals(this.configService.getAsList("agenda/TerminTypen").get(0));
    }

    private int getStartMinute(IAppointment pi) {
        long minutesIntoTheDay = ChronoUnit.MINUTES.between(pi.getStartTime().toLocalDate().atStartOfDay(), pi.getStartTime());
        return (int)minutesIntoTheDay;
    }

    private int getTimeInMinutes() {
        LocalDateTime localDateTime = this.txtTimeFrom.getSelection().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        long minutesIntoTheDay = ChronoUnit.MINUTES.between(localDateTime.toLocalDate().atStartOfDay(), localDateTime);
        return (int)minutesIntoTheDay;
    }

    private void setTimeTo(int minutesSinceStartOfDay) {
        if (this.txtTimeTo != null) {
            LocalDate baseDate = this.appointment.getStartTime().toLocalDate();
            LocalDateTime newEnd = baseDate.atStartOfDay().plusMinutes(minutesSinceStartOfDay);
            this.appointment.setEndTime(newEnd);
            this.txtTimeTo.setSelection(Date.from(newEnd.atZone(ZoneId.systemDefault()).toInstant()));
        }
    }

    private void setTimeFrom(int minutesSinceStartOfDay) {
        if (this.txtTimeFrom != null) {
            LocalDate baseDate = this.appointment.getStartTime().toLocalDate();
            LocalDateTime newStart = baseDate.atStartOfDay().plusMinutes(minutesSinceStartOfDay);
            this.appointment.setStartTime(newStart);
            this.txtTimeFrom.setSelection(Date.from(newStart.atZone(ZoneId.systemDefault()).toInstant()));
        }
    }

    private void updateCollision() {
        this.updateMessage(this.isColliding());
        if (this.collisionCallback != null) {
            this.collisionCallback.accept(this.isColliding());
        }
    }

    private void loadCurrentAppointments() {
        if (this.appointment.getSchedule() == null) {
            this.list = new ArrayList<IAppointment>();
        }
        IQuery query = CoreModelServiceHolder.get().getQuery(IAppointment.class, !this.configService.getActiveUserContact("agenda/zeige_geloeschte", "0").equals("0"));
        query.and("tag", IQuery.COMPARATOR.EQUALS, (Object)this.appointment.getStartTime().toLocalDate());
        query.and((EStructuralFeature)ModelPackage.Literals.IAPPOINTMENT__SCHEDULE, IQuery.COMPARATOR.EQUALS, (Object)this.appointment.getSchedule());
        this.list = query.execute();
        if (this.list.isEmpty()) {
            this.appointmentService.assertBlockTimes(this.appointment.getStartTime().toLocalDate(), this.appointment.getSchedule());
            this.list = query.execute();
        }
        this.list = this.list.stream().filter(a -> Plannables.isNotAllDay(a)).sorted(Comparator.comparing(a -> a.getStartTime())).collect(Collectors.toList());
    }

    private boolean isColliding() {
        return AppointmentServiceHolder.get().isColliding(this.appointment);
    }

    private int getRasterStartTime() {
        try {
            return Integer.parseInt(this.configService.getActiveUserContact("agenda/dayView/Start", "7"));
        }
        catch (NumberFormatException e) {
            return this.rasterIndex;
        }
    }

    private int getRasterEndTime() {
        try {
            return Integer.parseInt(this.configService.getActiveUserContact("agenda/dayView/End", "19"));
        }
        catch (NumberFormatException e) {
            return this.rasterIndex;
        }
    }

    private int getRasterIndex() {
        try {
            return Integer.parseInt(this.configService.getActiveUserContact("agenda/dayView/raster", "3"));
        }
        catch (NumberFormatException e) {
            return this.rasterIndex;
        }
    }

    private void setRasterIndex(int rasterIndex) {
        ContextServiceHolder.get().getActiveUserContact().ifPresent(c -> {
            boolean bl = this.configService.set(c, "agenda/dayView/raster", String.valueOf(rasterIndex));
        });
    }

    private void updateMessage(boolean collision) {
        this.msg = Messages.AgendaUI_DayOverView_create_or_change;
        this.slider.setBackground(this.getColor(15));
        int messageLevel = 0;
        if (collision) {
            this.slider.setBackground(this.getColor(16));
            this.msg = String.valueOf(this.msg) + Messages.AgendaUI_DayOverView_date_collision;
            messageLevel = this.collisionErrorLevel == CollisionErrorLevel.ERROR ? 3 : 2;
        } else {
            List kombiAppointments = this.appointmentType != null ? this.appointmentService.getKombiTermineIfApplicable(this.appointment, null, this.appointmentType, null) : new ArrayList();
            List linkedCollisions = this.appointmentService.getCollidingAppointments(kombiAppointments);
            if (linkedCollisions != null && !linkedCollisions.isEmpty()) {
                this.msg = this.buildCollisionInfoMessage(linkedCollisions);
                messageLevel = 2;
            }
        }
        int level = messageLevel;
        this.getShell().getDisplay().asyncExec(() -> this.setMessage(this.msg, level));
    }

    private void setMessage(String msg, int i) {
        if (i == 0) {
            this.parent.setForeground(this.parent.getParent().getForeground());
            this.parent.setText(msg);
        } else if (i == 3) {
            this.parent.setText(msg);
            this.parent.setForeground(this.getColor(3));
        } else if (i == 2) {
            this.parent.setText(msg);
            this.parent.setForeground(this.getColor(8));
        }
    }

    public boolean isValid() {
        return !CollisionErrorLevel.ERROR.equals((Object)this.collisionErrorLevel);
    }

    private Color getTypColor(IAppointment p) {
        String col;
        ColorRegistry cr;
        String coldesc = this.appointmentService.getContactConfiguredTypeColor(null, p.getType());
        if (coldesc.startsWith("#")) {
            coldesc = coldesc.substring(1);
        }
        if (!(cr = JFaceResources.getColorRegistry()).hasValueFor(col = StringTool.pad((int)1, (char)'0', (String)coldesc, (int)6))) {
            RGB rgb;
            try {
                rgb = new RGB(Integer.parseInt(col.substring(0, 2), 16), Integer.parseInt(col.substring(2, 4), 16), Integer.parseInt(col.substring(4, 6), 16));
            }
            catch (NumberFormatException nex) {
                ExHandler.handle((Throwable)nex);
                rgb = new RGB(100, 100, 100);
            }
            cr.put(col, rgb);
        }
        return cr.get(col);
    }

    private Color getColor(int swtColor) {
        Display display = Display.getCurrent();
        return display.getSystemColor(swtColor);
    }

    private Font getSmallFont() {
        String cfgName = "anwender/smallfont";
        FontRegistry fr = JFaceResources.getFontRegistry();
        if (!fr.hasValueFor(cfgName)) {
            FontData[] fd = PreferenceConverter.basicGetFontData((String)this.configService.getActiveUserContact(cfgName, ""));
            fr.put(cfgName, fd);
        }
        return fr.get(cfgName);
    }

    private String buildCollisionInfoMessage(List<IAppointment> linkedCollisions) {
        if (linkedCollisions == null || linkedCollisions.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.Core_Info).append(": ").append(linkedCollisions.size()).append(" ").append(Messages.AgendaUI_DayOverView_collisions);
        linkedCollisions.forEach(c -> {
            Object bereich = c.getSchedule() != null ? c.getSchedule().toString() : Messages.UNKNOWN + " " + Messages.AppointmentDetailComposite_range;
            sb.append(" | (").append((String)bereich).append(") ").append(c.getStartTime().toLocalTime()).append("\u2013").append(c.getEndTime().toLocalTime());
        });
        return sb.toString();
    }

    private class Slider
    extends Composite
    implements MouseListener,
    MouseMoveListener {
        boolean isDragging;

        Slider(Composite parent) {
            super(parent, 2048);
            this.setBackground(DayOverViewComposite.this.getColor(3));
            this.addMouseListener(this);
            this.addMouseMoveListener(this);
        }

        void set() {
            int v = DayOverViewComposite.this.getTimeInMinutes();
            int d = DayOverViewComposite.this.txtDuration.getSelection();
            Rectangle r = this.getParent().getBounds();
            int x = (int)Math.round((double)(v - DayOverViewComposite.this.tagStart) * DayOverViewComposite.this.pixelPerMinute);
            int w = (int)Math.round((double)d * DayOverViewComposite.this.pixelPerMinute);
            this.setBounds(x, 0, w, r.height / 2);
            DayOverViewComposite.this.setTimeTo(v + d);
            DayOverViewComposite.this.updateCollision();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            this.isDragging = true;
        }

        public void mouseUp(MouseEvent e) {
            if (this.isDragging) {
                this.isDragging = false;
                this.updateTimes();
            }
        }

        public void mouseMove(MouseEvent e) {
            if (this.isDragging) {
                Point loc = this.getLocation();
                int x = loc.x + e.x;
                this.setLocation(x, loc.y);
            }
        }

        public void updateTimes() {
            Point loc = this.getLocation();
            Rectangle rec = this.getParent().getBounds();
            double minutes = DayOverViewComposite.this.tagEnd - DayOverViewComposite.this.tagStart;
            double minutesPerPixel = minutes / (double)rec.width;
            int minute = (int)Math.round((double)loc.x * minutesPerPixel) + DayOverViewComposite.this.tagStart;
            int raster = DayOverViewComposite.this.rasterValues[DayOverViewComposite.this.rasterIndex];
            minute = (minute + (raster >> 1)) / raster * raster;
            DayOverViewComposite.this.setTimeFrom(minute);
            this.set();
        }
    }
}

