/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.actions;

import ch.elexis.agenda.BereichSelectionHandler;
import ch.elexis.agenda.Messages;
import ch.elexis.core.data.interfaces.scripting.Interpreter;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IAppointmentSeries;
import ch.elexis.core.model.IContact;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.rgw.tools.TimeTool;
import java.util.Optional;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    private static final Logger log = LoggerFactory.getLogger(Activator.class);
    public static final String PLUGIN_ID = "ch.elexis.agenda";
    private static Activator plugin;
    public static final String IMG_HOME = "ch.elexis.agenda.home";
    public static final String IMG_RECURRING_DATE = "ch.elexis.agenda.series";
    private String actResource;
    private TimeTool actDate;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        UiDesk.runIfWorkbenchRunning(() -> {
            UiDesk.getImageRegistry().put(IMG_HOME, Activator.getImageDescriptor("icons/calendar_view_day.png"));
            UiDesk.getImageRegistry().put(IMG_RECURRING_DATE, Activator.getImageDescriptor("icons/arrow-repeat.png"));
        });
        Interpreter.classLoaders.add(Activator.class.getClassLoader());
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public String[] getResources() {
        return ConfigServiceHolder.getGlobal((String)"agenda/bereiche", (String)Messages.TagesView_14).split(",");
    }

    public String getActResource() {
        if (this.actResource == null) {
            this.actResource = Activator.getDefault().getResources()[0];
        }
        return this.actResource;
    }

    public void setActResource(String resname) {
        this.actResource = resname;
        ConfigServiceHolder.setUser((String)"agenda/bereich", (String)resname);
        UiDesk.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                BereichSelectionHandler.updateListeners();
            }
        });
    }

    public TimeTool getActDate() {
        if (this.actDate == null) {
            this.actDate = new TimeTool();
        }
        return new TimeTool(this.actDate);
    }

    public void setActDate(String date) {
        if (this.actDate == null) {
            this.actDate = new TimeTool();
        }
        this.actDate.set(date);
    }

    public void setActDate(TimeTool date) {
        if (this.actDate == null) {
            this.actDate = new TimeTool();
        }
        this.actDate.set(date);
    }

    public TimeTool addDays(int day) {
        if (this.actDate == null) {
            this.actDate = new TimeTool();
        }
        this.actDate.addDays(day);
        return new TimeTool(this.actDate);
    }

    public void dispatchTermin(IAppointment appointment) {
        IContact contact = null;
        if (appointment.isRecurring()) {
            Optional series = AppointmentServiceHolder.get().getAppointmentSeries(appointment);
            if (series.isPresent()) {
                contact = ((IAppointmentSeries)series.get()).getContact();
            }
        } else {
            contact = appointment.getContact();
        }
        ContextServiceHolder.get().setTyped((Object)appointment);
        if (contact != null) {
            if (contact.isPatient()) {
                ContextServiceHolder.get().setActivePatient(contact.asIPatient());
            } else {
                ContextServiceHolder.get().setTyped((Object)contact);
            }
        }
    }
}

