/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.dialogs;

import ch.elexis.agenda.composite.MonthlySeriesComposite;
import ch.elexis.agenda.composite.WeeklySeriesComposite;
import ch.elexis.agenda.composite.YearlySeriesComposite;
import ch.elexis.agenda.ui.Messages;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IAppointmentSeries;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.agenda.EndingType;
import ch.elexis.core.model.agenda.SeriesType;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.e4.fieldassist.AsyncContentProposalProvider;
import ch.elexis.core.ui.e4.fieldassist.IdentifiableContentProposal;
import ch.elexis.dialogs.Date2LocalDateConverter;
import ch.elexis.dialogs.Date2LocalTimeConverter;
import ch.elexis.dialogs.LocalDate2DateConverter;
import ch.elexis.dialogs.LocalTime2DateConverter;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RecurringAppointmentDialog
extends TitleAreaDialog {
    private Text txtEndsAfterNOccurences;
    private Group groupData;
    private Text txtReason;
    private DateTime dateTimeBegin;
    private DateTime dateTimeEnd;
    private DateTime dateTimeBeginOfSeries;
    private Button btnEndsAfter;
    private Button btnEndsOn;
    private Spinner durationSpinner;
    private DateTime dateEndsOn;
    private CTabFolder tabFolderSeriesPattern;
    private WeeklySeriesComposite wsc;
    private MonthlySeriesComposite msc;
    private YearlySeriesComposite ysc;
    private Text txtContactSearch;
    private Combo comboSchedule;
    private Combo comboStatus;
    private IAppointmentSeries appointment;
    private boolean isPersistent;
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("ddMMyyyy");
    private DecimalFormat decimalFormat = new DecimalFormat("00");

    public RecurringAppointmentDialog(IAppointmentSeries appointment) {
        super(Display.getDefault().getActiveShell());
        this.appointment = appointment;
        this.isPersistent = appointment.isPersistent();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        if (this.isPersistent) {
            this.setMessage(Messages.SerienTerminDialog_this_message_show);
        } else {
            this.setMessage(Messages.SerienTerminDialog_this_message_create);
        }
        Group grpTermin = new Group(area, 0);
        grpTermin.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpTermin.setLayout((Layout)new GridLayout(6, false));
        grpTermin.setText(Messages.SerienTerminDialog_grpTermin_text);
        Label lblBeginn = new Label((Composite)grpTermin, 0);
        lblBeginn.setText(Messages.SerienTerminDialog_lblBeginn_text);
        this.dateTimeBegin = new DateTime((Composite)grpTermin, 34944);
        this.dateTimeBegin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecurringAppointmentDialog.this.updateSpinner();
            }
        });
        Label lblEnde = new Label((Composite)grpTermin, 0);
        lblEnde.setText(Messages.SerienTerminDialog_lblEnde_text);
        this.dateTimeEnd = new DateTime((Composite)grpTermin, 34944);
        this.dateTimeEnd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecurringAppointmentDialog.this.updateSpinner();
            }
        });
        Label lblDauer = new Label((Composite)grpTermin, 0);
        lblDauer.setText(Messages.SerienTerminDialog_lblDauer_text);
        this.durationSpinner = new Spinner((Composite)grpTermin, 0);
        this.durationSpinner.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.durationSpinner.setMinimum(5);
        this.durationSpinner.setMaximum(1440);
        this.durationSpinner.setIncrement(5);
        this.durationSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int value = RecurringAppointmentDialog.this.durationSpinner.getSelection();
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(11, RecurringAppointmentDialog.this.dateTimeBegin.getHours());
                cal.set(12, RecurringAppointmentDialog.this.dateTimeBegin.getMinutes());
                cal.add(12, value);
                RecurringAppointmentDialog.this.dateTimeEnd.setHours(cal.get(11));
                RecurringAppointmentDialog.this.dateTimeEnd.setMinutes(cal.get(12));
            }
        });
        Group grpSerienmuster = new Group(area, 0);
        grpSerienmuster.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpSerienmuster.setLayout((Layout)new GridLayout(1, false));
        grpSerienmuster.setText(Messages.SerienTerminDialog_grpSerienmuster_text);
        this.tabFolderSeriesPattern = new CTabFolder((Composite)grpSerienmuster, 2048);
        this.tabFolderSeriesPattern.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tabFolderSeriesPattern.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        this.tabFolderSeriesPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecurringAppointmentDialog.this.appointment.setSeriesType((SeriesType)e.item.getData());
            }
        });
        CTabItem tbtmDaily = new CTabItem(this.tabFolderSeriesPattern, 0);
        tbtmDaily.setText(Messages.SerienTerminDialog_tbtmDaily_text);
        tbtmDaily.setData((Object)SeriesType.DAILY);
        Label lblNoConfigurationNecessary = new Label((Composite)this.tabFolderSeriesPattern, 0);
        tbtmDaily.setControl((Control)lblNoConfigurationNecessary);
        lblNoConfigurationNecessary.setText(Messages.SerienTerminDialog_lblNoConfigurationNecessary_text);
        CTabItem tbtmWeekly = new CTabItem(this.tabFolderSeriesPattern, 0);
        tbtmWeekly.setText(Messages.SerienTerminDialog_tbtmWeekly_text);
        this.wsc = new WeeklySeriesComposite((Composite)this.tabFolderSeriesPattern, 0);
        tbtmWeekly.setControl((Control)this.wsc);
        tbtmWeekly.setData((Object)SeriesType.WEEKLY);
        CTabItem tbtmMonthly = new CTabItem(this.tabFolderSeriesPattern, 0);
        tbtmMonthly.setText(Messages.SerienTerminDialog_tbtmMonthly_text);
        this.msc = new MonthlySeriesComposite((Composite)this.tabFolderSeriesPattern, 0);
        tbtmMonthly.setControl((Control)this.msc);
        new Label((Composite)this.msc, 0);
        tbtmMonthly.setData((Object)SeriesType.MONTHLY);
        CTabItem tbtmYearly = new CTabItem(this.tabFolderSeriesPattern, 0);
        tbtmYearly.setText(Messages.SerienTerminDialog_tbtmYearly_text);
        this.ysc = new YearlySeriesComposite((Composite)this.tabFolderSeriesPattern, 0);
        tbtmYearly.setControl((Control)this.ysc);
        tbtmYearly.setData((Object)SeriesType.YEARLY);
        Group grpSeriendauer = new Group(area, 0);
        grpSeriendauer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpSeriendauer.setLayout((Layout)new GridLayout(3, false));
        grpSeriendauer.setText(Messages.SerienTerminDialog_grpSeriendauer_text);
        Label beginOfSeries = new Label((Composite)grpSeriendauer, 0);
        beginOfSeries.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        beginOfSeries.setText(Messages.SerienTerminDialog_beginOfSeries_text);
        this.dateTimeBeginOfSeries = new DateTime((Composite)grpSeriendauer, 268437508);
        this.dateTimeBeginOfSeries.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.dateTimeBeginOfSeries.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalDate start = RecurringAppointmentDialog.this.appointment.getSeriesStartDate();
                RecurringAppointmentDialog.this.wsc.setWeekNumberLabel(start.get(ChronoField.ALIGNED_WEEK_OF_YEAR), start.getYear());
                super.widgetSelected(e);
            }
        });
        Composite composite = new Composite((Composite)grpSeriendauer, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout composite_layout = new GridLayout(2, false);
        composite_layout.marginHeight = 0;
        composite_layout.marginWidth = 0;
        composite.setLayout((Layout)composite_layout);
        this.btnEndsAfter = new Button(composite, 16);
        this.btnEndsAfter.setText(Messages.SerienTerminDialog_btnEndsAfter_text);
        this.btnEndsAfter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecurringAppointmentDialog.this.appointment.setEndingType(EndingType.AFTER_N_OCCURENCES);
            }
        });
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout composite_1_layout = new GridLayout(2, false);
        composite_1_layout.marginHeight = 0;
        composite_1_layout.marginWidth = 0;
        composite_1.setLayout((Layout)composite_1_layout);
        this.txtEndsAfterNOccurences = new Text(composite_1, 2048);
        this.txtEndsAfterNOccurences.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblNewLabel = new Label(composite_1, 0);
        lblNewLabel.setText(Messages.SerienTerminDialog_lblNewLabel_text);
        this.btnEndsOn = new Button(composite, 16);
        this.btnEndsOn.setText(Messages.SerienTerminDialog_btnEndsOn_text);
        this.btnEndsOn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecurringAppointmentDialog.this.appointment.setEndingType(EndingType.ON_SPECIFIC_DATE);
            }
        });
        this.dateEndsOn = new DateTime(composite, 2048);
        this.groupData = new Group(area, 0);
        this.groupData.setText(Messages.SerienTerminDialog_groupData_text);
        this.groupData.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.groupData.setLayout((Layout)new GridLayout(2, false));
        this.txtReason = new Text((Composite)this.groupData, 2048);
        this.txtReason.setMessage(Messages.SerienTerminDialog_txtReason_message);
        this.txtReason.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.txtContactSearch = new Text((Composite)this.groupData, 640);
        this.txtContactSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.txtContactSearch.setMessage("Vorname, Nachname");
        AsyncContentProposalProvider<IContact> aopp = new AsyncContentProposalProvider<IContact>(new String[]{"description1", "description2"}){

            public IQuery<IContact> createBaseQuery() {
                return CoreModelServiceHolder.get().getQuery(IContact.class);
            }

            public Text getWidget() {
                return RecurringAppointmentDialog.this.txtContactSearch;
            }
        };
        this.txtContactSearch.setData((Object)this.appointment.getContact());
        ControlDecoration controlDecoration = new ControlDecoration((Control)this.txtContactSearch, 16512);
        controlDecoration.setDescriptionText(Messages.RecurringAppointmentDialog_search_contact_by_fiels);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.show();
        controlDecoration.setShowHover(true);
        ContentProposalAdapter cppa = new ContentProposalAdapter((Control)this.txtContactSearch, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)aopp, null, null);
        aopp.configureContentProposalAdapter(cppa);
        cppa.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                IdentifiableContentProposal prop = (IdentifiableContentProposal)proposal;
                RecurringAppointmentDialog.this.txtContactSearch.setText(prop.getLabel());
                RecurringAppointmentDialog.this.txtContactSearch.setData(prop.getIdentifiable());
                RecurringAppointmentDialog.this.appointment.setSubjectOrPatient(((IContact)prop.getIdentifiable()).getId());
                RecurringAppointmentDialog.this.reloadContactLabel();
            }
        });
        Label lbl = new Label((Composite)this.groupData, 0);
        lbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lbl.setText(Messages.SerienTerminDialog_lblArea_text);
        this.comboSchedule = new Combo((Composite)this.groupData, 0);
        this.comboSchedule.setItems(ConfigServiceHolder.get().get("agenda/bereiche", "Praxis").split(","));
        this.comboSchedule.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!RecurringAppointmentDialog.this.comboSchedule.getText().equals(RecurringAppointmentDialog.this.appointment.getSchedule())) {
                    RecurringAppointmentDialog.this.appointment.setSchedule(RecurringAppointmentDialog.this.comboSchedule.getText());
                }
            }
        });
        lbl = new Label((Composite)this.groupData, 0);
        lbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lbl.setText(Messages.SerienTerminDialog_lblStatus_text);
        this.comboStatus = new Combo((Composite)this.groupData, 4);
        List states = AppointmentServiceHolder.get().getStates();
        this.comboStatus.setItems(states.toArray(new String[states.size()]));
        this.comboStatus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!RecurringAppointmentDialog.this.comboStatus.getText().equals(RecurringAppointmentDialog.this.appointment.getState())) {
                    RecurringAppointmentDialog.this.appointment.setState(RecurringAppointmentDialog.this.comboStatus.getText());
                }
            }
        });
        this.initDataBindings();
        this.initDialog();
        if (this.isPersistent) {
            this.disableAll((Control)area);
        }
        return area;
    }

    protected boolean isResizable() {
        return true;
    }

    private Optional<IContact> getAppointmentContact() {
        return Optional.ofNullable(this.appointment.getContact());
    }

    private void reloadContactLabel() {
        Optional<IContact> c = this.getAppointmentContact();
        String currentSearchText = this.txtContactSearch.getText();
        if (c.isPresent() && c.get().getLabel().equals(currentSearchText)) {
            this.txtContactSearch.setText(c.get().getLabel());
        }
    }

    private void disableAll(Control widget) {
        if (widget instanceof Composite) {
            Control[] children;
            Composite composite = (Composite)widget;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                this.disableAll(control);
                ++n2;
            }
            composite.setEnabled(false);
        } else if (widget instanceof Control) {
            widget.setEnabled(false);
        }
    }

    private void initDialog() {
        if (this.appointment.getContact() != null) {
            this.setTitle(this.appointment.getContact().getLabel());
        } else {
            this.setTitle(Messages.RecurringAppointmentDialog_no_contact_selected);
        }
        if (this.appointment.getContact() != null) {
            this.txtContactSearch.setText(this.appointment.getContact().getLabel());
        } else {
            this.txtContactSearch.setText(this.appointment.getSubjectOrPatient());
        }
        this.comboSchedule.setText(this.appointment.getSchedule());
        this.comboStatus.setText(this.appointment.getState());
        switch (this.appointment.getSeriesType()) {
            case DAILY: {
                this.tabFolderSeriesPattern.setSelection(0);
                break;
            }
            case WEEKLY: {
                this.tabFolderSeriesPattern.setSelection(1);
                String[] pattern = this.appointment.getSeriesPatternString().split(",");
                this.wsc.getTxtWeekDistance().setText(pattern[0]);
                if (pattern.length > 1) {
                    int i = 0;
                    while (i < pattern[1].length()) {
                        char c = pattern[1].charAt(i);
                        this.wsc.getWeekdays()[Character.getNumericValue(c)].setSelection(true);
                        ++i;
                    }
                }
                LocalDate start = this.appointment.getSeriesStartDate();
                this.wsc.setWeekNumberLabel(start.get(ChronoField.ALIGNED_WEEK_OF_YEAR), start.getYear());
                break;
            }
            case MONTHLY: {
                this.tabFolderSeriesPattern.setSelection(2);
                this.msc.setDay(Integer.parseInt(this.appointment.getSeriesPatternString()));
                break;
            }
            case YEARLY: {
                this.tabFolderSeriesPattern.setSelection(3);
                this.ysc.setDay(Integer.parseInt(this.appointment.getSeriesPatternString().substring(0, 2)));
                this.ysc.setMonth(Integer.parseInt(this.appointment.getSeriesPatternString().substring(2, 4)));
                break;
            }
        }
        switch (this.appointment.getEndingType()) {
            case AFTER_N_OCCURENCES: {
                this.btnEndsAfter.setSelection(true);
                this.txtEndsAfterNOccurences.setText(this.appointment.getEndingPatternString());
                break;
            }
            case ON_SPECIFIC_DATE: {
                this.btnEndsOn.setSelection(true);
                LocalDate end = this.appointment.getSeriesEndDate();
                this.dateEndsOn.setDate(end.getYear(), end.getMonthValue() - 1, end.getDayOfMonth());
                break;
            }
        }
        this.updateSpinner();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        UpdateValueStrategy timeTarget2model = new UpdateValueStrategy();
        timeTarget2model.setConverter((IConverter)new Date2LocalTimeConverter());
        UpdateValueStrategy timeModel2target = new UpdateValueStrategy();
        timeModel2target.setConverter((IConverter)new LocalTime2DateConverter());
        UpdateValueStrategy dateTarget2model = new UpdateValueStrategy();
        dateTarget2model.setConverter((IConverter)new Date2LocalDateConverter());
        UpdateValueStrategy dateModel2target = new UpdateValueStrategy();
        dateModel2target.setConverter((IConverter)new LocalDate2DateConverter());
        ISWTObservableValue observeSelectionDateTimeBeginObserveWidget = WidgetProperties.dateTimeSelection().observe((Widget)this.dateTimeBegin);
        IObservableValue beginTimeSerienTerminObserveValue = PojoProperties.value((String)"seriesStartTime").observe((Object)this.appointment);
        bindingContext.bindValue((IObservableValue)observeSelectionDateTimeBeginObserveWidget, beginTimeSerienTerminObserveValue, timeTarget2model, timeModel2target);
        ISWTObservableValue observeSelectionDateTimeEndObserveWidget = WidgetProperties.dateTimeSelection().observe((Widget)this.dateTimeEnd);
        IObservableValue endTimeSerienTerminObserveValue = PojoProperties.value((String)"seriesEndTime").observe((Object)this.appointment);
        bindingContext.bindValue((IObservableValue)observeSelectionDateTimeEndObserveWidget, endTimeSerienTerminObserveValue, timeTarget2model, timeModel2target);
        ISWTObservableValue observeSelectionDateTimeBeginOfSeriesObserveWidget = WidgetProperties.dateTimeSelection().observe((Widget)this.dateTimeBeginOfSeries);
        IObservableValue seriesStartDateSerienTerminObserveValue = PojoProperties.value((String)"seriesStartDate").observe((Object)this.appointment);
        bindingContext.bindValue((IObservableValue)observeSelectionDateTimeBeginOfSeriesObserveWidget, seriesStartDateSerienTerminObserveValue, dateTarget2model, dateModel2target);
        ISWTObservableValue observeTextTxtReasonObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtReason);
        IObservableValue reasonSerienTerminObserveValue = PojoProperties.value((String)"reason").observe((Object)this.appointment);
        bindingContext.bindValue((IObservableValue)observeTextTxtReasonObserveWidget, reasonSerienTerminObserveValue, null, null);
        ISWTObservableValue observeSelectionDateEndsOnObserveWidget = WidgetProperties.dateTimeSelection().observe((Widget)this.dateEndsOn);
        IObservableValue endsOnDateSerienTerminObserveValue = PojoProperties.value((String)"seriesEndDate").observe((Object)this.appointment);
        bindingContext.bindValue((IObservableValue)observeSelectionDateEndsOnObserveWidget, endsOnDateSerienTerminObserveValue, dateTarget2model, dateModel2target);
        return bindingContext;
    }

    private void updateSpinner() {
        int startTime;
        int endTime = this.dateTimeEnd.getHours() * 60 + this.dateTimeEnd.getMinutes();
        int result = endTime - (startTime = this.dateTimeBegin.getHours() * 60 + this.dateTimeBegin.getMinutes());
        if (result < 0) {
            result = 0;
        }
        this.durationSpinner.setSelection(result);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        Button button = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        button.setText(Messages.SerienTerminDialog_other_text);
        Button button_1 = this.createButton(parent, 6, "remove series", false);
        button_1.setText(Messages.SerienTerminDialog_other_text_1);
        button_1.setEnabled(this.isPersistent);
    }

    protected void buttonPressed(int buttonId) {
        this.updateModel();
        if (buttonId == 0) {
            if (this.isPersistent) {
                this.close();
            } else {
                int result = 0;
                if (AppointmentServiceHolder.get().isColliding((IAppointment)this.appointment)) {
                    MessageDialog collisionDialog = new MessageDialog(this.getShell(), Messages.SerienTerminDialog_dlgLockTimesConflict, null, Messages.SerienTerminDialog_dlgLockTimesSeriesConflict, 4, new String[]{Messages.SerienTerminDialog_dlgBtnApplyAnyway, Messages.SerienTerminDialog_dlgBtnChange, Messages.SerienTerminDialog_dlgBtnCancel}, 0);
                    result = collisionDialog.open();
                }
                if (result == 0) {
                    AppointmentServiceHolder.get().saveAppointmentSeries(this.appointment);
                } else if (result == 1) {
                    return;
                }
            }
        } else if (buttonId == 6) {
            AppointmentServiceHolder.get().deleteAppointmentSeries(this.appointment);
            this.close();
        }
        ContextServiceHolder.get().postEvent("info/elexis/model/reload", IAppointment.class);
        super.buttonPressed(buttonId);
    }

    private void updateModel() {
        if (this.txtDataIsMatchingContact()) {
            this.appointment.setSubjectOrPatient(((IContact)this.txtContactSearch.getData()).getId());
        } else if (StringUtils.isNotBlank((CharSequence)this.txtContactSearch.getText())) {
            this.appointment.setSubjectOrPatient(this.txtContactSearch.getText());
        }
        switch (this.appointment.getSeriesType()) {
            case DAILY: {
                switch (this.appointment.getEndingType()) {
                    case AFTER_N_OCCURENCES: {
                        this.appointment.setSeriesPatternString(this.txtEndsAfterNOccurences.getText());
                        break;
                    }
                    case ON_SPECIFIC_DATE: {
                        this.appointment.setSeriesPatternString(this.dateFormatter.format(this.appointment.getSeriesEndDate()));
                    }
                }
                break;
            }
            case WEEKLY: {
                StringBuilder sb = new StringBuilder();
                sb.append(this.wsc.getTxtWeekDistance().getText() + ",");
                int i = 1;
                while (i < 8) {
                    if (this.wsc.getWeekdays()[i].getSelection()) {
                        sb.append(i);
                    }
                    ++i;
                }
                this.appointment.setSeriesPatternString(sb.toString());
                break;
            }
            case MONTHLY: {
                this.appointment.setSeriesPatternString("" + this.msc.getDay());
                break;
            }
            case YEARLY: {
                this.appointment.setSeriesPatternString(this.decimalFormat.format(this.ysc.getDay()) + this.decimalFormat.format(this.ysc.getMonth()));
                break;
            }
        }
        switch (this.appointment.getEndingType()) {
            case AFTER_N_OCCURENCES: {
                this.appointment.setEndingPatternString(this.txtEndsAfterNOccurences.getText());
                break;
            }
            case ON_SPECIFIC_DATE: {
                this.appointment.setEndingPatternString(this.dateFormatter.format(this.appointment.getSeriesEndDate()));
            }
        }
    }

    private boolean txtDataIsMatchingContact() {
        return this.txtContactSearch.getData() instanceof IContact && ((IContact)this.txtContactSearch.getData()).getLabel().equals(this.txtContactSearch.getText());
    }
}

