/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.dialogs;

import ch.elexis.agenda.preferences.Messages;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddKombiTerminDialog
extends TitleAreaDialog {
    private Text titleText;
    private Combo agendaBereichCombo;
    private Combo terminTypCombo;
    private Combo dauerCombo;
    private Button vorherRadio;
    private Button nachherRadio;
    private Combo zeitversatzCombo;
    private Button okButton;
    private List<String> areas;
    private List<String> appointmentTypes;
    private String bereichsTyp;
    private String[] appointmentData;
    private boolean isManualDauerChange = false;

    public AddKombiTerminDialog(Shell parentShell, String bereich) {
        super(parentShell);
        this.bereichsTyp = bereich;
        this.appointmentData = null;
    }

    public AddKombiTerminDialog(Shell parentShell, String bereich, String[] appointmentData) {
        super(parentShell);
        this.bereichsTyp = bereich;
        this.appointmentData = appointmentData;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainContainer = (Composite)super.createDialogArea(parent);
        mainContainer.setLayout((Layout)new GridLayout(1, false));
        this.setTitle(this.appointmentData == null ? Messages.AddCombiTerminErstellen : Messages.AddCombiTerminBearbeiten);
        this.setMessage(this.appointmentData == null ? MessageFormat.format(Messages.AddCombiTerminErstellenDescription, this.bereichsTyp) : MessageFormat.format(Messages.AddCombiTerminBearbeitenDescription, this.bereichsTyp));
        Composite container = new Composite(mainContainer, 0);
        container.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        container.setLayout((Layout)new GridLayout(2, false));
        GridData comboData = new GridData();
        comboData.widthHint = 230;
        Label titleLabel = new Label(container, 0);
        titleLabel.setText(Messages.AddCombiTerminDialogReason + ":");
        this.titleText = new Text(container, 2048);
        this.titleText.setLayoutData((Object)comboData);
        Label bereichLabel = new Label(container, 0);
        bereichLabel.setText(Messages.AddCombiTerminDialogRange);
        this.agendaBereichCombo = new Combo(container, 12);
        this.agendaBereichCombo.setLayoutData((Object)comboData);
        Label terminTypLabel = new Label(container, 0);
        terminTypLabel.setText(Messages.AddCombiTerminDialogTyp + ":");
        this.terminTypCombo = new Combo(container, 12);
        this.terminTypCombo.setLayoutData((Object)comboData);
        Label dauerLabel = new Label(container, 0);
        dauerLabel.setText(Messages.AddCombiTerminDialogDuration);
        Composite dauerComposite = new Composite(container, 0);
        dauerComposite.setLayout((Layout)new GridLayout(2, false));
        dauerComposite.setLayoutData((Object)new GridData(4, 16384, true, false, 1, 1));
        this.dauerCombo = new Combo(dauerComposite, 12);
        GridData dauerComboData = new GridData();
        dauerComboData.widthHint = 40;
        dauerComboData.horizontalIndent = -5;
        this.dauerCombo.setLayoutData((Object)dauerComboData);
        Label minutenLabel = new Label(dauerComposite, 0);
        minutenLabel.setText(Messages.AddCombiTerminDialogMinute);
        Label zeitversatzLabel = new Label(container, 0);
        zeitversatzLabel.setText(Messages.AddCombiTerminDialogTimeOffset);
        Composite zeitversatzComposite = new Composite(container, 0);
        zeitversatzComposite.setLayout((Layout)new GridLayout(4, false));
        zeitversatzComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.vorherRadio = new Button(zeitversatzComposite, 16);
        this.vorherRadio.setText(Messages.AddCombiTerminDialogBefore);
        this.nachherRadio = new Button(zeitversatzComposite, 16);
        this.nachherRadio.setText(Messages.AddCombiTerminDialogAfter);
        this.zeitversatzCombo = new Combo(zeitversatzComposite, 12);
        GridData zeitversatzComboData = new GridData();
        zeitversatzComboData.widthHint = 40;
        this.zeitversatzCombo.setLayoutData((Object)zeitversatzComboData);
        Label minutenLabel2 = new Label(zeitversatzComposite, 0);
        minutenLabel2.setText(Messages.AddCombiTerminDialogMinute);
        this.populateAgendaBereichCombo();
        this.populateZeitversatzCombo();
        SelectionAdapter commonSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AddKombiTerminDialog.this.isManualDauerChange) {
                    AddKombiTerminDialog.this.updateDauerCombo();
                }
                AddKombiTerminDialog.this.updateOkButtonState();
            }
        };
        this.agendaBereichCombo.addSelectionListener((SelectionListener)commonSelectionListener);
        this.terminTypCombo.addSelectionListener((SelectionListener)commonSelectionListener);
        this.vorherRadio.addSelectionListener((SelectionListener)commonSelectionListener);
        this.nachherRadio.addSelectionListener((SelectionListener)commonSelectionListener);
        this.zeitversatzCombo.addSelectionListener((SelectionListener)commonSelectionListener);
        this.dauerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddKombiTerminDialog.this.isManualDauerChange = true;
                AddKombiTerminDialog.this.updateOkButtonState();
            }
        });
        this.titleText.addModifyListener(e -> this.updateOkButtonState());
        if (this.appointmentData != null) {
            this.isManualDauerChange = false;
            this.titleText.setText(this.appointmentData[0]);
            this.agendaBereichCombo.setText(this.appointmentData[1]);
            this.terminTypCombo.setText(this.appointmentData[2]);
            if (Messages.AddCombiTerminDialogBefore.equals(this.appointmentData[3])) {
                this.vorherRadio.setSelection(true);
            } else {
                this.nachherRadio.setSelection(true);
            }
            this.zeitversatzCombo.setText(this.appointmentData[4]);
            this.dauerCombo.setText(this.appointmentData[5]);
        }
        return mainContainer;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(false);
        this.updateOkButtonState();
        return control;
    }

    protected void okPressed() {
        String title = this.titleText.getText();
        String agendaBereich = this.agendaBereichCombo.getText();
        String terminTyp = this.terminTypCombo.getText();
        String dauer = this.dauerCombo.getText();
        String zeitversatz = this.zeitversatzCombo.getText();
        String zeitversatzType = this.vorherRadio.getSelection() ? Messages.AddCombiTerminDialogBefore : Messages.AddCombiTerminDialogAfter;
        String kombiTermin = "{" + String.join((CharSequence)";", title, agendaBereich, terminTyp, zeitversatzType, zeitversatz, dauer) + "}";
        ArrayList<CallSite> existingKombiTermine = new ArrayList<CallSite>(ConfigServiceHolder.get().getAsList("agenda/kombitermine/" + this.bereichsTyp));
        if (this.appointmentData != null) {
            String oldKombiTermin = "{" + String.join((CharSequence)";", this.appointmentData) + "}";
            existingKombiTermine.remove(oldKombiTermin);
        }
        existingKombiTermine.add((CallSite)((Object)kombiTermin));
        ConfigServiceHolder.setGlobalAsList((String)("agenda/kombitermine/" + this.bereichsTyp), existingKombiTermine);
        super.okPressed();
    }

    private void updateDauerCombo() {
        String dauer;
        String selectedBereich = this.agendaBereichCombo.getText();
        String selectedTyp = this.terminTypCombo.getText();
        if (!selectedBereich.isEmpty() && !selectedTyp.isEmpty() && (dauer = this.getDauerForBereichAndTyp(selectedBereich, selectedTyp)) != null) {
            this.dauerCombo.setText(dauer);
        }
    }

    private String getDauerForBereichAndTyp(String bereich, String typ) {
        Hashtable<String, String> timePrefs = Plannables.getTimePrefFor(bereich);
        String dauer = timePrefs.get(typ);
        if (dauer == null) {
            dauer = timePrefs.get("std");
        }
        return dauer;
    }

    private void updateOkButtonState() {
        boolean isFormValid;
        boolean bl = isFormValid = !this.titleText.getText().trim().isEmpty() && !this.agendaBereichCombo.getText().isEmpty() && !this.terminTypCombo.getText().isEmpty() && !this.dauerCombo.getText().isEmpty() && !this.dauerCombo.getText().equals("0") && (this.vorherRadio.getSelection() || this.nachherRadio.getSelection()) && !this.zeitversatzCombo.getText().isEmpty();
        if (this.okButton != null) {
            this.okButton.setEnabled(isFormValid);
        }
    }

    private void populateAgendaBereichCombo() {
        this.areas = ConfigServiceHolder.get().getAsList("agenda/bereiche");
        this.appointmentTypes = ConfigServiceHolder.get().getAsList("agenda/TerminTypen");
        this.agendaBereichCombo.setItems(this.areas.toArray(new String[0]));
        List<String> filteredAppointmentTypes = this.appointmentTypes.stream().skip(2L).collect(Collectors.toList());
        this.terminTypCombo.setItems(filteredAppointmentTypes.toArray(new String[0]));
    }

    private void populateZeitversatzCombo() {
        ArrayList<String> timeIntervals = new ArrayList<String>();
        int minutes = 0;
        while (minutes <= 240) {
            timeIntervals.add(String.valueOf(minutes));
            minutes += 5;
        }
        this.zeitversatzCombo.setItems(timeIntervals.toArray(new String[0]));
        this.dauerCombo.setItems(timeIntervals.toArray(new String[0]));
    }
}

