/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.composite;

import ch.elexis.actions.Activator;
import ch.elexis.agenda.BereichSelectionHandler;
import ch.elexis.agenda.composite.DayOverViewComposite;
import ch.elexis.agenda.composite.EmailComposite;
import ch.elexis.agenda.ui.Messages;
import ch.elexis.agenda.util.AppointmentExtensionHandler;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPeriod;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.agenda.CollisionErrorLevel;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.e4.fieldassist.AsyncContentProposalProvider;
import ch.elexis.core.ui.e4.fieldassist.IdentifiableContentProposal;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.utils.CoreUtil;
import ch.rgw.tools.TimeTool;
import jakarta.inject.Inject;
import java.awt.Desktop;
import java.net.URI;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class AppointmentDetailComposite
extends Composite {
    private IAppointment appointment;
    @Inject
    private IAppointmentService appointmentService;
    @Inject
    private IConfigService configService;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private ESelectionService selectionService;
    private CDateTime txtDateFrom;
    private CDateTime txtDateFromDrop;
    private Button btnIsAllDay;
    private CDateTime txtTimeFrom;
    private Spinner txtDuration;
    private CDateTime txtTimeTo;
    private Composite compContext;
    private Link txtContact;
    private DateTime pickerContext;
    private Combo comboArea;
    private Combo comboType;
    private Combo comboStatus;
    private Text txtReason;
    private Text txtPatSearch;
    private Text tBem;
    private DayOverViewComposite dayBar;
    private TableViewer appointmentsViewer;
    private Composite container;
    private EmailComposite emailComposite;
    private Button chkTerminLinks;
    private SashForm sash;
    private Composite leftPane;
    private Composite rightPane;
    private Button btnExpand;
    private Group compContentMiddle;
    private Group compTimeSelektor;
    private Label lblDateFrom;
    private Composite dateArea;
    private boolean scheduleChangeMode = false;
    private Button chkLocked;
    private boolean changeLocked = false;
    private static final int[] SASH_WEIGHTS_EXPANDED = new int[]{25, 75};
    SelectionAdapter dateTimeSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AppointmentDetailComposite.this.updateDateTimeFields(e.getSource());
        }
    };

    public boolean isChangeLocked() {
        return this.changeLocked;
    }

    private static LocalDate toLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    private static LocalTime toLocalTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
    }

    private void updateDateTimeFields(Object source) {
        Date dateFrom = this.txtDateFrom.getSelection();
        Date timeFrom = this.txtTimeFrom.getSelection();
        Date timeTo = this.txtTimeTo.getSelection();
        int duration = this.txtDuration.getSelection();
        LocalDate localDateFrom = AppointmentDetailComposite.toLocalDate(dateFrom);
        LocalTime localTimeFrom = AppointmentDetailComposite.toLocalTime(timeFrom);
        LocalTime localTimeTo = AppointmentDetailComposite.toLocalTime(timeTo);
        LocalDateTime dateTimeFrom = LocalDateTime.of(localDateFrom, localTimeFrom);
        LocalDateTime dateTimeTo = LocalDateTime.of(localDateFrom, localTimeTo);
        if (source == this.txtDuration || source == this.txtTimeFrom) {
            LocalDateTime newTimeTo = dateTimeFrom.plusMinutes(duration);
            this.txtTimeTo.setSelection(Date.from(newTimeTo.atZone(ZoneId.systemDefault()).toInstant()));
        } else if (source == this.txtTimeTo) {
            long diff = ChronoUnit.MINUTES.between(dateTimeFrom, dateTimeTo);
            this.txtDuration.setSelection((int)diff);
        }
        this.setCompTimeToModel();
        this.dayBar.set();
    }

    public AppointmentDetailComposite(Composite parent, int style, IAppointment appointment) {
        super(parent, style);
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
        this.appointment = appointment;
        this.setLayout((Layout)new FillLayout());
        this.createContents(this);
    }

    private void createContents(Composite parent) {
        this.requireAppointment();
        this.initContainer(parent);
        this.createHeader(this.container);
        this.initSashForm(this.container);
        this.createContextComposite(this.container);
        this.dateArea = this.createUIDateAreaContents(this.getDateAreaGridData(), this.rightPane);
        this.createAppointmentsViewer(this.dateArea);
        this.createTimeSelector(this.container);
        this.createTypeAndReasonComposite(this.container);
        this.createEmailComposite(this.container);
        this.txtDateFrom = this.txtDateFromDrop;
        this.loadFromModel();
        this.refreshPatientModel();
        this.finalizeLayout();
    }

    private void requireAppointment() {
        Objects.requireNonNull(this.appointment, "Appointment cannot be null");
    }

    private void initContainer(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 6;
        gl.marginHeight = 6;
        gl.verticalSpacing = 6;
        this.container.setLayout((Layout)gl);
        this.container.setLayoutData((Object)new GridData(4, 4, false, false));
    }

    private void createHeader(Composite parent) {
        Composite header = new Composite(parent, 0);
        header.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        header.setLayout((Layout)new GridLayout(4, false));
        new Label(header, 0).setText(Messages.AppointmentDetailComposite_search);
        this.createPatientSearch(header);
        this.btnExpand = new Button(header, 2);
        this.btnExpand.setImage(Images.IMG_NEW.getImage());
        this.btnExpand.setToolTipText(Messages.AppointmentDetailComposite_expand_hover);
        this.btnExpand.setText(Messages.AppointmentDetailComposite_expand);
        this.btnExpand.addSelectionListener((SelectionListener)this.expandListener());
    }

    private void createPatientSearch(Composite parent) {
        this.txtPatSearch = new Text(parent, 640);
        this.txtPatSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.txtPatSearch.setMessage(Messages.AppointmentDetailComposite_name_birthday_patNr_or_free);
        this.txtPatSearch.setTextLimit(80);
        this.txtPatSearch.setData(this.reloadAsPatient(Optional.ofNullable(this.appointment.getContact())).orElse(null));
        final ControlDecoration deco = new ControlDecoration((Control)this.txtPatSearch, 16512);
        deco.setDescriptionText(Messages.AppointmentDetailComposite_search_contact_via_fields);
        deco.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        deco.show();
        this.txtPatSearch.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                deco.showHoverText(Messages.AppointmentDetailComposite_search_contact_via_fields_hover);
            }
        });
        PatientContentProposalProvider provider = new PatientContentProposalProvider();
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.txtPatSearch, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)provider, null, null);
        provider.configureContentProposalAdapter(adapter);
        adapter.addContentProposalListener(proposal -> {
            IdentifiableContentProposal prop = (IdentifiableContentProposal)proposal;
            this.txtPatSearch.setText(prop.getLabel());
            this.txtPatSearch.setData(prop.getIdentifiable());
            this.appointment.setSubjectOrPatient(((IPatient)prop.getIdentifiable()).getId());
            this.refreshPatientModel();
        });
        this.txtPatSearch.addModifyListener(e -> this.onPatientSearchModify());
    }

    private void onPatientSearchModify() {
        this.reloadContactLabel();
        String searchText = this.txtPatSearch.getText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            this.txtPatSearch.setData(null);
            this.tBem.setText("");
            if (this.appointmentsViewer != null) {
                this.appointmentsViewer.setInput(Collections.emptyList());
            }
        } else if (!this.txtDataIsMatchingContact()) {
            this.txtPatSearch.setData(null);
            this.tBem.setText("");
            if (this.appointmentsViewer != null) {
                this.appointmentsViewer.setInput(Collections.emptyList());
            }
        }
        this.emailComposite.updateEmailControlsStatus(this.getSelectedContact());
    }

    private SelectionAdapter expandListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppointmentDetailComposite.this.setExpanded(AppointmentDetailComposite.this.btnExpand.getSelection());
                AppointmentDetailComposite.this.getShell().pack();
            }
        };
    }

    private void initSashForm(Composite parent) {
        this.sash = new SashForm(parent, 256);
        this.sash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sash.setSashWidth(4);
        this.sash.setBackground(parent.getDisplay().getSystemColor(17));
        this.leftPane = new Composite((Composite)this.sash, 0);
        this.leftPane.setLayout((Layout)new GridLayout(1, false));
        this.rightPane = new Composite((Composite)this.sash, 0);
        this.rightPane.setLayout((Layout)new GridLayout(1, false));
    }

    private void createContextComposite(Composite parent) {
        this.compContext = new Composite(parent, 0);
        this.compContext.setLayout((Layout)new GridLayout(1, false));
        this.compContext.setLayoutData((Object)new GridData(4, 128, true, false));
        this.txtContact = new Link(this.leftPane, 64);
        this.txtContact.setBackground(this.leftPane.getBackground());
        this.txtContact.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtContact.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Object target = e.text;
                    if (target != null && ((String)target).startsWith("tel:")) {
                        String num = ((String)target).substring(4);
                        num = num.replaceAll("[^+\\d]", "");
                        num = num.replaceFirst("^00", "+");
                        target = "tel:" + num;
                    }
                    Desktop.getDesktop().browse(new URI((String)target));
                }
                catch (Exception ex) {
                    SWTHelper.alert((String)"Fehler", (String)("Kann Ruf-Aufruf nicht starten:\n" + ex.getMessage()));
                }
            }
        });
        Composite calWrapper = new Composite(this.leftPane, 0);
        calWrapper.setLayoutData((Object)new GridData(4, 4, true, true));
        calWrapper.setLayout((Layout)new FillLayout());
        this.pickerContext = new DateTime(calWrapper, 19456);
        this.pickerContext.setLayout((Layout)new GridLayout(1, false));
        this.pickerContext.setLayoutData((Object)new GridData(4, 128, true, true));
        LocalDate ld = this.appointment.getStartTime().toLocalDate();
        this.pickerContext.setDate(ld.getYear(), ld.getMonthValue() - 1, ld.getDayOfMonth());
        this.pickerContext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppointmentDetailComposite.this.onContextDateSelected();
            }
        });
    }

    private Date getDateFromCalendar() {
        int y = this.pickerContext.getYear();
        int mZeroBased = this.pickerContext.getMonth();
        int d = this.pickerContext.getDay();
        LocalDate ld = LocalDate.of(y, mZeroBased + 1, d);
        return Date.from(ld.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    private void onContextDateSelected() {
        this.txtDateFrom.setSelection(this.getDateFromCalendar());
        this.setCompTimeToModel();
        this.dayBar.setAppointment(this.appointment);
        this.dayBar.refresh();
    }

    private GridData getDateAreaGridData() {
        GridData gd = new GridData(4, 4, true, true, 2, 3);
        gd.verticalIndent = 15;
        return gd;
    }

    private void createAppointmentsViewer(Composite parent) {
        this.compContentMiddle = new Group(parent, 0);
        this.compContentMiddle.setText(Messages.AppointmentDetailComposite_planned_dates);
        this.compContentMiddle.setLayout((Layout)new GridLayout(2, false));
        this.compContentMiddle.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.appointmentsViewer = new TableViewer((Composite)this.compContentMiddle, 2820);
        GridData gdTable = new GridData(4, 4, true, true);
        this.appointmentsViewer.getControl().setLayoutData((Object)gdTable);
        this.appointmentsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.appointmentsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IAppointment)element).getLabel();
            }
        });
        this.appointmentsViewer.addSelectionChangedListener(event -> {
            Object sel = ((StructuredSelection)event.getSelection()).getFirstElement();
            if (sel instanceof IAppointment && !sel.equals(this.appointment)) {
                this.reloadAppointment((IAppointment)sel);
                ContextServiceHolder.get().getRootContext().setTyped(sel);
            }
        });
        Composite btnCol = new Composite((Composite)this.compContentMiddle, 0);
        btnCol.setLayout((Layout)new GridLayout(1, true));
        btnCol.setLayoutData((Object)new GridData(4, 128, false, false));
        this.createControlButtons(btnCol);
    }

    private void createControlButtons(Composite parent) {
        GridData gdButton = new GridData(4, 128, true, false);
        Button btnAdd = new Button(parent, 8);
        btnAdd.setText(Messages.AppointmentDetailComposite_insert);
        btnAdd.setLayoutData((Object)gdButton);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreModelServiceHolder.get().save((Identifiable)AppointmentDetailComposite.this.setToModel());
                AppointmentDetailComposite.this.cloneAndReloadAppointment();
                if (StringUtils.isEmpty((CharSequence)AppointmentDetailComposite.this.appointment.getSubjectOrPatient())) {
                    AppointmentDetailComposite.this.loadAppointmentsForPatient();
                }
                ContextServiceHolder.get().getRootContext().setTyped((Object)AppointmentDetailComposite.this.appointment);
            }
        });
        Button btnDelete = new Button(parent, 8);
        btnDelete.setText(Messages.AppointmentDetailComposite_delete);
        btnDelete.setLayoutData((Object)gdButton);
        btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AppointmentDetailComposite.this.appointment != null) {
                    AppointmentDetailComposite.this.selectionService.setSelection((Object)new StructuredSelection((Object)AppointmentDetailComposite.this.appointment));
                    ParameterizedCommand cmd = AppointmentDetailComposite.this.commandService.createCommand("ch.elexis.agenda.commands.delete", Collections.emptyMap());
                    AppointmentDetailComposite.this.handlerService.executeHandler(cmd);
                    AppointmentDetailComposite.this.loadAppointmentsForPatient();
                }
            }
        });
        Button btnPrint = new Button(parent, 8);
        btnPrint.setText(Messages.AppointmentDetailComposite_print);
        btnPrint.setLayoutData((Object)gdButton);
        btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppointmentDetailComposite.this.getAppointmentContact().ifPresent(contact -> AppointmentDetailComposite.this.printLabelsFor((IContact)contact));
            }
        });
    }

    private void printLabelsFor(IContact contact) {
        List appts = this.loadAppointments(contact).stream().sorted(Comparator.comparing(IPeriod::getStartTime).reversed()).collect(Collectors.toList());
        String ids = appts.stream().map(Identifiable::getId).collect(Collectors.joining(","));
        ParameterizedCommand cmd = this.commandService.createCommand("ch.elexis.agenda.commands.printAppointmentLabel", Collections.singletonMap("ch.elexis.agenda.param.appointmentids", ids));
        this.handlerService.executeHandler(cmd);
    }

    private void createTimeSelector(Composite parent) {
        this.compTimeSelektor = new Group(parent, 16);
        this.compTimeSelektor.setTextDirection(0x1000000);
        this.compTimeSelektor.setLayout((Layout)new GridLayout(1, false));
        this.compTimeSelektor.setLayoutData((Object)new GridData(4, 128, true, false, 4, 1));
        this.dayBar = new DayOverViewComposite(this.compTimeSelektor, this.appointment, this.txtTimeFrom, this.txtTimeTo, this.txtDuration);
        this.dayBar.setLayoutData(new GridData(4, 4, true, true, 1, 1));
    }

    private void createTypeAndReasonComposite(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 0).setText(Messages.TerminDialog_remarks);
        this.tBem = new Text(comp, 2634);
        this.tBem.setForeground(parent.getDisplay().getSystemColor(4));
        GridData gdBem = new GridData(4, 128, true, false, 3, 1);
        gdBem.heightHint = this.tBem.getLineHeight();
        this.tBem.setLayoutData((Object)gdBem);
        this.tBem.addModifyListener(e -> {
            int newHeight;
            int lineCount = this.tBem.getLineCount();
            gridData.heightHint = newHeight = Math.min(100, lineCount * this.tBem.getLineHeight() + 4);
            comp.layout(true, true);
            this.container.layout(true, true);
            this.getShell().layout(true, true);
        });
        new Label(comp, 0).setText(Messages.AppointmentDetailComposite_date_type_or_status);
        new Label(comp, 0).setText(Messages.AppointmentDetailComposite_reason);
        this.comboType = this.createCombo(comp, this.appointmentService.getTypes());
        this.comboType.addSelectionListener((SelectionListener)this.typeSelectionListener());
        this.comboType.addModifyListener(e -> this.handleComboTypeSelection());
        this.txtReason = new Text(comp, 2626);
        this.txtReason.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.comboStatus = this.createCombo(comp, this.appointmentService.getStates());
        this.chkTerminLinks = new Button(comp, 32);
        this.chkTerminLinks.setText(Messages.Appointment_TrminLinks);
        this.chkTerminLinks.setEnabled(false);
    }

    private Combo createCombo(Composite parent, List<String> items) {
        Combo combo = new Combo(parent, 12);
        combo.setItems(items.toArray(new String[0]));
        combo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        return combo;
    }

    private SelectionAdapter typeSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppointmentDetailComposite.this.handleComboTypeSelection();
            }
        };
    }

    private void createEmailComposite(Composite parent) {
        if (this.emailComposite == null) {
            this.emailComposite = new EmailComposite(parent, 0, this.getSelectedContact(), this.appointment);
            this.emailComposite.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        }
    }

    private void finalizeLayout() {
        this.sash.setWeights(SASH_WEIGHTS_EXPANDED);
        this.sash.setMaximizedControl((Control)this.rightPane);
        this.container.layout(true, true);
    }

    private Optional<IContact> reloadAsPatient(Optional<IContact> contact) {
        if (contact.isPresent() && contact.get().isPatient()) {
            return CoreModelServiceHolder.get().load(contact.get().getId(), IPatient.class);
        }
        return contact;
    }

    private void reloadAppointment(IAppointment appointment) {
        this.appointment = appointment;
        this.loadFromModel();
        this.refreshPatientModel();
    }

    public void setExpanded(boolean expand) {
        this.btnExpand.setSelection(expand);
        this.doExpand(expand);
    }

    public void setShowAllDay(boolean showAllDay) {
        GridData gd = (GridData)this.btnIsAllDay.getLayoutData();
        gd.exclude = !showAllDay;
        this.btnIsAllDay.setVisible(showAllDay);
        this.btnIsAllDay.getParent().layout(true, true);
    }

    public void setScheduleChangeMode(boolean mode) {
        this.scheduleChangeMode = mode;
    }

    private void refreshPatientModel() {
        this.loadAppointmentsForPatient();
        if (this.dayBar != null) {
            this.dayBar.setAppointment(this.appointment);
            this.dayBar.refresh();
        }
        this.reloadContactLabel();
        if (StringUtils.isBlank((CharSequence)this.txtPatSearch.getText())) {
            this.tBem.setText("");
        } else {
            IContact c = this.getSelectedContact();
            if (c != null && c.isPatient()) {
                IPatient p = CoreModelServiceHolder.get().load(c.getId(), IPatient.class).orElse(null);
                if (p != null) {
                    String comment = p.getComment() != null ? p.getComment() : "";
                    this.tBem.setText(comment);
                } else {
                    this.tBem.setText("");
                }
            } else {
                this.tBem.setText("");
            }
        }
        this.emailComposite.updateEmailControlsStatus(this.getSelectedContact());
    }

    private void reloadContactLabel() {
        Optional<IContact> c = this.reloadAsPatient(this.getAppointmentContact());
        String currentSearchText = this.txtPatSearch.getText();
        if (c.isPresent() && c.get().getLabel().equals(currentSearchText)) {
            StringBuilder b = new StringBuilder();
            b.append(c.get().getLabel()).append("\n").append("\n");
            Optional.ofNullable(c.get().getMobile()).filter(s -> !s.isEmpty()).ifPresent(m -> {
                StringBuilder stringBuilder2 = b.append("Mobil:      ").append("<a href=\"").append(AppointmentDetailComposite.toTelHref(m)).append("\">").append((String)m).append("</a>\n");
            });
            Optional.ofNullable(c.get().getPhone1()).filter(s -> !s.isEmpty()).ifPresent(p1 -> {
                StringBuilder stringBuilder2 = b.append("Telefon 1: ").append("<a href=\"").append(AppointmentDetailComposite.toTelHref(p1)).append("\">").append((String)p1).append("</a>\n");
            });
            Optional.ofNullable(c.get().getPhone2()).filter(s -> !s.isEmpty()).ifPresent(p2 -> {
                StringBuilder stringBuilder2 = b.append("Telefon 2: ").append("<a href=\"").append(AppointmentDetailComposite.toTelHref(p2)).append("\">").append((String)p2).append("</a>\n");
            });
            this.txtContact.setText(b.toString());
        } else if (!c.isPresent() && StringUtils.isBlank((CharSequence)currentSearchText)) {
            this.txtContact.setText(Messages.AppointmentDetailComposite_no_patient_selected);
        } else {
            this.txtContact.setText(Messages.AppointmentDetailComposite_freetext + currentSearchText);
        }
        this.container.layout(true, true);
        this.getShell().layout(true, true);
    }

    private static String toTelHref(String raw) {
        if (StringUtils.isBlank((CharSequence)raw)) {
            return null;
        }
        String normalized = raw.replaceAll("[^+\\d]", "");
        normalized = normalized.replaceFirst("^00", "+");
        return "tel:" + normalized;
    }

    private Optional<IContact> getAppointmentContact() {
        return Optional.ofNullable(this.appointment.getContact());
    }

    private List<IAppointment> loadAppointments(IContact contact) {
        if (contact != null) {
            IQuery query = CoreModelServiceHolder.get().getQuery(IAppointment.class);
            query.and("patId", IQuery.COMPARATOR.EQUALS, (Object)contact.getId());
            query.and("tag", IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)LocalDate.now());
            return query.execute();
        }
        return Collections.emptyList();
    }

    private void loadAppointmentsForPatient() {
        this.getAppointmentContact().ifPresent(contact -> {
            List input = this.loadAppointments((IContact)contact).stream().sorted(Comparator.comparing(IPeriod::getStartTime).reversed()).collect(Collectors.toList());
            this.appointmentsViewer.setInput(input);
            if (this.appointment != null && !this.appointment.equals(this.appointmentsViewer.getStructuredSelection().getFirstElement())) {
                this.appointmentsViewer.setSelection((ISelection)new StructuredSelection((Object)this.appointment));
            }
            this.appointmentsViewer.refresh();
        });
    }

    private void applyPreferredDuration() {
        String type;
        Map pref = this.appointmentService.getPreferredDurations(this.comboArea.getText());
        Integer d = (Integer)pref.get(type = this.comboType.getText());
        if (d != null) {
            this.txtDuration.setSelection(d.intValue());
            this.updateDateTimeFields(this.txtDuration);
        }
    }

    private Composite createUIDateAreaContents(GridData gd, Composite container) {
        GridData topOnly = new GridData(4, 4, true, true);
        topOnly.horizontalSpan = gd != null && gd.horizontalSpan > 0 ? gd.horizontalSpan : 2;
        topOnly.verticalSpan = 1;
        topOnly.verticalIndent = 0;
        Composite compDateTime = new Composite(container, 0);
        compDateTime.setLayoutData((Object)topOnly);
        GridLayout dateGL = new GridLayout(3, false);
        dateGL.marginHeight = 0;
        dateGL.marginWidth = 0;
        dateGL.verticalSpacing = 3;
        dateGL.horizontalSpacing = 6;
        compDateTime.setLayout((Layout)dateGL);
        this.lblDateFrom = new Label(compDateTime, 0);
        this.lblDateFrom.setText(Messages.AppointmentDetailComposite_tag);
        this.txtDateFromDrop = new CDateTime(compDateTime, 2098179);
        this.txtDateFromDrop.setPattern("EEE, dd.MM.yyyy ");
        this.txtDateFromDrop.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.txtDateFromDrop.addSelectionListener((SelectionListener)this.dateTimeSelectionAdapter);
        this.txtDateFromDrop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppointmentDetailComposite.this.setCompTimeToModel();
                AppointmentDetailComposite.this.dayBar.setAppointment(AppointmentDetailComposite.this.appointment);
                AppointmentDetailComposite.this.dayBar.refresh();
            }
        });
        Composite compTime = new Composite(compDateTime, 0);
        GridLayout gl = new GridLayout(10, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 2;
        gl.horizontalSpacing = 6;
        compTime.setLayout((Layout)gl);
        compTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblTimeFrom = new Label(compTime, 0);
        lblTimeFrom.setText(Messages.AppointmentDetailComposite_starting_from);
        this.txtTimeFrom = CoreUtil.isLinux() ? new CDateTime(compTime, 0x800001) : new CDateTime(compTime, 75497473);
        this.txtTimeFrom.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.txtTimeFrom.addSelectionListener((SelectionListener)this.dateTimeSelectionAdapter);
        Label lblDuration = new Label(compTime, 0);
        lblDuration.setText(Messages.AppointmentDetailComposite_duration);
        this.txtDuration = new Spinner(compTime, 2048);
        this.txtDuration.setValues(0, 0, 1440, 0, 5, 10);
        this.txtDuration.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.txtDuration.addSelectionListener((SelectionListener)this.dateTimeSelectionAdapter);
        Label lblTimeTo = new Label(compTime, 0);
        lblTimeTo.setText(Messages.AppointmentDetailComposite_until);
        this.txtTimeTo = CoreUtil.isLinux() ? new CDateTime(compTime, 0x800001) : new CDateTime(compTime, 75497473);
        this.txtTimeTo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.txtTimeTo.addSelectionListener((SelectionListener)this.dateTimeSelectionAdapter);
        this.btnIsAllDay = new Button(compTime, 32);
        this.btnIsAllDay.setText(Messages.AppointmentDetailComposite_isAllDay);
        this.btnIsAllDay.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.btnIsAllDay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = !AppointmentDetailComposite.this.btnIsAllDay.getSelection();
                AppointmentDetailComposite.this.txtTimeFrom.setEnabled(enabled);
                AppointmentDetailComposite.this.txtDuration.setEnabled(enabled);
                AppointmentDetailComposite.this.txtTimeTo.setEnabled(enabled);
            }
        });
        this.chkLocked = new Button(compTime, 32);
        this.chkLocked.setText(Messages.Agenda_Appointement_Locked);
        this.chkLocked.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.chkLocked.setSelection(this.appointment.isLocked());
        this.chkLocked.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppointmentDetailComposite.this.appointment.setLocked(AppointmentDetailComposite.this.chkLocked.getSelection());
                AppointmentDetailComposite.this.changeLocked = true;
            }
        });
        Composite compArea = new Composite(compTime, 0);
        GridLayout glArea = new GridLayout(4, false);
        glArea.marginHeight = 0;
        glArea.marginWidth = 0;
        glArea.horizontalSpacing = 2;
        glArea.marginLeft = 0;
        compArea.setLayout((Layout)glArea);
        GridData gdCompArea = new GridData(4, 0x1000000, true, false);
        gdCompArea.horizontalSpan = 1;
        compArea.setLayoutData((Object)gdCompArea);
        Label lblArea = new Label(compArea, 0);
        lblArea.setText(Messages.AppointmentDetailComposite_range);
        this.comboArea = new Combo(compArea, 12);
        this.comboArea.setItems(this.configService.get("agenda/bereiche", "Praxis").split(","));
        this.comboArea.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.comboArea.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AppointmentDetailComposite.this.comboArea.getText().equals(AppointmentDetailComposite.this.appointment.getSchedule())) {
                    AppointmentDetailComposite.this.appointment.setSchedule(AppointmentDetailComposite.this.comboArea.getText());
                    AppointmentDetailComposite.this.dayBar.setAppointment(AppointmentDetailComposite.this.appointment);
                    AppointmentDetailComposite.this.dayBar.refresh();
                    AppointmentDetailComposite.this.applyPreferredDuration();
                    if (AppointmentDetailComposite.this.scheduleChangeMode) {
                        Activator.getDefault().setActResource(AppointmentDetailComposite.this.comboArea.getText());
                        BereichSelectionHandler.updateListeners();
                        ContextServiceHolder.get().postEvent("info/elexis/model/reload", IAppointment.class);
                    }
                }
            }
        });
        return compDateTime;
    }

    private void loadCompTimeFromModel() {
        Date appointmentStartDate = Date.from(ZonedDateTime.of(this.appointment.getStartTime(), ZoneId.systemDefault()).toInstant());
        this.txtDateFrom.setSelection(appointmentStartDate);
        LocalDate ld = this.appointment.getStartTime().toLocalDate();
        this.pickerContext.setDate(ld.getYear(), ld.getMonthValue() - 1, ld.getDayOfMonth());
        this.txtTimeFrom.setSelection(appointmentStartDate);
        this.btnIsAllDay.setSelection(this.appointment.isAllDay());
        this.txtTimeFrom.setEnabled(!this.appointment.isAllDay());
        this.txtDuration.setEnabled(!this.appointment.isAllDay());
        this.txtTimeTo.setEnabled(!this.appointment.isAllDay());
        if (!this.appointment.isAllDay()) {
            Date appointmentEndDate = Date.from(ZonedDateTime.of(this.appointment.getEndTime(), ZoneId.systemDefault()).toInstant());
            this.txtTimeTo.setSelection(appointmentEndDate);
            this.txtDuration.setSelection(this.appointment.getDurationMinutes().intValue());
        }
    }

    private void loadFromModel() {
        this.comboStatus.setText(this.appointment.getState());
        this.comboType.setText(this.appointment.getType());
        this.chkLocked.setSelection(this.appointment.isLocked());
        this.comboArea.setText(this.appointment.getSchedule());
        this.txtReason.setText(this.appointment.getReason());
        if (this.appointment.getContact() == null) {
            String sop = this.appointment.getSubjectOrPatient();
            if (StringUtils.isNotBlank((CharSequence)sop)) {
                this.txtPatSearch.setData(null);
                this.txtPatSearch.setText(sop);
                this.tBem.setText("");
            } else {
                this.txtPatSearch.setData(null);
                this.txtPatSearch.setText("");
                this.tBem.setText("");
            }
        } else {
            IContact pat = this.reloadAsPatient(Optional.ofNullable(this.appointment.getContact())).get();
            this.txtPatSearch.setData((Object)pat);
            this.txtPatSearch.setText(pat.getLabel());
            this.tBem.setText(pat.getComment());
        }
        this.loadCompTimeFromModel();
    }

    private void setCompTimeToModel() {
        Date dateFrom = this.txtDateFrom.getSelection();
        Date timeFrom = this.txtTimeFrom.getSelection();
        LocalDateTime dateTimeFrom = LocalDateTime.of(dateFrom.toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), timeFrom.toInstant().atZone(ZoneId.systemDefault()).toLocalTime());
        if (this.btnIsAllDay.getSelection()) {
            this.appointment.setStartTime(dateTimeFrom.toLocalDate().atStartOfDay());
            this.appointment.setEndTime(null);
        } else {
            Date timeTo = this.txtTimeTo.getSelection();
            LocalDateTime dateTimeTo = LocalDateTime.of(dateFrom.toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), timeTo.toInstant().atZone(ZoneId.systemDefault()).toLocalTime());
            this.appointment.setStartTime(dateTimeFrom);
            this.appointment.setEndTime(dateTimeTo);
        }
    }

    public IAppointment setToModel() {
        this.setCompTimeToModel();
        this.appointment.setState(this.comboStatus.getText());
        this.appointment.setType(this.comboType.getText());
        this.appointment.setSchedule(this.comboArea.getText());
        this.appointment.setCreatedBy(((IUser)ContextServiceHolder.get().getActiveUser().get()).getLabel());
        if (this.appointment.getCreated() == null || this.appointment.getCreated().isEmpty()) {
            this.appointment.setCreated(AppointmentDetailComposite.createTimeStamp());
        }
        this.appointment.setLastEdit(AppointmentDetailComposite.createTimeStamp());
        this.appointment.setReason(this.txtReason.getText());
        if (this.txtDataIsMatchingContact()) {
            this.appointment.setSubjectOrPatient(((IContact)this.txtPatSearch.getData()).getId());
        } else if (StringUtils.isNotBlank((CharSequence)this.txtPatSearch.getText())) {
            this.appointment.setSubjectOrPatient(this.txtPatSearch.getText());
        } else {
            this.appointment.setSubjectOrPatient(null);
        }
        this.createKombiTermineIfApplicable();
        return this.appointment;
    }

    private void handleComboTypeSelection() {
        String selectedType = this.comboType.getText();
        List kombiTermineList = ConfigServiceHolder.get().getAsList("agenda/kombitermine/" + selectedType);
        if (!StringUtils.isBlank((CharSequence)selectedType) && !kombiTermineList.isEmpty()) {
            this.chkTerminLinks.setEnabled(true);
        } else {
            this.chkTerminLinks.setEnabled(false);
            this.chkTerminLinks.setSelection(false);
        }
        this.applyPreferredDuration();
    }

    private void createKombiTermineIfApplicable() {
        if (this.chkTerminLinks.getSelection()) {
            return;
        }
        String selectedType = this.comboType.getText();
        List kombiTermineList = ConfigServiceHolder.get().getAsList("agenda/kombitermine/" + selectedType);
        if (kombiTermineList.isEmpty()) {
            return;
        }
        if (!AppointmentExtensionHandler.getLinkedAppointments(this.appointment).isEmpty()) {
            return;
        }
        AppointmentExtensionHandler.setMainAppointmentId(this.appointment, this.appointment.getId());
        ArrayList<String> kombiTerminIds = new ArrayList<String>();
        for (String kombiTermin : kombiTermineList) {
            kombiTermin = kombiTermin.replaceAll("[{}]", "");
            String[] elements = kombiTermin.split(";");
            IAppointment newAppointment = (IAppointment)CoreModelServiceHolder.get().create(IAppointment.class);
            newAppointment.setState(this.appointment.getState());
            newAppointment.setType(elements[2]);
            newAppointment.setSchedule(elements[1]);
            newAppointment.setCreatedBy(this.appointment.getCreatedBy());
            newAppointment.setCreated(AppointmentDetailComposite.createTimeStamp());
            newAppointment.setLastEdit(AppointmentDetailComposite.createTimeStamp());
            newAppointment.setReason(elements[0]);
            if (this.txtDataIsMatchingContact()) {
                newAppointment.setSubjectOrPatient(((IContact)this.txtPatSearch.getData()).getId());
            } else if (StringUtils.isNotBlank((CharSequence)this.txtPatSearch.getText())) {
                newAppointment.setSubjectOrPatient(this.txtPatSearch.getText());
            }
            LocalDateTime startTime = this.appointment.getStartTime();
            int offset = Integer.parseInt(elements[4]);
            startTime = ((String)Messages.AddCombiTerminDialogBefore).equalsIgnoreCase(elements[3]) ? startTime.minusMinutes(offset) : startTime.plusMinutes(offset);
            newAppointment.setStartTime(startTime);
            newAppointment.setEndTime(startTime.plusMinutes(Integer.parseInt(elements[5])));
            kombiTerminIds.add(newAppointment.getId());
            AppointmentExtensionHandler.setMainAppointmentId(newAppointment, this.appointment.getId());
            AppointmentExtensionHandler.addLinkedAppointmentId(newAppointment, newAppointment.getId());
            CoreModelServiceHolder.get().save((Identifiable)newAppointment);
        }
        AppointmentExtensionHandler.addMultipleLinkedAppointments(this.appointment, kombiTerminIds);
        CoreModelServiceHolder.get().save((Identifiable)this.appointment);
    }

    private boolean txtDataIsMatchingContact() {
        return this.txtPatSearch.getData() instanceof IContact && ((IContact)this.txtPatSearch.getData()).getLabel().equals(this.txtPatSearch.getText());
    }

    private void cloneAndReloadAppointment() {
        IAppointment newAppointment = (IAppointment)CoreModelServiceHolder.get().create(IAppointment.class);
        newAppointment.setSubjectOrPatient(this.appointment.getContact() != null ? this.appointment.getContact().getId() : this.appointment.getSubjectOrPatient());
        this.appointment = newAppointment;
        this.setToModel();
        this.reloadAppointment(this.appointment);
    }

    private void doExpand(boolean expand) {
        GridData gd = (GridData)this.sash.getLayoutData();
        if (expand) {
            this.setAllDetailCompositesVisible(true);
            this.rightPane.layout(true, true);
            this.sash.setMaximizedControl(null);
            this.sash.setWeights(SASH_WEIGHTS_EXPANDED);
            gd.verticalAlignment = 4;
            gd.grabExcessVerticalSpace = true;
            gd.heightHint = -1;
            gd.widthHint = -1;
        } else {
            this.setAllDetailCompositesVisible(false);
            this.rightPane.layout(true, true);
            this.sash.setMaximizedControl((Control)this.rightPane);
            gd.verticalAlignment = 128;
            gd.grabExcessVerticalSpace = false;
            gd.widthHint = this.rightPane.computeSize((int)-1, (int)-1, (boolean)true).x;
            gd.heightHint = this.rightPane.computeSize((int)-1, (int)-1, (boolean)true).y;
        }
        this.container.layout(true, true);
        this.getShell().layout(true, true);
        this.dayBar.refresh();
    }

    private void setAllDetailCompositesVisible(boolean visible) {
        this.setCompositeVisible(this.compContext, visible);
        this.setCompositeVisible((Composite)this.compContentMiddle, visible);
        this.setCompositeVisible((Composite)this.compTimeSelektor, visible);
    }

    private void setCompositeVisible(Composite c, boolean visible) {
        GridData data = (GridData)c.getLayoutData();
        data.exclude = !visible;
        c.setVisible(visible);
    }

    public IContact getSelectedContact() {
        Object data = this.txtPatSearch.getData();
        if (data instanceof IContact) {
            return (IContact)data;
        }
        return null;
    }

    public boolean getEmailCheckboxStatus() {
        return this.emailComposite.isCheckboxChecked();
    }

    public EmailComposite.EmailDetails getEmailDeteils() {
        return this.emailComposite.extractEmailDetails();
    }

    public static String createTimeStamp() {
        return Integer.toString(TimeTool.getTimeInSeconds() / 60);
    }

    public void setCollisionErrorLevel(CollisionErrorLevel level, Consumer<Boolean> callback) {
        this.dayBar.setCollisionErrorLevel(level, callback);
    }

    private class PatientContentProposalProvider
    extends AsyncContentProposalProvider<IPatient> {
        PatientContentProposalProvider() {
            super(new String[]{"description1", "description2", "dob", "code"});
        }

        public IQuery<IPatient> createBaseQuery() {
            return CoreModelServiceHolder.get().getQuery(IPatient.class);
        }

        protected boolean isPatientQuery() {
            return true;
        }

        public Text getWidget() {
            return AppointmentDetailComposite.this.txtPatSearch;
        }
    }
}

