/*
 * Decompiled with CFR 0.152.
 */
package ch.swissmedicalsuite;

import ch.elexis.core.ui.util.Log;
import ch.swissmedicalsuite.HCardAPI;
import com.sun.jna.ptr.PointerByReference;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HCardBrowser {
    private final String gln;
    private final String browserUrl;
    static boolean initApi = false;
    static String glnOld;
    protected static Log log;

    static {
        log = Log.get((String)"HCardBrowser");
    }

    public HCardBrowser(String gln, String browserUrl) {
        if (!initApi) {
            initApi = true;
            PointerByReference pByReference = new PointerByReference();
            HCardAPI.INSTANCE.initApi("hCard-OEM-Test", false, pByReference);
            System.setProperty("https.proxyHost", "localhost");
        }
        this.browserUrl = browserUrl;
        this.gln = gln;
        log.log("hcardbrowser initiated " + browserUrl + " " + gln, 5);
    }

    public void setProxyPort() {
        if (glnOld == null || !glnOld.equals(this.gln)) {
            int port = HCardAPI.INSTANCE.getUserProxyPort(this.gln);
            log.log("getting proxy port for gln:" + this.gln + " port " + port, 5);
            System.setProperty("https.proxyPort", "" + port);
            glnOld = this.gln;
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            catch (NoSuchAlgorithmException e1) {
                e1.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
        }
    }

    private String getPageParam(String page) {
        try {
            return "?page=" + URLEncoder.encode(page, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public int setTerminvereinbarung() {
        log.log("startSmsBroser, Terminvereinbarung:" + this.gln, 5);
        String url = this.browserUrl + this.getPageParam("AppBookingWizzard");
        return HCardAPI.INSTANCE.startSmsBrowser(this.gln, url, 0);
    }

    public int setHome() {
        log.log("startSmsBroser, setHome :" + this.gln, 5);
        String url = this.browserUrl + this.getPageParam("MainWelcome");
        return HCardAPI.INSTANCE.startSmsBrowser(this.gln, url, 0);
    }

    public int setHospitalReferral() {
        log.log("startSmsBroser, setHospitalReferral: " + this.gln, 5);
        String url = this.browserUrl + this.getPageParam("HospitalApplicationsOverview");
        return HCardAPI.INSTANCE.startSmsBrowser(this.gln, url, 0);
    }

    public int setMyPatient() {
        log.log("startSmsBroser, setMyPatient: " + this.gln, 5);
        String url = this.browserUrl + this.getPageParam("MyPatient");
        return HCardAPI.INSTANCE.startSmsBrowser(this.gln, url, 0);
    }

    public int setAppointment(String terminId) {
        log.log("startSmsBroser, setAppointment: " + this.gln, 5);
        String url = this.browserUrl + this.getPageParam("DocCalendar");
        if (terminId != null) {
            String id = terminId;
            if (id.endsWith("2")) {
                id = id.substring(0, id.length() - 1);
            }
            try {
                url = url + "&id=" + URLEncoder.encode(id, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return HCardAPI.INSTANCE.startSmsBrowser(this.gln, url, 0);
    }
}

