/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.cdach;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.dgc.VMID;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.hl7.v3.AD;
import org.hl7.v3.ADXP;
import org.hl7.v3.AdxpCity;
import org.hl7.v3.AdxpPostalCode;
import org.hl7.v3.AdxpStreetAddressLine;
import org.hl7.v3.CD;
import org.hl7.v3.CE;
import org.hl7.v3.CS;
import org.hl7.v3.ENXP;
import org.hl7.v3.EnFamily;
import org.hl7.v3.EnGiven;
import org.hl7.v3.EnPrefix;
import org.hl7.v3.II;
import org.hl7.v3.ON;
import org.hl7.v3.PN;
import org.hl7.v3.POCDMT000040AssignedAuthor;
import org.hl7.v3.POCDMT000040AssignedCustodian;
import org.hl7.v3.POCDMT000040Author;
import org.hl7.v3.POCDMT000040AuthoringDevice;
import org.hl7.v3.POCDMT000040ClinicalDocument;
import org.hl7.v3.POCDMT000040Component2;
import org.hl7.v3.POCDMT000040Component3;
import org.hl7.v3.POCDMT000040Custodian;
import org.hl7.v3.POCDMT000040CustodianOrganization;
import org.hl7.v3.POCDMT000040InformationRecipient;
import org.hl7.v3.POCDMT000040InfrastructureRootTypeId;
import org.hl7.v3.POCDMT000040IntendedRecipient;
import org.hl7.v3.POCDMT000040Organization;
import org.hl7.v3.POCDMT000040Patient;
import org.hl7.v3.POCDMT000040PatientRole;
import org.hl7.v3.POCDMT000040Person;
import org.hl7.v3.POCDMT000040RecordTarget;
import org.hl7.v3.POCDMT000040Section;
import org.hl7.v3.POCDMT000040StructuredBody;
import org.hl7.v3.SC;
import org.hl7.v3.ST;
import org.hl7.v3.StrucDocBr;
import org.hl7.v3.StrucDocLinkHtml;
import org.hl7.v3.StrucDocText;
import org.hl7.v3.TEL;
import org.hl7.v3.TS;
import org.hl7.v3.XInformationRecipient;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocboxCDA {
    private static final String oid_hl7 = "2.16.756.5.30.1.1.1.1";
    private static final String oid_loinc = "2.16.840.1.113883.6.1";
    private static final String oid_ean = "1.3.88";
    private static final String oid_docbox_old = "2.25.327919736312109525688528068157180855579";
    private static final String oid_docbox = "2.16.756.5.30.1.105";
    static Marshaller marshaller = null;
    static Unmarshaller unmarshaller = null;
    public static final String oid_ahv13 = "2.16.756.5.32";
    private List<POCDMT000040Component3> listComponent = new ArrayList<POCDMT000040Component3>();

    public String getOidUserDocboxId() {
        return "2.16.756.5.30.1.105.1.1";
    }

    public static String getOidPraxisSoftwareId() {
        return "2.16.756.5.30.1.105.1.3";
    }

    public static String getOidPraxisSoftwareIdOld() {
        return "2.25.327919736312109525688528068157180855579.1.3";
    }

    public static String getOidPidHospital() {
        return "2.16.756.5.30.1.105.1.4.1";
    }

    public static String getOidFidHospital() {
        return "2.16.756.5.30.1.105.1.4.2";
    }

    public static String getOidDoctorHospitalId() {
        return "2.16.756.5.30.1.105.1.4.3";
    }

    public static String getOidOrganiaztionId() {
        return "2.16.756.5.30.1.105.1.2";
    }

    public static String getOidDepartmentId() {
        return "2.16.756.5.30.1.105.1.2.1";
    }

    public static String getOidDocboxLeistungId() {
        return "2.16.756.5.30.1.105.2.1";
    }

    public static String getOidDocboxSectionId() {
        return "2.16.756.5.30.1.105.2.2";
    }

    public void clearCdaBody() {
        this.listComponent.clear();
    }

    public POCDMT000040Author getAuthor(String prefix, String given, String family, String mobile, String phone, String phoneBusiness, String email, String ean, String docboxId, String userHospitalId) {
        ArrayList<TEL> telecomList;
        ENXP name;
        POCDMT000040Author author = new POCDMT000040Author();
        author.setTime(new TS());
        POCDMT000040AssignedAuthor assignedAuthor = new POCDMT000040AssignedAuthor();
        POCDMT000040Person person = new POCDMT000040Person();
        assignedAuthor.setAssignedPerson(person);
        ArrayList<ENXP> nameList = new ArrayList<ENXP>();
        if (prefix != null && !prefix.equals("")) {
            name = new EnPrefix();
            name.setContent(prefix);
            nameList.add(name);
        }
        if (given != null && !given.equals("")) {
            name = new EnGiven();
            name.setContent(given);
            nameList.add(name);
        }
        if (family != null && !family.equals("")) {
            name = new EnFamily();
            name.setContent(family);
            nameList.add(name);
        }
        if (nameList.size() > 0) {
            PN pn = new PN();
            pn.getContent().addAll(nameList);
            person.getName().add(pn);
        }
        if ((telecomList = this.getTelecomList(mobile, phone, phoneBusiness, email)).size() > 0) {
            assignedAuthor.getTelecom().addAll(telecomList);
        }
        author.setAssignedAuthor(assignedAuthor);
        if (ean != null && !ean.equals("")) {
            author.getAssignedAuthor().getId().add(this.getII(ean, oid_ean));
        }
        if (docboxId != null && !docboxId.equals("")) {
            author.getAssignedAuthor().getId().add(this.getII(docboxId, this.getOidUserDocboxId()));
        }
        if (userHospitalId != null && !userHospitalId.equals("")) {
            author.getAssignedAuthor().getId().add(this.getII(userHospitalId, DocboxCDA.getOidDoctorHospitalId()));
        }
        return author;
    }

    public POCDMT000040Custodian getCustodian(String name, AD addr, String docboxId, String ean, String hospitalId, String departmentId) {
        POCDMT000040Custodian custodian = new POCDMT000040Custodian();
        POCDMT000040AssignedCustodian assignedCustodian = new POCDMT000040AssignedCustodian();
        custodian.setAssignedCustodian(assignedCustodian);
        POCDMT000040CustodianOrganization representedCustodianOrganization = new POCDMT000040CustodianOrganization();
        if (name != null) {
            ON on = new ON();
            on.getContent().add((Serializable)((Object)name));
            representedCustodianOrganization.setName(on);
        }
        assignedCustodian.setRepresentedCustodianOrganization(representedCustodianOrganization);
        if (addr != null) {
            custodian.getAssignedCustodian().getRepresentedCustodianOrganization().setAddr(addr);
        }
        if (ean != null) {
            representedCustodianOrganization.getId().add(this.getII(ean, oid_ean));
        }
        if (docboxId != null) {
            representedCustodianOrganization.getId().add(this.getII(docboxId, this.getOidUserDocboxId()));
        }
        if (hospitalId != null) {
            representedCustodianOrganization.getId().add(this.getII(hospitalId, DocboxCDA.getOidOrganiaztionId()));
        }
        if (departmentId != null) {
            representedCustodianOrganization.getId().add(this.getII(departmentId, DocboxCDA.getOidDepartmentId()));
        }
        return custodian;
    }

    public void addComponentToBody(String title, String text, String docboxSectionCode) {
        POCDMT000040Component3 component = this.getComponent(this.stripNonValidXMLCharacters(title), null, this.stripNonValidXMLCharacters(docboxSectionCode));
        component.getSection().setText(this.getStrucDocTextWithBreaks(text));
        this.listComponent.add(component);
    }

    public void addComponentToBody(String title, Boolean value, String docboxSectionCode) {
        String text = "unbekannt";
        if (value != null && value.booleanValue()) {
            text = "ja";
        }
        if (value != null && !value.booleanValue()) {
            text = "nein";
        }
        this.listComponent.add(this.getComponent(title, text, docboxSectionCode));
    }

    public void addAttachmentsDescriptionToBody(Vector<String> attachments) {
        StrucDocText strucDocText = new StrucDocText();
        for (String attachment : attachments) {
            StrucDocLinkHtml strucDocLinkHtml = new StrucDocLinkHtml();
            strucDocLinkHtml.setHref(attachment);
            strucDocLinkHtml.getContent().add((Serializable)((Object)attachment));
            strucDocText.getContent().add(strucDocLinkHtml);
            strucDocText.getContent().add(new StrucDocBr());
        }
        POCDMT000040Component3 component = this.getComponent(null, null, "ATT");
        component.getSection().setText(strucDocText);
        this.listComponent.add(component);
    }

    private POCDMT000040Component3 getComponent(String title, String text, String docboxSectionCode, String docboxSectionId) {
        POCDMT000040Component3 component = new POCDMT000040Component3();
        POCDMT000040Section section = new POCDMT000040Section();
        if (docboxSectionCode != null) {
            CD cd = new CD();
            cd.setCode(docboxSectionCode);
            cd.setCodeSystem(docboxSectionId);
            CE ce = new CE();
            ce.getNullFlavor().add("NA");
            ce.getTranslation().add(cd);
            section.setCode(ce);
        }
        if (title != null) {
            ST st = new ST();
            st.setContent(title);
            section.setTitle(st);
        }
        if (text != null) {
            StrucDocText strucDocText = new StrucDocText();
            strucDocText.getContent().add((Serializable)((Object)text));
            section.setText(strucDocText);
        }
        component.setSection(section);
        return component;
    }

    private POCDMT000040Component3 getComponent(String title, String text, String docboxSectionCode) {
        return this.getComponent(title, text, docboxSectionCode, DocboxCDA.getOidDocboxSectionId());
    }

    public AD getAddress(String streetAddrLine, String streetAddrLine2, String postalCode, String city, String use) {
        ADXP item;
        AD addr = new AD();
        addr.getUse().add(use);
        if (streetAddrLine != null && !streetAddrLine.equals("")) {
            item = new AdxpStreetAddressLine();
            item.setContent(streetAddrLine);
            addr.getContent().add(item);
        }
        if (streetAddrLine2 != null && !streetAddrLine2.equals("")) {
            item = new AdxpStreetAddressLine();
            item.setContent(streetAddrLine2);
            addr.getContent().add(item);
        }
        if (postalCode != null && !postalCode.equals("")) {
            item = new AdxpPostalCode();
            item.setContent(postalCode);
            addr.getContent().add(item);
        }
        if (city != null && !city.equals("")) {
            item = new AdxpCity();
            item.setContent(city);
            addr.getContent().add(item);
        }
        return addr;
    }

    public ArrayList<TEL> getTelecomList(String mobile, String phone, String phoneBusiness, String email) {
        TEL tel;
        ArrayList<TEL> telecomList = new ArrayList<TEL>();
        if (mobile != null && !mobile.equals("")) {
            tel = new TEL();
            tel.setValue("tel:" + mobile);
            telecomList.add(tel);
        }
        if (phone != null && !phone.equals("")) {
            tel = new TEL();
            tel.getUse().add("HP");
            tel.setValue("tel:" + phone);
            telecomList.add(tel);
        }
        if (phoneBusiness != null && !phoneBusiness.equals("")) {
            tel = new TEL();
            tel.getUse().add("WP");
            tel.setValue("tel:" + phoneBusiness);
            telecomList.add(tel);
        }
        if (email != null && !email.equals("")) {
            tel = new TEL();
            tel.setValue("mailto:" + email);
            telecomList.add(tel);
        }
        return telecomList;
    }

    public POCDMT000040RecordTarget getRecordTarget(String idpatient, String ahv13, String streetAddrLine, String postalCode, String city, String phone, String phoneBusiness, String mobile, String email, String given, String family, boolean isFemale, boolean isMale, boolean isGenderUnknown, Date birthDate) {
        ENXP name;
        POCDMT000040RecordTarget recordTarget = new POCDMT000040RecordTarget();
        POCDMT000040PatientRole patientRole = new POCDMT000040PatientRole();
        recordTarget.setPatientRole(patientRole);
        if (idpatient != null && !idpatient.equals("")) {
            patientRole.getId().add(this.getII(idpatient, DocboxCDA.getOidPraxisSoftwareId()));
        }
        if (ahv13 != null && !ahv13.equals("")) {
            patientRole.getId().add(this.getII(ahv13, oid_ahv13));
        }
        POCDMT000040Patient patient = new POCDMT000040Patient();
        patientRole.setPatient(patient);
        patientRole.getAddr().add(this.getAddress(streetAddrLine, null, postalCode, city, "HP"));
        ArrayList<TEL> telecomList = this.getTelecomList(mobile, phone, phoneBusiness, email);
        if (telecomList.size() > 0) {
            patientRole.getTelecom().addAll(telecomList);
        }
        ArrayList<ENXP> nameList = new ArrayList<ENXP>();
        if (given != null && !given.equals("")) {
            name = new EnGiven();
            name.setContent(given);
            nameList.add(name);
        }
        if (family != null && !family.equals("")) {
            name = new EnFamily();
            name.setContent(family);
            nameList.add(name);
        }
        if (nameList.size() > 0) {
            PN pn = new PN();
            pn.getContent().addAll(nameList);
            patient.getName().add(pn);
        }
        if (isFemale || isMale || isGenderUnknown) {
            CE ce = new CE();
            patient.setAdministrativeGenderCode(ce);
            if (isFemale) {
                ce.setCode("F");
            }
            if (isMale) {
                ce.setCode("M");
            }
            if (isGenderUnknown) {
                ce.setCode("UN");
            }
            ce.setCodeSystem("2.16.840.1.113883.5.1");
        }
        if (birthDate != null) {
            TS ts = new TS();
            ts.setValue(new SimpleDateFormat("yyyyMMdd").format(birthDate));
            patient.setBirthTime(ts);
        }
        return recordTarget;
    }

    public static CE getCode(String codeLoinc, String displayName) {
        CE code = new CE();
        code.setCode(codeLoinc);
        code.setCodeSystem(oid_loinc);
        code.setDisplayName(displayName);
        return code;
    }

    public CE getCodeCommunciation() {
        CE code = new CE();
        code.setCode("47049-2");
        code.setCodeSystem(oid_loinc);
        code.setDisplayName("Communication");
        return code;
    }

    public CE getCodeReferral() {
        CE code = new CE();
        code.setCode("28616-1");
        code.setCodeSystem(oid_loinc);
        code.setDisplayName("Verlegungsbrief");
        return code;
    }

    public CE getCodeDischarge() {
        CE code = new CE();
        code.setCode("34106-5");
        code.setCodeSystem(oid_loinc);
        code.setDisplayName("Zusammenfassung bei Entlassung");
        return code;
    }

    private II getII(String extension, String root) {
        II ii = new II();
        ii.setRoot(root);
        ii.setExtension(extension);
        return ii;
    }

    public II getPidHospital(String id) {
        return this.getII(id, DocboxCDA.getOidPidHospital());
    }

    public II getFidHospital(String id) {
        return this.getII(id, DocboxCDA.getOidFidHospital());
    }

    public POCDMT000040Organization getOrganization(String organizationName, String organizationId, String departmentName, String departmentId, String streetAddrLine, String postalCode, String city) {
        POCDMT000040Organization organization = new POCDMT000040Organization();
        if (organizationId != null) {
            organization.getId().add(this.getII(organizationId, DocboxCDA.getOidOrganiaztionId()));
        }
        if (departmentId != null) {
            organization.getId().add(this.getII(departmentId, DocboxCDA.getOidDepartmentId()));
        }
        if (organizationName != null) {
            ON onOrganizationName = new ON();
            onOrganizationName.getContent().add((Serializable)((Object)organizationName));
            organization.getName().add(onOrganizationName);
        }
        if (departmentName != null) {
            ON onDepartmentName = new ON();
            onDepartmentName.getContent().add((Serializable)((Object)departmentName));
            organization.getName().add(onDepartmentName);
        }
        organization.getAddr().add(this.getAddress(streetAddrLine, null, postalCode, city, "WP"));
        return organization;
    }

    public POCDMT000040InformationRecipient getInformationRecipient(String prefix, String given, String family, String userDocboxId, POCDMT000040Organization organization) {
        POCDMT000040InformationRecipient informationRecipient = new POCDMT000040InformationRecipient();
        informationRecipient.setTypeCode(XInformationRecipient.PRCP);
        informationRecipient.setIntendedRecipient(this.getIntendedRecipient(prefix, given, family, userDocboxId, organization));
        return informationRecipient;
    }

    public POCDMT000040IntendedRecipient getIntendedRecipient(String prefix, String given, String family, String userDocboxId, POCDMT000040Organization organization) {
        ENXP name;
        POCDMT000040IntendedRecipient intendedRecipient = new POCDMT000040IntendedRecipient();
        POCDMT000040Person person = new POCDMT000040Person();
        if (userDocboxId != null) {
            intendedRecipient.getId().add(this.getII(userDocboxId, this.getOidUserDocboxId()));
        }
        ArrayList<ENXP> nameList = new ArrayList<ENXP>();
        if (prefix != null && !prefix.equals("")) {
            name = new EnPrefix();
            name.setContent(prefix);
            nameList.add(name);
        }
        if (given != null && !given.equals("")) {
            name = new EnGiven();
            name.setContent(given);
            nameList.add(name);
        }
        if (family != null && !family.equals("")) {
            name = new EnFamily();
            name.setContent(family);
            nameList.add(name);
        }
        if (nameList.size() > 0) {
            PN pn = new PN();
            pn.getContent().addAll(nameList);
            person.getName().add(pn);
        }
        intendedRecipient.setInformationRecipient(person);
        intendedRecipient.setReceivedOrganization(organization);
        return intendedRecipient;
    }

    public POCDMT000040ClinicalDocument getClinicalDocument(String title, POCDMT000040RecordTarget recordTarget, POCDMT000040Author author, POCDMT000040Custodian custodian, POCDMT000040InformationRecipient informationRecipient, CE code, String documentId, DOCBOXCDATYPE cdaType) {
        POCDMT000040ClinicalDocument cda = new POCDMT000040ClinicalDocument();
        POCDMT000040InfrastructureRootTypeId typeId = new POCDMT000040InfrastructureRootTypeId();
        typeId.setRoot("2.16.840.1.113883.1.3");
        typeId.setExtension("POCD_HD000040");
        cda.setTypeId(typeId);
        cda.getTemplateId().add(this.getII("CDA-CH", oid_hl7));
        if (cdaType != null) {
            cda.getTemplateId().add(this.getII(cdaType.name(), oid_docbox));
        }
        if (documentId == null || "".equals(documentId)) {
            cda.setId(this.getII(new VMID().toString(), oid_hl7));
        } else {
            cda.setId(this.getII(documentId, oid_docbox));
        }
        cda.setCode(code);
        ST stTitle = new ST();
        stTitle.setContent(title);
        cda.setTitle(stTitle);
        TS ts = new TS();
        ts.setValue(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        cda.setEffectiveTime(ts);
        CE confidentialityCode = new CE();
        confidentialityCode.setCode("N");
        confidentialityCode.setCodeSystem("2.16.840.1.113883.5.25");
        cda.setConfidentialityCode(confidentialityCode);
        CS languageCode = new CS();
        languageCode.setCode("de-CH");
        cda.setLanguageCode(languageCode);
        POCDMT000040Component2 component = new POCDMT000040Component2();
        cda.setComponent(component);
        POCDMT000040StructuredBody structureBody = new POCDMT000040StructuredBody();
        component.setStructuredBody(structureBody);
        structureBody.getComponent().addAll(this.listComponent);
        if (this.isElexisInstallationIdAvailable() || this.isOidMedelexisProjectAvailable()) {
            structureBody.getComponent().add(this.createPatientMasterDataId());
        }
        cda.getAuthor().add(author);
        cda.setCustodian(custodian);
        if (informationRecipient != null) {
            cda.getInformationRecipient().add(informationRecipient);
        }
        cda.getRecordTarget().add(recordTarget);
        return cda;
    }

    private POCDMT000040Component3 createPatientMasterDataId() {
        POCDMT000040Component3 component = new POCDMT000040Component3();
        POCDMT000040Section section = new POCDMT000040Section();
        CD cd = new CD();
        cd.setCode("SOFTWARE");
        cd.setCodeSystem("2.16.756.5.30.1.105.2.2");
        CE ce = new CE();
        ce.getNullFlavor().add("NA");
        ce.getTranslation().add(cd);
        section.setCode(ce);
        POCDMT000040Author author = new POCDMT000040Author();
        POCDMT000040AssignedAuthor assignedAuthor = new POCDMT000040AssignedAuthor();
        POCDMT000040AuthoringDevice assignedDevice = new POCDMT000040AuthoringDevice();
        if (this.isOidMedelexisProjectAvailable()) {
            ii = new II();
            ii.setExtension(this.getOidMedelexisProject());
            ii.setRoot("2.16.756.5.30.1.105.4.1.1");
            assignedDevice.getTemplateId().add(ii);
        } else {
            ii = new II();
            ii.setExtension(this.getElexisInstallationId());
            ii.setRoot("2.16.756.5.30.1.105.4.1.2");
            assignedDevice.getTemplateId().add(ii);
        }
        if (this.isOidMedelexisProjectAvailable()) {
            modelName = new SC();
            modelName.setCode("medelexis");
            modelName.setCodeSystem("2.16.756.5.30.1.105.4");
            modelName.setContent("medelexis");
            assignedDevice.setManufacturerModelName(modelName);
        } else {
            modelName = new SC();
            modelName.setCode("elexis");
            modelName.setCodeSystem("2.16.756.5.30.1.105.4");
            modelName.setContent("elexis");
            assignedDevice.setManufacturerModelName(modelName);
        }
        SC softwareName = new SC();
        softwareName.setCode("elexis");
        softwareName.setCodeSystem("2.16.756.5.30.1.105.4");
        softwareName.setContent("elexis");
        assignedDevice.setSoftwareName(softwareName);
        assignedAuthor.setAssignedAuthoringDevice(assignedDevice);
        author.setAssignedAuthor(assignedAuthor);
        section.getAuthor().add(author);
        component.setSection(section);
        return component;
    }

    private String getElexisInstallationId() {
        return ConfigServiceHolder.getGlobal((String)"installation/timestamp", null);
    }

    private boolean isElexisInstallationIdAvailable() {
        return ConfigServiceHolder.getGlobal((String)"installation/timestamp", null) != null;
    }

    private boolean isOidMedelexisProjectAvailable() {
        return CoreHub.localCfg.get("software/oid", null) != null && CoreHub.localCfg.get("medelexis/projectid", null) != null;
    }

    private String getOidMedelexisProject() {
        String oid = CoreHub.localCfg.get("software/oid", null);
        String projectId = CoreHub.localCfg.get("medelexis/projectid", null);
        return oid + ".100." + projectId;
    }

    static synchronized Marshaller getCdaMarshaller() {
        if (marshaller == null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(DocboxCDA.class.getClassLoader());
                JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.hl7.v3");
                marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.setProperty("jaxb.schemaLocation", (Object)"urn:hl7-org:v3 CDA.xsd");
                marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(DocboxCDA.class).error("Failure in JAXBContext.newInstance", (Throwable)e);
                e.printStackTrace(System.out);
                marshaller = null;
            }
            Thread.currentThread().setContextClassLoader(tccl);
        }
        return marshaller;
    }

    static synchronized Unmarshaller getCdaUnmarshaller() {
        if (unmarshaller == null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(DocboxCDA.class.getClassLoader());
                JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.hl7.v3");
                unmarshaller = jaxbContext.createUnmarshaller();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(DocboxCDA.class).error("Failure in JAXBContext.newInstance", (Throwable)e);
                e.printStackTrace(System.out);
                marshaller = null;
            }
            Thread.currentThread().setContextClassLoader(tccl);
        }
        return unmarshaller;
    }

    public String marshallIntoString(POCDMT000040ClinicalDocument cdaType) {
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = DocboxCDA.getCdaMarshaller();
            marshaller.marshal((Object)new JAXBElement(new QName("urn:hl7-org:v3", "ClinicalDocument"), POCDMT000040ClinicalDocument.class, (Object)cdaType), (Writer)writer);
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
        return writer.toString();
    }

    public boolean marshallIntoDom(POCDMT000040ClinicalDocument cdaType, Element element) {
        try {
            Marshaller marshaller = DocboxCDA.getCdaMarshaller();
            marshaller.marshal((Object)new JAXBElement(new QName("urn:hl7-org:v3", "ClinicalDocument"), POCDMT000040ClinicalDocument.class, (Object)cdaType), (Node)element);
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
        return true;
    }

    public boolean marshallIntoDom(POCDMT000040IntendedRecipient indendedRecipient, Document document) {
        try {
            Marshaller marshaller = DocboxCDA.getCdaMarshaller();
            marshaller.marshal((Object)new JAXBElement(new QName("urn:hl7-org:v3", "POCDMT000040IntendedRecipient"), POCDMT000040IntendedRecipient.class, (Object)indendedRecipient), (Node)document);
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
        return true;
    }

    public boolean marshallIntoDom(POCDMT000040ClinicalDocument cdaType, Document document) {
        try {
            Marshaller marshaller = DocboxCDA.getCdaMarshaller();
            marshaller.marshal((Object)new JAXBElement(new QName("urn:hl7-org:v3", "ClinicalDocument"), POCDMT000040ClinicalDocument.class, (Object)cdaType), (Node)document);
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
        return true;
    }

    public POCDMT000040ClinicalDocument unmarshall(String path) {
        try {
            Unmarshaller unmarshaller = DocboxCDA.getCdaUnmarshaller();
            JAXBElement doc = unmarshaller.unmarshal((Source)new StreamSource(new File(path)), POCDMT000040ClinicalDocument.class);
            return (POCDMT000040ClinicalDocument)doc.getValue();
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public boolean addAuftragsnummer(String number) {
        this.addComponentToBody("Auftragsnummer", number, "AOK");
        return true;
    }

    public boolean addVersicherungsklasse(String text) {
        if ("Allgemein".equals(text) || "Halbprivat".equals(text) || "Privat".equals(text) || "Allgemein CH".equals(text) || "Selbstzahler".equals(text)) {
            this.addComponentToBody("Versicherungsklasse", text, "AVK");
            return true;
        }
        return false;
    }

    public boolean addKrankenkasse(String name) {
        this.addComponentToBody("Krankenkasse", name, "AKK");
        return true;
    }

    public boolean addKrankenkassePolicenummer(String name) {
        this.addComponentToBody("Policennummer Krankenkasse", name, "AKP");
        return true;
    }

    public boolean addKrankenkasseZusatzversicherung(String name) {
        this.addComponentToBody("Zusatzversicherung KK", name, "AKZ");
        return true;
    }

    public boolean addKrankenkasseZusatzversicherungPolicenummer(String name) {
        this.addComponentToBody("Policennummer Zusatzversicherung KK", name, "AZP");
        return true;
    }

    public boolean addUnfallversicherung(String name) {
        this.addComponentToBody("Unfallversicherung", name, "AUV");
        return true;
    }

    public boolean addUnfallversicherungPolicenummer(String name) {
        this.addComponentToBody("Policennummer Unfallversicherung", name, "AUP");
        return true;
    }

    public boolean addUnfallZusatzversicherung(String name) {
        this.addComponentToBody("Zusatzversicherung Unfall", name, "AZU");
        return true;
    }

    public boolean addUnfallZusatzversicherungPolicenummer(String name) {
        this.addComponentToBody("Policennummer Zusatzversicherung Unfall", name, "AZPU");
        return true;
    }

    public boolean addArbeitgeber(String name) {
        this.addComponentToBody("Arbeitgeber", name, "AAG");
        return true;
    }

    public boolean addEinweisungsgrund(String text) {
        if ("Krankheit".equals(text) || "Unfall".equals(text) || "Geburt".equals(text) || "Mutterschaft".equals(text) || "Anderer".equals(text)) {
            this.addComponentToBody("Einweisungsgrund", text, "AEG");
            return true;
        }
        return false;
    }

    public boolean addAufenthaltsart(String text) {
        if ("ambulant".equals(text) || "station\u00e4r".equals(text) || "kurzstation\u00e4r".equals(text)) {
            this.addComponentToBody("Aufenthaltsart", text, "AAA");
            return true;
        }
        return false;
    }

    public boolean addEintrittDatum(String name) {
        this.addComponentToBody("Eintritt Datum", name, "AED");
        return true;
    }

    public boolean addEintrittZeit(String name) {
        this.addComponentToBody("Eintritt Zeit", name, "AEZ");
        return true;
    }

    public boolean addEintrittVortag(Boolean value) {
        this.addComponentToBody("Eintritt Vortag", value, "AEV");
        return true;
    }

    public boolean addEintrittNuechtern(Boolean value) {
        this.addComponentToBody(null, value, "AEN");
        return true;
    }

    public boolean addOperationDatum(String name) {
        this.addComponentToBody("Operation Datum", name, "AOPD");
        return true;
    }

    public boolean addOperationZeit(String name) {
        this.addComponentToBody("Operation Zeit", name, "AOPZ");
        return true;
    }

    public boolean addOperationFixZeit(String name) {
        this.addComponentToBody("Fix-Zeit Operation", name, "AOPFZ");
        return true;
    }

    public boolean addDringlichkeit(String name) {
        this.addComponentToBody("Dringlichkeit", name, "ADRINDGLICHKEIT");
        return true;
    }

    public boolean addFruehereAufenthalte(String name) {
        this.addComponentToBody(null, name, "AFAS");
        return true;
    }

    public boolean addHauszarzt(String name) {
        this.addComponentToBody("Name Hauszart", name, "ANH");
        return true;
    }

    public boolean addPraeoperativHausarzt(Boolean value) {
        this.addComponentToBody(null, value, "APH");
        return true;
    }

    public boolean addBemerkungenBeilagen(String name) {
        this.addComponentToBody("Bemerkungen/Beilagen", name, "ABB");
        return true;
    }

    public boolean addGewuenschteLeistung(String nameLeistung, String codeLeistung) {
        this.listComponent.add(this.getComponent(null, nameLeistung, codeLeistung, DocboxCDA.getOidDocboxLeistungId()));
        return true;
    }

    public boolean addErgaenzungenLeistung(String name) {
        this.addComponentToBody(null, name, "LE");
        return true;
    }

    public boolean addKlinischeAngabeFragestellung(String name) {
        this.addComponentToBody("Klinische Angaben/Fragestellung", name, "LKA");
        return true;
    }

    public boolean addDiagnose(String name) {
        this.addComponentToBody("Diagnose", name, "LD");
        return true;
    }

    public boolean addDiagnoseVerlauf(String name) {
        this.addComponentToBody("Diagnose Verlauf", name, "LDV");
        return true;
    }

    public boolean addAnamnese(String name) {
        this.addComponentToBody("Anamnese", name, "LA");
        return true;
    }

    public boolean addPerseoenlicheAnamnese(String name) {
        this.addComponentToBody(null, name, "LAP");
        return true;
    }

    public boolean addGewuenschteKoerperregion(String name, boolean right, boolean left) {
        if (name == null) {
            return false;
        }
        Object text = "";
        if (left) {
            text = (String)text + "Links:";
        }
        if (right) {
            text = (String)text + "Rechts:";
        }
        text = (String)text + name;
        this.addComponentToBody(null, (String)text, "LK");
        return true;
    }

    public String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        int i = 0;
        while (i < in.length()) {
            char current = in.charAt(i);
            if (current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff') {
                out.append(current);
            }
            ++i;
        }
        return out.toString();
    }

    private StrucDocText getStrucDocTextWithBreaks(String[] text) {
        StrucDocText strucDocText = new StrucDocText();
        if (text != null) {
            int i = 0;
            while (i < text.length) {
                String textAdd = this.stripNonValidXMLCharacters(text[i]);
                strucDocText.getContent().add((Serializable)((Object)textAdd));
                if (i != text.length - 1) {
                    strucDocText.getContent().add(new StrucDocBr());
                }
                ++i;
            }
        }
        return strucDocText;
    }

    private StrucDocText getStrucDocTextWithBreaks(String text) {
        String[] texts = text.split("[\\n\\r]+");
        return this.getStrucDocTextWithBreaks(texts);
    }

    public boolean addMedikamente(String[] medikamente) {
        POCDMT000040Component3 component = this.getComponent("Medikamente", null, "KMED");
        component.getSection().setText(this.getStrucDocTextWithBreaks(medikamente));
        this.listComponent.add(component);
        return true;
    }

    public boolean addSchwangerschaft(Boolean schwanger, String bemerkung) {
        String first = "";
        first = schwanger != null && schwanger != false ? "ja:" : (schwanger != null && schwanger == false ? "nein:" : "unbekannt:");
        String text = first + (bemerkung != null ? bemerkung : "");
        this.addComponentToBody("Schwangerschaft/Stillzeit", text, "KSCH");
        return true;
    }

    public boolean addAllergien(Boolean allergie, String allergieListe) {
        String first = "";
        first = allergie != null && allergie != false ? "ja:" : (allergie != null && allergie == false ? "nein:" : "unbekannt:");
        if (allergieListe == null) {
            allergieListe = "";
        }
        this.addComponentToBody("Allergien", first + allergieListe, "KALL");
        return true;
    }

    public boolean addKreatininwert(String value) {
        this.addComponentToBody("Kreatininwert", value, "KKRET");
        return true;
    }

    public boolean addInr(String value) {
        this.addComponentToBody("INR", value, "KINR");
        return true;
    }

    public boolean addThrombozyten(String value) {
        this.addComponentToBody("Thrombozyten", value, "KTHROMBO");
        return true;
    }

    public boolean addSchilddruesenUeberfunktion(Boolean value) {
        this.addComponentToBody(null, value, "KSCHILD");
        return true;
    }

    public boolean addBiguanidMedikation(Boolean value) {
        this.addComponentToBody("Biguanid Medikation", value, "KBIUGANID");
        return true;
    }

    public boolean addHerzschrittmacher(Boolean value) {
        this.addComponentToBody("Herzschrittmacher", value, "KHERZSCHRITT");
        return true;
    }

    public boolean addMetallimplantate(Boolean value) {
        this.addComponentToBody("Metallimplantate", value, "KMETALL");
        return true;
    }

    public boolean addClipsMetallsplitter(Boolean value) {
        this.addComponentToBody("Clips/Metallsplitter", value, "KCLIPS");
        return true;
    }

    public boolean addGehoerimplantat(Boolean value) {
        this.addComponentToBody(null, value, "KGEH\u00d6RIMPL");
        return true;
    }

    public boolean addPlatzangst(Boolean value) {
        this.addComponentToBody("Platzangst", value, "KPLATZANGST");
        return true;
    }

    public boolean addKindZurSedation(Boolean value) {
        this.addComponentToBody("Kind zur Sedation", value, "KKINDSEDATION");
        return true;
    }

    public boolean addOpDauer(String duration) {
        this.addComponentToBody("OP-Dauer (Std/Min)", duration, "KOPD");
        return true;
    }

    public boolean addAufenthaltsdauer(String days) {
        this.addComponentToBody("Aufenthaltsdauer (in Tagen)", days, "KOPAUF");
        return true;
    }

    public boolean addOperateur(String duration) {
        this.addComponentToBody("Operateur", duration, "KOPERATEUR");
        return true;
    }

    public boolean addOpAssistent(String value) {
        this.addComponentToBody("OP-Assistent", value, "KOPASSISTANT");
        return true;
    }

    public boolean addInstrumente(String[] liste) {
        POCDMT000040Component3 component = this.getComponent("Instrumente", null, "KINSTRUMENT");
        component.getSection().setText(this.getStrucDocTextWithBreaks(liste));
        this.listComponent.add(component);
        return true;
    }

    public boolean addLagerung(String[] liste) {
        POCDMT000040Component3 component = this.getComponent("Lagerung", null, "KLAGERUNG");
        component.getSection().setText(this.getStrucDocTextWithBreaks(liste));
        this.listComponent.add(component);
        return true;
    }

    public boolean addAnaesthesie(String[] liste) {
        POCDMT000040Component3 component = this.getComponent(null, null, "KAN\u00c4STHESIE");
        component.getSection().setText(this.getStrucDocTextWithBreaks(liste));
        this.listComponent.add(component);
        return true;
    }

    public boolean addAnaesthesieSprechstunde(Boolean value) {
        this.addComponentToBody(null, value, "KAN\u00c4STHESIEAUFBIETEN");
        return true;
    }

    public boolean addDocumentIdInSection(String value) {
        this.addComponentToBody("DocumentID", value, "DOCID");
        return true;
    }

    public boolean addDatumAufgebot(String value) {
        this.addComponentToBody("Datum Aufgebot", value, "MDATUMAUFGEBOT");
        return true;
    }

    public boolean addDatumAufgebotAenderung(String value) {
        this.addComponentToBody(null, value, "MDATUMAUFGEBOT\u00c4NDERUNG");
        return true;
    }

    public boolean addDatumEintritt(String value) {
        this.addComponentToBody("Datum Eintritt", value, "MDATUMEINTRITT");
        return true;
    }

    public boolean addDatumStornoEintritt(String value) {
        this.addComponentToBody("Datum Storno Eintritt", value, "MDATUMSTORNOEINTRITT");
        return true;
    }

    public boolean addDatumAustritt(String value) {
        this.addComponentToBody("Austritt", value, "MDATUMAUSRITT");
        return true;
    }

    public boolean addDatumStornoAustritt(String value) {
        this.addComponentToBody("Storno Austritt", value, "MDATUMSTORNOAUSTRITT");
        return true;
    }

    public static enum DOCBOXCDATYPE {
        Eingang_Anmeldung,
        Datum_Aufgebot,
        Eintritt,
        Austritt,
        Dossier_Freigabe,
        Dossier_Freigabe_Beendet,
        Docbox_Spital_Anmeldung,
        Docbox_Spital_Arzt,
        Docbox_Arzt_Arzt,
        Docbox_Nachricht;

    }
}

